/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class JvmAbi {
    public static final int VERSION = 17;
    public static final String TRAIT_IMPL_CLASS_NAME = "$TImpl";
    public static final String TRAIT_IMPL_SUFFIX = "$$TImpl";
    public static final String DEFAULT_PARAMS_IMPL_SUFFIX = "$default";
    public static final String GETTER_PREFIX = "get";
    public static final String SETTER_PREFIX = "set";
    public static final String CLASS_OBJECT_CLASS_NAME = "object";
    public static final String CLASS_OBJECT_SUFFIX = "$object";
    public static final String DELEGATED_PROPERTY_NAME_SUFFIX = "$delegate";
    public static final String PROPERTY_METADATA_ARRAY_NAME = "$propertyMetadata";
    public static final String ANNOTATED_PROPERTY_METHOD_NAME_SUFFIX = "$annotations";
    public static final String INSTANCE_FIELD = "INSTANCE$";
    public static final String CLASS_OBJECT_FIELD = "OBJECT$";
    public static final FqName K_OBJECT = new FqName("kotlin.jvm.internal.KObject");
    public static final String KOTLIN_CLASS_FIELD_NAME = "$kotlinClass";
    public static final String KOTLIN_PACKAGE_FIELD_NAME = "$kotlinPackage";

    public static boolean isClassObjectFqName(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/JvmAbi", "isClassObjectFqName"));
        }
        return fqName.lastSegmentIs(Name.identifier(CLASS_OBJECT_CLASS_NAME));
    }

    @NotNull
    public static String getSyntheticMethodNameForAnnotatedProperty(@NotNull Name propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/jet/lang/resolve/java/JvmAbi", "getSyntheticMethodNameForAnnotatedProperty"));
        }
        String string = propertyName.asString() + ANNOTATED_PROPERTY_METHOD_NAME_SUFFIX;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmAbi", "getSyntheticMethodNameForAnnotatedProperty"));
        }
        return string;
    }

    @NotNull
    public static String getDefaultFieldNameForProperty(@NotNull Name propertyName, boolean isDelegated) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/jet/lang/resolve/java/JvmAbi", "getDefaultFieldNameForProperty"));
        }
        String string = isDelegated ? propertyName.asString() + DELEGATED_PROPERTY_NAME_SUFFIX : propertyName.asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmAbi", "getDefaultFieldNameForProperty"));
        }
        return string;
    }

    private JvmAbi() {
    }
}

