/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public abstract class ErrorValue
extends CompileTimeConstant<Void> {
    public ErrorValue() {
        super(null, true, false, false);
    }

    @Override
    @Deprecated
    public Void getValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data2) {
        return visitor.visitErrorValue(this, data2);
    }

    @NotNull
    public static ErrorValue create(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/jet/lang/resolve/constants/ErrorValue", "create"));
        }
        ErrorValueWithMessage errorValueWithMessage = new ErrorValueWithMessage(message);
        if (errorValueWithMessage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/ErrorValue", "create"));
        }
        return errorValueWithMessage;
    }

    public static class ErrorValueWithMessage
    extends ErrorValue {
        private final String message;

        public ErrorValueWithMessage(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/jet/lang/resolve/constants/ErrorValue$ErrorValueWithMessage", "<init>"));
            }
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
            if (kotlinBuiltIns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinBuiltIns", "org/jetbrains/jet/lang/resolve/constants/ErrorValue$ErrorValueWithMessage", "getType"));
            }
            JetType jetType = ErrorUtils.createErrorType(this.message);
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/ErrorValue$ErrorValueWithMessage", "getType"));
            }
            return jetType;
        }

        public String toString() {
            return this.getMessage();
        }
    }
}

