/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.util;

import com.intellij.lang.ASTNode;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralArgument;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;

public class DelegatingCall
implements Call {
    private final Call delegate;

    public DelegatingCall(@NotNull Call delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/jet/lang/resolve/calls/util/DelegatingCall", "<init>"));
        }
        this.delegate = delegate;
    }

    @Override
    @Nullable
    public ASTNode getCallOperationNode() {
        return this.delegate.getCallOperationNode();
    }

    @Override
    @NotNull
    public ReceiverValue getExplicitReceiver() {
        ReceiverValue receiverValue = this.delegate.getExplicitReceiver();
        if (receiverValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/util/DelegatingCall", "getExplicitReceiver"));
        }
        return receiverValue;
    }

    @Override
    @NotNull
    public ReceiverValue getThisObject() {
        ReceiverValue receiverValue = this.delegate.getThisObject();
        if (receiverValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/util/DelegatingCall", "getThisObject"));
        }
        return receiverValue;
    }

    @Override
    @Nullable
    public JetExpression getCalleeExpression() {
        return this.delegate.getCalleeExpression();
    }

    @Override
    @Nullable
    public JetValueArgumentList getValueArgumentList() {
        return this.delegate.getValueArgumentList();
    }

    @Override
    @NotNull
    public List<? extends ValueArgument> getValueArguments() {
        List<? extends ValueArgument> list = this.delegate.getValueArguments();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/util/DelegatingCall", "getValueArguments"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<JetFunctionLiteralArgument> getFunctionLiteralArguments() {
        List<JetFunctionLiteralArgument> list = this.delegate.getFunctionLiteralArguments();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/util/DelegatingCall", "getFunctionLiteralArguments"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<JetTypeProjection> getTypeArguments() {
        List<JetTypeProjection> list = this.delegate.getTypeArguments();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/util/DelegatingCall", "getTypeArguments"));
        }
        return list;
    }

    @Override
    @Nullable
    public JetTypeArgumentList getTypeArgumentList() {
        return this.delegate.getTypeArgumentList();
    }

    @Override
    @NotNull
    public JetElement getCallElement() {
        JetElement jetElement = this.delegate.getCallElement();
        if (jetElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/util/DelegatingCall", "getCallElement"));
        }
        return jetElement;
    }

    @Override
    @NotNull
    public Call.CallType getCallType() {
        Call.CallType callType = this.delegate.getCallType();
        if (callType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/util/DelegatingCall", "getCallType"));
        }
        return callType;
    }
}

