/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.tasks;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.LibrarySourceHacks;
import org.jetbrains.jet.lang.resolve.calls.tasks.CallableDescriptorCollector;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;

public class CallableDescriptorCollectors<D extends CallableDescriptor>
implements Iterable<CallableDescriptorCollector<D>> {
    private static final CallableDescriptorCollector<FunctionDescriptor> FUNCTIONS_COLLECTOR = new FilteredCollector<FunctionDescriptor>(new FunctionCollector());
    private static final CallableDescriptorCollector<VariableDescriptor> VARIABLES_COLLECTOR = new FilteredCollector<VariableDescriptor>(new VariableCollector());
    private static final CallableDescriptorCollector<VariableDescriptor> PROPERTIES_COLLECTOR = new FilteredCollector<VariableDescriptor>(new PropertyCollector());
    public static final CallableDescriptorCollectors<CallableDescriptor> FUNCTIONS_AND_VARIABLES = new CallableDescriptorCollectors(FUNCTIONS_COLLECTOR, VARIABLES_COLLECTOR);
    public static final CallableDescriptorCollectors<CallableDescriptor> FUNCTIONS = new CallableDescriptorCollectors(FUNCTIONS_COLLECTOR);
    public static final CallableDescriptorCollectors<VariableDescriptor> VARIABLES = new CallableDescriptorCollectors(VARIABLES_COLLECTOR);
    public static final CallableDescriptorCollectors<VariableDescriptor> PROPERTIES = new CallableDescriptorCollectors(PROPERTIES_COLLECTOR);
    private final Collection<CallableDescriptorCollector<D>> collectors;

    private CallableDescriptorCollectors(CallableDescriptorCollector<D> ... collectors) {
        this.collectors = Lists.newArrayList(collectors);
    }

    @Override
    @NotNull
    public Iterator<CallableDescriptorCollector<D>> iterator() {
        Iterator<CallableDescriptorCollector<D>> iterator2 = this.collectors.iterator();
        if (iterator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors", "iterator"));
        }
        return iterator2;
    }

    private static class FilteredCollector<D extends CallableDescriptor>
    implements CallableDescriptorCollector<D> {
        private final CallableDescriptorCollector<D> delegate;

        private FilteredCollector(CallableDescriptorCollector<D> delegate) {
            this.delegate = delegate;
        }

        @Override
        @NotNull
        public Collection<D> getNonExtensionsByName(JetScope scope, Name name, @NotNull BindingTrace bindingTrace) {
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FilteredCollector", "getNonExtensionsByName"));
            }
            List<D> list = LibrarySourceHacks.filterOutMembersFromLibrarySource(this.delegate.getNonExtensionsByName(scope, name, bindingTrace));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FilteredCollector", "getNonExtensionsByName"));
            }
            return list;
        }

        @Override
        @NotNull
        public Collection<D> getMembersByName(@NotNull JetType receiver, Name name, @NotNull BindingTrace bindingTrace) {
            if (receiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FilteredCollector", "getMembersByName"));
            }
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FilteredCollector", "getMembersByName"));
            }
            List<D> list = LibrarySourceHacks.filterOutMembersFromLibrarySource(this.delegate.getMembersByName(receiver, name, bindingTrace));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FilteredCollector", "getMembersByName"));
            }
            return list;
        }

        @Override
        @NotNull
        public Collection<D> getNonMembersByName(JetScope scope, Name name, @NotNull BindingTrace bindingTrace) {
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FilteredCollector", "getNonMembersByName"));
            }
            List<D> list = LibrarySourceHacks.filterOutMembersFromLibrarySource(this.delegate.getNonMembersByName(scope, name, bindingTrace));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FilteredCollector", "getNonMembersByName"));
            }
            return list;
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private static class PropertyCollector
    implements CallableDescriptorCollector<VariableDescriptor> {
        private PropertyCollector() {
        }

        private static Collection<VariableDescriptor> filterProperties(Collection<? extends VariableDescriptor> variableDescriptors) {
            ArrayList<VariableDescriptor> properties = Lists.newArrayList();
            for (VariableDescriptor variableDescriptor : variableDescriptors) {
                if (!(variableDescriptor instanceof PropertyDescriptor)) continue;
                properties.add(variableDescriptor);
            }
            return properties;
        }

        @Override
        @NotNull
        public Collection<VariableDescriptor> getNonExtensionsByName(JetScope scope, Name name, @NotNull BindingTrace bindingTrace) {
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$PropertyCollector", "getNonExtensionsByName"));
            }
            Collection<VariableDescriptor> collection = PropertyCollector.filterProperties(VARIABLES_COLLECTOR.getNonExtensionsByName(scope, name, bindingTrace));
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$PropertyCollector", "getNonExtensionsByName"));
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<VariableDescriptor> getMembersByName(@NotNull JetType receiver, Name name, @NotNull BindingTrace bindingTrace) {
            if (receiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$PropertyCollector", "getMembersByName"));
            }
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$PropertyCollector", "getMembersByName"));
            }
            Collection<VariableDescriptor> collection = PropertyCollector.filterProperties(VARIABLES_COLLECTOR.getMembersByName(receiver, name, bindingTrace));
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$PropertyCollector", "getMembersByName"));
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<VariableDescriptor> getNonMembersByName(JetScope scope, Name name, @NotNull BindingTrace bindingTrace) {
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$PropertyCollector", "getNonMembersByName"));
            }
            Collection<VariableDescriptor> collection = PropertyCollector.filterProperties(VARIABLES_COLLECTOR.getNonMembersByName(scope, name, bindingTrace));
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$PropertyCollector", "getNonMembersByName"));
            }
            return collection;
        }

        public String toString() {
            return "PROPERTIES";
        }
    }

    private static class VariableCollector
    implements CallableDescriptorCollector<VariableDescriptor> {
        private VariableCollector() {
        }

        @Override
        @NotNull
        public Collection<VariableDescriptor> getNonExtensionsByName(JetScope scope, Name name, @NotNull BindingTrace bindingTrace) {
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$VariableCollector", "getNonExtensionsByName"));
            }
            VariableDescriptor localVariable = scope.getLocalVariable(name);
            if (localVariable != null) {
                Set<VariableDescriptor> set = Collections.singleton(localVariable);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$VariableCollector", "getNonExtensionsByName"));
                }
                return set;
            }
            LinkedHashSet<VariableDescriptor> variables = Sets.newLinkedHashSet();
            for (VariableDescriptor variable : scope.getProperties(name)) {
                if (variable.getReceiverParameter() != null) continue;
                variables.add(variable);
            }
            LinkedHashSet<VariableDescriptor> linkedHashSet = variables;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$VariableCollector", "getNonExtensionsByName"));
            }
            return linkedHashSet;
        }

        @Override
        @NotNull
        public Collection<VariableDescriptor> getMembersByName(@NotNull JetType receiverType, Name name, @NotNull BindingTrace bindingTrace) {
            if (receiverType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverType", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$VariableCollector", "getMembersByName"));
            }
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$VariableCollector", "getMembersByName"));
            }
            Collection<VariableDescriptor> collection = receiverType.getMemberScope().getProperties(name);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$VariableCollector", "getMembersByName"));
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<VariableDescriptor> getNonMembersByName(JetScope scope, Name name, @NotNull BindingTrace bindingTrace) {
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$VariableCollector", "getNonMembersByName"));
            }
            LinkedHashSet<VariableDescriptor> result2 = Sets.newLinkedHashSet();
            VariableDescriptor localVariable = scope.getLocalVariable(name);
            if (localVariable != null) {
                result2.add(localVariable);
            }
            result2.addAll(scope.getProperties(name));
            LinkedHashSet<VariableDescriptor> linkedHashSet = result2;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$VariableCollector", "getNonMembersByName"));
            }
            return linkedHashSet;
        }

        public String toString() {
            return "VARIABLES";
        }
    }

    private static class FunctionCollector
    implements CallableDescriptorCollector<FunctionDescriptor> {
        private FunctionCollector() {
        }

        @Override
        @NotNull
        public Collection<FunctionDescriptor> getNonExtensionsByName(JetScope scope, Name name, @NotNull BindingTrace bindingTrace) {
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FunctionCollector", "getNonExtensionsByName"));
            }
            LinkedHashSet<FunctionDescriptor> functions2 = Sets.newLinkedHashSet();
            for (FunctionDescriptor function : scope.getFunctions(name)) {
                if (function.getReceiverParameter() != null) continue;
                functions2.add(function);
            }
            FunctionCollector.addConstructors(scope, name, functions2);
            LinkedHashSet<FunctionDescriptor> linkedHashSet = functions2;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FunctionCollector", "getNonExtensionsByName"));
            }
            return linkedHashSet;
        }

        @Override
        @NotNull
        public Collection<FunctionDescriptor> getMembersByName(@NotNull JetType receiverType, Name name, @NotNull BindingTrace bindingTrace) {
            if (receiverType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverType", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FunctionCollector", "getMembersByName"));
            }
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FunctionCollector", "getMembersByName"));
            }
            JetScope receiverScope = receiverType.getMemberScope();
            HashSet<FunctionDescriptor> members = Sets.newHashSet(receiverScope.getFunctions(name));
            FunctionCollector.addConstructors(receiverScope, name, members);
            HashSet<FunctionDescriptor> hashSet = members;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FunctionCollector", "getMembersByName"));
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<FunctionDescriptor> getNonMembersByName(JetScope scope, Name name, @NotNull BindingTrace bindingTrace) {
            if (bindingTrace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FunctionCollector", "getNonMembersByName"));
            }
            Collection<FunctionDescriptor> collection = scope.getFunctions(name);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/CallableDescriptorCollectors$FunctionCollector", "getNonMembersByName"));
            }
            return collection;
        }

        private static void addConstructors(JetScope scope, Name name, Collection<FunctionDescriptor> functions2) {
            ClassifierDescriptor classifier2 = scope.getClassifier(name);
            if (!(classifier2 instanceof ClassDescriptor) || ErrorUtils.isError(classifier2)) {
                return;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)classifier2;
            if (classDescriptor.getKind().isSingleton()) {
                return;
            }
            functions2.addAll(classDescriptor.getConstructors());
        }

        public String toString() {
            return "FUNCTIONS";
        }
    }
}

