/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.resolve.calls.CallResolverExtension;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;

public abstract class RecursiveCallResolverExtension
implements CallResolverExtension {
    @Override
    public <F extends CallableDescriptor> void run(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/lang/resolve/calls/RecursiveCallResolverExtension", "run"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/RecursiveCallResolverExtension", "run"));
        }
        if (RecursiveCallResolverExtension.isRecursion(resolvedCall, context) && context.call.getCallElement() instanceof JetCallExpression) {
            this.runImpl((JetCallExpression)context.call.getCallElement(), resolvedCall, context);
        }
    }

    protected abstract <F extends CallableDescriptor> void runImpl(@NotNull JetCallExpression var1, @NotNull ResolvedCall<F> var2, @NotNull BasicCallResolutionContext var3);

    private static <F extends CallableDescriptor> boolean isRecursion(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/lang/resolve/calls/RecursiveCallResolverExtension", "isRecursion"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/RecursiveCallResolverExtension", "isRecursion"));
        }
        return resolvedCall.getResultingDescriptor().getOriginal().equals(context.scope.getContainingDeclaration());
    }
}

