/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.Function1;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KObject;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.jvm.internal.InternalPackage;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetSafeQualifiedExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$completeArguments$1;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$completeArguments$2;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$completeArguments$3;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$completeArguments$4;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$completeConstraintSystem$1;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$completeConstraintSystem$2;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$completeConstraintSystem$3;
import org.jetbrains.jet.lang.resolve.calls.CallCompleter$updateRecordedTypeForArgument$1;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.CandidateResolver;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.callUtil.CallUtilPackage-callUtil-2020e762;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemCompleter;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.jet.lang.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.jet.lang.resolve.calls.model.ArgumentMapping;
import org.jetbrains.jet.lang.resolve.calls.model.ArgumentMatch;
import org.jetbrains.jet.lang.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.jet.lang.resolve.calls.results.ResolutionStatus;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;

@KotlinClass(abiVersion=17, data={"\u0003\u0010)i1)\u00197m\u0007>l\u0007\u000f\\3uKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7OC\u0002kKRTA\u0001\\1oO*9!/Z:pYZ,'\"B2bY2\u001c(bA!os*11n\u001c;mS:Ta\u0001P5oSRt$\u0002F1sOVlWM\u001c;UsB,'+Z:pYZ,'O\u0003\u000bBe\u001e,X.\u001a8u)f\u0004XMU3t_24XM\u001d\u0006\u0012G\u0006tG-\u001b3bi\u0016\u0014Vm]8mm\u0016\u0014(\"E\"b]\u0012LG-\u0019;f%\u0016\u001cx\u000e\u001c<fe*9r-\u001a;Be\u001e,X.\u001a8u)f\u0004XMU3t_24XM\u001d\u0006\u0015O\u0016$8)\u00198eS\u0012\fG/\u001a*fg>dg/\u001a:\u000b\u0003\u0011S!cQ1mY\u0006\u0014G.\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe*YA-Z:de&\u0004Ho\u001c:t\u0015U\u0019w.\u001c9mKR,\u0017\t\u001c7DC:$\u0017\u000eZ1uKNTqaY8oi\u0016DHO\u0003\u000eCCNL7mQ1mYJ+7o\u001c7vi&|gnQ8oi\u0016DHOC\u0004sKN,H\u000e^:\u000b;=3XM\u001d7pC\u0012\u0014Vm]8mkRLwN\u001c*fgVdGo]%na2TA!\u00168ji*\t2m\\7qY\u0016$X-\u0011:hk6,g\u000e^:\u000b\u0019\r|W\u000e\u001d7fi\u0016\u001c\u0015\r\u001c7\u000b\u000fQ\u0014\u0018mY5oO*yAK]1dS:<7\u000b\u001e:bi\u0016<\u0017PC\u0003uCN\\7OC\fd_6\u0004H.\u001a;f\u0007\u0006dGNR8s\u0003J<W/\\3oi*QQ\r\u001f9sKN\u001c\u0018n\u001c8\u000b\u001b)+G/\u0012=qe\u0016\u001c8/[8o\u0015\r\u00018/\u001b\u0006\u0014\u001bV$\u0018M\u00197f%\u0016\u001cx\u000e\u001c<fI\u000e\u000bG\u000e\u001c\u0006\u0006[>$W\r\u001c\u0006\u0019G>l\u0007\u000f\\3uK\u000e{gn\u001d;sC&tGoU=ti\u0016l'\u0002D3ya\u0016\u001cG/\u001a3UsB,'b\u0002&fiRK\b/\u001a\u0006\u0006if\u0004Xm\u001d\u0006\u0006iJ\f7-\u001a\u0006\r\u0005&tG-\u001b8h)J\f7-\u001a\u0006\u0014G>l\u0007\u000f\\3uK>sW-\u0011:hk6,g\u000e\u001e\u0006\u000em\u0006dW/Z!sOVlWM\u001c;\u000b\u001bY\u000bG.^3Be\u001e,X.\u001a8u\u0015\u0001\u001aw.\u001c9mKR,'+Z:pYZ,GmQ1mY\u0006sG-\u0011:hk6,g\u000e^:\u000b\u0019I,7o\u001c7wK\u0012\u001c\u0015\r\u001c7\u000b%\u001d,GoQ1mY\u001a{'/\u0011:hk6,g\u000e\u001e\u0006\tCJ<W/\\3oi*q!-\u001b8eS:<7i\u001c8uKb$(B\u0004\"j]\u0012LgnZ\"p]R,\u0007\u0010\u001e\u0006\u0005\u0007\u0006dGN\u0003\u000biCNtUmY3tg\u0006\u0014\u0018pU1gK\u000e\u000bG\u000e\u001c\u0006\b\u0005>|G.Z1o\u0015u)\b\u000fZ1uKJ+7m\u001c:eK\u0012$\u0016\u0010]3G_J\f%oZ;nK:$(bC;qI\u0006$X\r\u001a+za\u0016TAB]3d_J$W\r\u001a+za\u0016T!#\u0019:hk6,g\u000e^#yaJ,7o]5p]*QS\u000f\u001d3bi\u0016\u0014Vm]8mkRLwN\\*uCR,8O\u0012:p[\u000e{gn\u001d;sC&tGoU=ti\u0016l\u0007U\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0005\u0011\u0011\u0001bA\u0003\u0004\t\u000bA\u0001\u0001\u0004\u0001\u0006\u0003!!Qa\u0001C\u0004\u0011\u000fa\u0001!B\u0002\u0005\u0006!-A\u0002A\u0003\u0004\t\u000bAi\u0001\u0004\u0001\u0006\u0005\u0011\u0015\u00012B\u0003\u0003\t\u000bAi!\u0002\u0002\u0005\u0004!IQa\u0001C\u0007\u0011#a\u0001!\u0002\u0002\u0005\u0006!QQa\u0001C\b\u0011+a\u0001!\u0002\u0002\u0005\u0006!YQa\u0001C\t\u0011/a\u0001!B\u0002\u0005\b!aA\u0002A\u0003\u0003\t\u001fA)\"\u0002\u0002\u0005\u0012!]QA\u0001C\u0003\u0011;)1\u0001B\u0006\t\u001d1\u0001QA\u0001\u0003\f\u00119)!\u0001b\u0001\t\"\u0015\u0019A\u0011\u0004\u0005\u0011\u0019\u0001)!\u0001\"\u0007\t!\u0015\u0011AQ\u0001E\u0012\u000b\r!a\u0002C\t\r\u0001\u0015\u0011A1\u0001E\u0014\u000b\r!q\u0002C\n\r\u0001\u0015\u0019AA\u0001E\u0015\u0019\u0001)!\u0001\u0002\b\t#\u0015\u0011Aa\u0004\u0005\u0014\u000b\t!!\u0001#\u000b\u0006\u0007\u0011e\u0001B\u0006\u0007\u0001\u000b\t!I\u0002\u0003\f\u0006\u0007\u0011\u0011\u0001\"\u0007\u0007\u0001\u000b\r!I\u0002c\r\r\u0001\u0015\u0011A\u0011\u0004E\u001a\u000b\t!!\u0001C\r\u0006\u0007\u0011\u001d\u0001R\u0007\u0007\u0001\t\ra1!\u0007\u0002\u0006\u0003!!Qf\u0004\u0003a\ta)\u0011EA\u0003\u0002\u0011\u0013)6\u0001C\u0003\u0004\t\u0015I\u0011\u0001c\u0003\u000e\u0007\u00119\u0011\"\u0001E\u0006[=!\u0001\r\u0002\r\u0007C\t)\u0011\u0001C\u0003V\u0007!)1\u0001\u0002\u0004\n\u0003!1Qb\u0001C\b\u0013\u0005Aa!l\u0014\u0005\u0003E)A\u0001\u0001\u0005\t+\t)\u0011\u0001C\u0004\u0019\u0014u5A\u0001\u0001\u0005\u000b\u001b\t)\u0011\u0001\u0003\u0005Q\u0007\u0001i:\u0002\u0002\u0001\t\u001759Q!\u0001\u0005\n\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001\u0001k!\u0001\"\u0005\u0015\t\u00012C)\u0004\u000f\u0011M\u0011\"\u0001\u0003\u0001\u001b\u0005A!\"D\u0001\t\u00165>C!A\t\u0006\t\u0001A\u0001\"\u0006\u0002\u0006\u0003!9\u0001\u0014DO\u0007\t\u0001A!\"\u0004\u0002\u0006\u0003!A\u0001k\u0001\u0001\u001e\u0018\u0011\u0001\u0001bC\u0007\b\u000b\u0005A\u0011\"\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001\u0005\u0001!\u000e\u0005\u0011EA\u0003\u0002\u0011'\t6a\u0002C\r\u0013\u0005!\u0001!D\u0001\t\u00155\t\u0001RC\u00177\t\u0001\tR\u0001\u0002\u0001\t\u0011U\u0011Q!\u0001\u0005\b15ij\u0001\u0002\u0001\t\u00155\u0011Q!\u0001\u0005\t!\u000e\u0001Qt\u0003\u0003\u0001\u0011-iq!B\u0001\t\u0013%!\u0011bA\u0003\u0003\t\u0003A\u0001\u0001UB\u0001;\u001b!\u0001\u0001c\u0007\u000e\u0005\u0015\t\u0001r\u0003)\u0004\u0003\u0005:Q!\u0001\u0005\n\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001\u0011kA\u0005\u0005\u001b%\t\u0001RC\u0007\u0002\u0011)i\u0011\u0001#\u0006\u000e\u0003!aQv\t\u0003\u00021=ij\u0001\u0002\u0001\t 5\u0011Q!\u0001\u0005\u000e!\u000e\u0001QT\u0002\u0003\u0001\u0011)i!!B\u0001\t\u0011A\u001b\t!I\u0005\u0006\u0003!I\u0011\"\u0002C\u0001\u0013\r)\u0011\u0001C\u0004\r\u00021\u0005\u0011kA\u0004\u0005\u001f%\t\u0001RC\u0007\u0002\u00117i\u0011\u0001\u0003\u0006.Z\u0011\t\u0011#\u0002\u0003\u0001\u0011!)\"!B\u0001\t\u000fU9Q!\u0001E\u000f\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001\u0001DEO\u0007\t\u0001A)#\u0004\u0002\u0006\u0003!}\u0001k!\u0001\u001e\u000e\u0011\u0001\u0001\u0002F\u0007\u0003\u000b\u0005A\u0001\u0003U\u0002\u0002C\t)\u0011\u0001c\u0005R\u0007%!!#C\u0001\u0005\u00015\t\u0001\u0012E\u0007\u0002\u0011Ei\u0011\u0001c\t.:\u0011\t\u0001$FO\u0007\t\u0001AY#\u0004\u0002\u0006\u0003!\u0011\u0002k\u0001\u0001\u001e\u000e\u0011\u0001\u0001BC\u0007\u0003\u000b\u0005A\u0001\u0002UB\u0001C\t)\u0011\u0001c\u0005R\u0007\u001d!Q#C\u0001\u0005\u00015\t\u0001RE\u0007\u0002\u0011)i\u000b\u0019\u0001\u0003\u0002#\u0015!\u0001\u0001\u0003\u0005\u0016\u0005\u0015\t\u0001b\u0002M\u0017;3!\u0001\u0001C\f\u000e\u0011\u0015\t\u0001RD\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u00011\u0005\u0001k\u0001\u0001\u001e\u0018\u0011\u0001\u0001bC\u0007\b\u000b\u0005A\u0011\"\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001\u0005\u0001!\u000e\u0005QT\u0002\u0003\u0001\u0011)i!!B\u0001\t\u0011A\u001b\u0011!(\u0004\u0005\u0001!mQBA\u0003\u0002\u0011/\u000161A\u0011\u0003\u000b\u0005A\u0019\"U\u0002\f\t[I\u0011\u0001\u0002\u0001\u000e\u0003!\u0005R\"\u0001E\u000b\u001b\u0005A!\"D\u0001\t\u00195vB!\u0001M\u0018;\u001f!\u0001\u0001\u0003\r\u000e\u0007\u0015\t\u0001\"\u0004G\u0001!\u000e\u0001QT\u0002\u0003\u0001\u0011ci!!B\u0001\t'A\u001b\t!I\u0002\u0006\u0003!\u001dB\u0012A)\u0004\u000f\u0011=\u0012\"\u0001\u0005\u0015\u001b\u0005AY\"D\u0001\t*5fB!\u0001\r\u001b;\u001b!\u0001\u0001c\b\u000e\u0005\u0015\t\u0001\"\u0004)\u0004\u0001u5A\u0001\u0001\u0005\u0015\u001b\t)\u0011\u0001\u0003\tQ\u0007\u0003\t#!B\u0001\t+E\u001bq\u0001\u0002\u000e\n\u0003\u0011\u0005Q\"\u0001E\u000e\u001b\u0005A\u0019#l\u0019\u0005\u0003aYRt\u0002\u0003\u0001\u0011oi1!B\u0001\t 1\u0005\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0002H\u0007\u0004\u000b\u0005Ay\u0002$\u0001Q\u0007\u0003ij\u0001\u0002\u0001\t:5\u0011Q!\u0001\u0005\u000e!\u000e\tQT\u0002\u0003\u0001\u0011Qi!!B\u0001\t!A\u001b\u0019!\t\u0002\u0006\u0003!M\u0011kA\u0006\u00057%\tA\u0001A\u0007\u0002\u0011Ei\u0011\u0001C\t\u000e\u0003!mQ\"\u0001E\u0012[3\"\u0011!E\u0003\u0005\u0001!AQCA\u0003\u0002\u0011\u001d)r!B\u0001\t\u001e%!\u0011bA\u0003\u0003\t\u0003A\u0001\u0001G\u000f\u001e\u000e\u0011\u0001\u0001BC\u0007\u0003\u000b\u0005A\u0001\u0002UB\u0001;\u001b!\u0001\u0001c\u0007\u000e\u0005\u0015\t\u0001r\u0003)\u0004\u0003\u0005\u0012Q!\u0001E\n#\u000eIA!H\u0005\u0002\t\u0001i\u0011\u0001#\t\u000e\u0003!QQ\"\u0001\u0005\rky)Q\u0004Br\u00011\u0013ij\u0001\u0002\u0001\t\u000b5\u0011Q!\u0001E\u0005!\u000e\u0001QT\u0002\u0003\u0001\u0011\u0019i!!B\u0001\t\u000bA\u001b\t!\t\u0002\u0006\u0003!\u0019\u0011kA\u0004\u0005\n%\tA\u0001A\u0007\u0002\u0011\u0017i\u0011\u0001\u0003\u0004"})
public final class CallCompleter
implements KObject {
    public static final /* synthetic */ KClassImpl $kotlinClass;
    @NotNull
    private final ArgumentTypeResolver argumentTypeResolver;
    @NotNull
    private final CandidateResolver candidateResolver;

    static {
        $kotlinClass = InternalPackage.kClassFromKotlin(CallCompleter.class);
    }

    @NotNull
    public final <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> completeCall(@JetValueParameter(name="context") @NotNull BasicCallResolutionContext context, @JetValueParameter(name="results") @NotNull OverloadResolutionResultsImpl<D> results, @JetValueParameter(name="tracing") @NotNull TracingStrategy tracing) {
        Unit unit;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeCall"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeCall"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeCall"));
        }
        ResolvedCall resolvedCall = results.isSingleResult() ? results.getResultingCall() : (MutableResolvedCall)null;
        if (!CallResolverUtil.isInvokeCallOnVariable(((CallResolutionContext)context).call)) {
            TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(((ResolutionContext)context).trace, "Trace to complete a resulting call");
            this.completeResolvedCallAndArguments((MutableResolvedCall<D>)resolvedCall, results, (BasicCallResolutionContext)context.replaceBindingTrace(temporaryTrace), tracing);
            this.completeAllCandidates(context, results);
            temporaryTrace.commit();
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        if (resolvedCall2 != null) {
            ResolvedCall resolvedCall3 = resolvedCall2;
            MutableResolvedCall it = (MutableResolvedCall)resolvedCall3;
            ((ResolutionContext)context).callResolverExtension.run(it, context);
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
        if (results.isSingleResult() ? results.getResultingCall().getStatus().isSuccess() : false) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = results.changeStatusToSuccess();
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeCall"));
            }
            return overloadResolutionResultsImpl;
        }
        OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = results;
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeCall"));
        }
        return overloadResolutionResultsImpl;
    }

    private final <D extends CallableDescriptor> void completeAllCandidates(@JetValueParameter(name="context") BasicCallResolutionContext context, @JetValueParameter(name="results") OverloadResolutionResultsImpl<D> results) {
        Collection<ResolvedCall<D>> collection;
        if (((ResolutionContext)context).collectAllCandidates) {
            collection = results.getAllCandidates();
            if (collection == null) {
                Intrinsics.throwNpe();
            }
        } else {
            collection = results.getResultingCalls();
        }
        if (collection == null) {
            throw new TypeCastException("kotlin.MutableCollection<out org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall<D>?> cannot be cast to kotlin.Collection<org.jetbrains.jet.lang.resolve.calls.model.MutableResolvedCall<D>>");
        }
        Collection<ResolvedCall<D>> candidates = collection;
        Iterable iterable = candidates;
        Iterable iterable2 = iterable;
        Collection collection22 = new ArrayList();
        Iterator iterator2 = iterable2.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            MutableResolvedCall resolvedCall = (MutableResolvedCall)t;
            Object object2 = !resolvedCall.isCompleted() ? Boolean.valueOf(collection22.add(t)) : Unit.INSTANCE$;
        }
        iterable = (ArrayList)collection22;
        for (Collection collection22 : iterable) {
            MutableResolvedCall resolvedCall = (MutableResolvedCall)((Object)collection22);
            TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(((ResolutionContext)context).trace, "Trace to complete a candidate that is not a resulting call");
            CallCompleter.completeResolvedCallAndArguments$b$0(this, resolvedCall, results, (BasicCallResolutionContext)context.replaceBindingTrace(temporaryBindingTrace), TracingStrategy.EMPTY);
        }
    }

    private final <D extends CallableDescriptor> void completeResolvedCallAndArguments(@JetValueParameter(name="resolvedCall", type="?") MutableResolvedCall<D> resolvedCall, @JetValueParameter(name="results") OverloadResolutionResultsImpl<D> results, @JetValueParameter(name="context") BasicCallResolutionContext context, @JetValueParameter(name="tracing") TracingStrategy tracing) {
        boolean bl;
        boolean bl2 = true;
        if (resolvedCall != null) {
            bl2 = false;
        }
        if (!(!bl2 ? resolvedCall.isCompleted() : true)) {
            bl = true;
            if (resolvedCall.getConstraintSystem() != null) {
                bl = false;
            }
        } else {
            bl = true;
        }
        if (bl) {
            Unit unit;
            this.completeArguments(context, results);
            MutableResolvedCall<D> mutableResolvedCall = resolvedCall;
            if (mutableResolvedCall != null) {
                mutableResolvedCall.markCallAsCompleted();
                unit = Unit.INSTANCE$;
            } else {
                unit = null;
            }
            return;
        }
        this.completeConstraintSystem(resolvedCall, ((ResolutionContext)context).expectedType, ((ResolutionContext)context).trace);
        this.completeArguments(context, results);
        this.updateResolutionStatusFromConstraintSystem(resolvedCall, context, tracing);
        resolvedCall.markCallAsCompleted();
    }

    private final <D extends CallableDescriptor> void completeConstraintSystem(@JetValueParameter(name="$receiver") MutableResolvedCall<D> $receiver, @JetValueParameter(name="expectedType") JetType expectedType, @JetValueParameter(name="trace") BindingTrace trace) {
        CallCompleter$completeConstraintSystem$1 callCompleter$completeConstraintSystem$1 = new CallCompleter$completeConstraintSystem$1($receiver);
        JetType returnType = $receiver.getCandidateDescriptor().getReturnType();
        boolean bl = true;
        if (returnType == null) {
            bl = false;
        }
        if (bl) {
            ConstraintSystem constraintSystem = $receiver.getConstraintSystem();
            if (constraintSystem == null) {
                Intrinsics.throwNpe();
            }
            constraintSystem.addSupertypeConstraint(expectedType, returnType, ConstraintPosition.EXPECTED_TYPE_POSITION);
            if (expectedType == TypeUtils.UNIT_EXPECTED_TYPE) {
                callCompleter$completeConstraintSystem$1.invoke(new CallCompleter$completeConstraintSystem$2(returnType));
            }
        }
        ConstraintSystemCompleter constraintSystemCompleter = (ConstraintSystemCompleter)trace.get(BindingContext.CONSTRAINT_SYSTEM_COMPLETER, $receiver.getCall().getCalleeExpression());
        boolean bl2 = true;
        if (constraintSystemCompleter == null) {
            bl2 = false;
        }
        if (bl2) {
            callCompleter$completeConstraintSystem$1.invoke(new CallCompleter$completeConstraintSystem$3($receiver, constraintSystemCompleter));
        }
        ConstraintSystem constraintSystem = $receiver.getConstraintSystem();
        if (constraintSystem == null) {
            throw new TypeCastException("org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem? cannot be cast to org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemImpl");
        }
        ((ConstraintSystemImpl)constraintSystem).processDeclaredBoundConstraints();
        ConstraintSystem constraintSystem2 = $receiver.getConstraintSystem();
        if (constraintSystem2 == null) {
            Intrinsics.throwNpe();
        }
        $receiver.setResultingSubstitutor(constraintSystem2.getResultingSubstitutor());
    }

    private final <D extends CallableDescriptor> void updateResolutionStatusFromConstraintSystem(@JetValueParameter(name="$receiver") MutableResolvedCall<D> $receiver, @JetValueParameter(name="context") BasicCallResolutionContext context, @JetValueParameter(name="tracing") TracingStrategy tracing) {
        CallCandidateResolutionContext<D> contextWithResolvedCall = CallCandidateResolutionContext.createForCallBeingAnalyzed($receiver, context, tracing);
        CandidateResolver.ValueArgumentsCheckingResult valueArgumentsCheckingResult = this.candidateResolver.checkAllValueArguments(contextWithResolvedCall, ((ResolutionContext)context).trace, CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        ResolutionStatus status = $receiver.getStatus();
        ConstraintSystem constraintSystem = $receiver.getConstraintSystem();
        if (constraintSystem == null) {
            Intrinsics.throwNpe();
        }
        if (constraintSystem.getStatus().isSuccessful()) {
            if (!Intrinsics.areEqual((Object)status, (Object)ResolutionStatus.UNKNOWN_STATUS) ? Intrinsics.areEqual((Object)status, (Object)ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) : true) {
                $receiver.setStatusToSuccess();
            }
            return;
        }
        JetType receiverType = $receiver.getReceiverArgument().exists() ? $receiver.getReceiverArgument().getType() : (JetType)null;
        Object d = $receiver.getCandidateDescriptor();
        ConstraintSystem constraintSystem2 = $receiver.getConstraintSystem();
        if (constraintSystem2 == null) {
            Intrinsics.throwNpe();
        }
        InferenceErrorData errorData = InferenceErrorData.create(d, constraintSystem2, valueArgumentsCheckingResult.argumentTypes, receiverType, ((ResolutionContext)context).expectedType);
        tracing.typeInferenceFailed(((ResolutionContext)context).trace, errorData);
        $receiver.addStatus(ResolutionStatus.OTHER_ERROR);
    }

    private final <D extends CallableDescriptor> void completeArguments(@JetValueParameter(name="context") BasicCallResolutionContext context, @JetValueParameter(name="results") OverloadResolutionResultsImpl<D> results) {
        Function1 getDataFlowInfoForArgument;
        Function1 getArgumentMapping;
        if (Intrinsics.areEqual((Object)((CallResolutionContext)context).checkArguments, (Object)CheckValueArgumentsMode.DISABLED)) {
            return;
        }
        if (results.isSingleResult()) {
            ResolvedCall resolvedCall = results.getResultingCall();
            getArgumentMapping = new CallCompleter$completeArguments$1((MutableResolvedCall)resolvedCall);
            getDataFlowInfoForArgument = new CallCompleter$completeArguments$2((MutableResolvedCall)resolvedCall);
        } else {
            getArgumentMapping = CallCompleter$completeArguments$3.INSTANCE$;
            getDataFlowInfoForArgument = new CallCompleter$completeArguments$4(context);
        }
        Iterator<? extends ValueArgument> iterator2 = ((CallResolutionContext)context).call.getValueArguments().iterator();
        while (iterator2.hasNext()) {
            ArgumentMapping argumentMapping;
            ArgumentMapping argumentMapping2;
            ValueArgument valueArgument;
            ValueArgument valueArgument2 = valueArgument = iterator2.next();
            if (valueArgument2 == null) {
                Intrinsics.throwNpe();
            }
            JetType expectedType = (argumentMapping2 = (argumentMapping = (ArgumentMapping)getArgumentMapping.invoke(valueArgument2))) instanceof ArgumentMatch ? CandidateResolver.getEffectiveExpectedType(((ArgumentMatch)argumentMapping).getValueParameter(), valueArgument) : TypeUtils.NO_EXPECTED_TYPE;
            BasicCallResolutionContext newContext = (BasicCallResolutionContext)((BasicCallResolutionContext)context.replaceDataFlowInfo((DataFlowInfo)getDataFlowInfoForArgument.invoke(valueArgument))).replaceExpectedType(expectedType);
            this.completeOneArgument(valueArgument, newContext);
        }
    }

    private final void completeOneArgument(@JetValueParameter(name="valueArgument") ValueArgument valueArgument, @JetValueParameter(name="context") BasicCallResolutionContext context) {
        JetType recordedType;
        if (valueArgument.isExternal()) {
            return;
        }
        JetExpression expression = valueArgument.getArgumentExpression();
        boolean bl = true;
        if (expression != null) {
            bl = false;
        }
        if (bl) {
            return;
        }
        JetType updatedType = recordedType = (JetType)((ResolutionContext)context).trace.get(BindingContext.EXPRESSION_TYPE, expression);
        OverloadResolutionResultsImpl<? extends CallableDescriptor> results = this.completeCallForArgument(expression, context);
        boolean bl2 = true;
        if (results == null) {
            bl2 = false;
        }
        if (bl2 ? results.isSingleResult() : false) {
            JetType jetType;
            ResolvedCall resolvedCall = results.getResultingCall();
            if (resolvedCall.hasInferredReturnType()) {
                Object d = resolvedCall.getResultingDescriptor();
                jetType = d != null ? d.getReturnType() : null;
            } else {
                jetType = null;
            }
            updatedType = jetType;
        }
        boolean bl3 = true;
        if (recordedType == null) {
            bl3 = false;
        }
        boolean bl4 = bl3 ? !recordedType.getConstructor().isDenotable() : false;
        if (bl4) {
            BasicCallResolutionContext basicCallResolutionContext = context;
            if (basicCallResolutionContext == null) {
                throw new TypeCastException("org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext cannot be cast to org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext<out org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext<Context>?>");
            }
            updatedType = ArgumentTypeResolver.updateResultArgumentTypeIfNotDenotable(basicCallResolutionContext, expression);
        }
        this.updateRecordedTypeForArgument(updatedType, recordedType, expression, ((ResolutionContext)context).trace);
        if (ArgumentTypeResolver.isFunctionLiteralArgument(expression)) {
            BasicCallResolutionContext basicCallResolutionContext = context;
            if (basicCallResolutionContext == null) {
                throw new TypeCastException("org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext cannot be cast to org.jetbrains.jet.lang.resolve.calls.context.CallResolutionContext<out org.jetbrains.jet.lang.resolve.calls.context.CallResolutionContext<Context>?>");
            }
            this.argumentTypeResolver.getFunctionLiteralTypeInfo(expression, ArgumentTypeResolver.getFunctionLiteralArgument(expression), basicCallResolutionContext, CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        }
        BasicCallResolutionContext basicCallResolutionContext = context;
        if (basicCallResolutionContext == null) {
            throw new TypeCastException("org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext cannot be cast to org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext<out org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext<Context>?>");
        }
        DataFlowUtils.checkType(updatedType, expression, (ResolutionContext)basicCallResolutionContext);
    }

    private final OverloadResolutionResultsImpl<? extends CallableDescriptor> completeCallForArgument(@JetValueParameter(name="expression") JetExpression expression, @JetValueParameter(name="context") BasicCallResolutionContext context) {
        Call argumentCall = this.getCallForArgument(expression, ((ResolutionContext)context).trace.getBindingContext());
        boolean bl = true;
        if (argumentCall != null) {
            bl = false;
        }
        if (bl) {
            return null;
        }
        ResolutionResultsCache.CachedData cachedDataForCall = ((ResolutionContext)context).resolutionResultsCache.get(argumentCall);
        boolean bl2 = true;
        if (cachedDataForCall != null) {
            bl2 = false;
        }
        if (bl2) {
            return null;
        }
        ResolutionResultsCache.CachedData cachedData = cachedDataForCall;
        OverloadResolutionResultsImpl<? extends CallableDescriptor> cachedResolutionResults = cachedData.component1();
        BasicCallResolutionContext cachedContext = cachedData.component2();
        TracingStrategy tracing = cachedData.component3();
        OverloadResolutionResultsImpl<? extends CallableDescriptor> cachedResults = null;
        OverloadResolutionResultsImpl<? extends CallableDescriptor> overloadResolutionResultsImpl = cachedResolutionResults;
        if (overloadResolutionResultsImpl == null) {
            throw new TypeCastException("org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl<out org.jetbrains.jet.lang.descriptors.CallableDescriptor?> cannot be cast to org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl<org.jetbrains.jet.lang.descriptors.CallableDescriptor>");
        }
        cachedResults = overloadResolutionResultsImpl;
        BasicCallResolutionContext contextForArgument = (BasicCallResolutionContext)((BasicCallResolutionContext)((BasicCallResolutionContext)cachedContext.replaceBindingTrace(((ResolutionContext)context).trace)).replaceExpectedType(((ResolutionContext)context).expectedType)).replaceCollectAllCandidates(false);
        return this.completeCall(contextForArgument, cachedResults, tracing);
    }

    private final Call getCallForArgument(@JetValueParameter(name="argument", type="?") JetExpression argument, @JetValueParameter(name="bindingContext") BindingContext bindingContext) {
        if (!ExpressionTypingUtils.dependsOnExpectedType(argument)) {
            return null;
        }
        if (argument instanceof JetBlockExpression) {
            JetElement lastStatement = JetPsiUtil.getLastStatementInABlock((JetBlockExpression)argument);
            JetElement jetElement = lastStatement;
            if (!(jetElement instanceof JetExpression)) {
                jetElement = null;
            }
            return this.getCallForArgument((JetExpression)jetElement, bindingContext);
        }
        JetExpression jetExpression = argument;
        return jetExpression != null ? CallUtilPackage-callUtil-2020e762.getCall(jetExpression, bindingContext) : null;
    }

    private final void updateRecordedTypeForArgument(@JetValueParameter(name="updatedType", type="?") JetType updatedType, @JetValueParameter(name="recordedType", type="?") JetType recordedType, @JetValueParameter(name="argumentExpression") JetExpression argumentExpression, @JetValueParameter(name="trace") BindingTrace trace) {
        if (Intrinsics.areEqual(recordedType, updatedType)) {
            return;
        }
        CallCompleter$updateRecordedTypeForArgument$1 callCompleter$updateRecordedTypeForArgument$1 = CallCompleter$updateRecordedTypeForArgument$1.INSTANCE$;
        ArrayList<JetExpression> expressions = new ArrayList<JetExpression>();
        JetExpression expression = argumentExpression;
        while (true) {
            boolean bl = true;
            if (expression == null) {
                bl = false;
            }
            if (!bl) break;
            JetExpression jetExpression = expression;
            if (jetExpression == null) {
                Intrinsics.throwNpe();
            }
            expressions.add(jetExpression);
            expression = callCompleter$updateRecordedTypeForArgument$1.invoke(expression);
        }
        Iterable iterable = expressions;
        for (Object t : iterable) {
            JetExpression expression2 = (JetExpression)t;
            BindingContextUtils.updateRecordedType(updatedType, expression2, trace, CallCompleter.hasNecessarySafeCall$b$1(this, expression2, trace));
        }
    }

    private final boolean hasNecessarySafeCall(@JetValueParameter(name="expression") JetExpression expression, @JetValueParameter(name="trace") BindingTrace trace) {
        if (!(expression instanceof JetSafeQualifiedExpression)) {
            return false;
        }
        JetType expressionType = (JetType)trace.get(BindingContext.EXPRESSION_TYPE, ((JetSafeQualifiedExpression)expression).getReceiverExpression());
        boolean bl = true;
        if (expressionType == null) {
            bl = false;
        }
        return bl ? expressionType.isNullable() : false;
    }

    @NotNull
    public final ArgumentTypeResolver getArgumentTypeResolver() {
        ArgumentTypeResolver argumentTypeResolver = this.argumentTypeResolver;
        if (argumentTypeResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "getArgumentTypeResolver"));
        }
        return argumentTypeResolver;
    }

    @NotNull
    public final CandidateResolver getCandidateResolver() {
        CandidateResolver candidateResolver = this.candidateResolver;
        if (candidateResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "getCandidateResolver"));
        }
        return candidateResolver;
    }

    public CallCompleter(@JetValueParameter(name="argumentTypeResolver") @NotNull ArgumentTypeResolver argumentTypeResolver, @JetValueParameter(name="candidateResolver") @NotNull CandidateResolver candidateResolver) {
        if (argumentTypeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypeResolver", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "<init>"));
        }
        if (candidateResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateResolver", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "<init>"));
        }
        this.argumentTypeResolver = argumentTypeResolver;
        this.candidateResolver = candidateResolver;
    }

    public static final /* synthetic */ boolean hasNecessarySafeCall$b$1(@JetValueParameter(name="$this", type="?") CallCompleter $this, @JetValueParameter(name="expression") @NotNull JetExpression expression, @JetValueParameter(name="trace") @NotNull BindingTrace trace) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "hasNecessarySafeCall$b$1"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "hasNecessarySafeCall$b$1"));
        }
        return $this.hasNecessarySafeCall(expression, trace);
    }

    public static final /* synthetic */ <D extends CallableDescriptor> void completeResolvedCallAndArguments$b$0(@JetValueParameter(name="$this", type="?") CallCompleter $this, @JetValueParameter(name="resolvedCall", type="?") @Nullable MutableResolvedCall<D> resolvedCall, @JetValueParameter(name="results") @NotNull OverloadResolutionResultsImpl<D> results, @JetValueParameter(name="context") @NotNull BasicCallResolutionContext context, @JetValueParameter(name="tracing") @NotNull TracingStrategy tracing) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeResolvedCallAndArguments$b$0"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeResolvedCallAndArguments$b$0"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/CallCompleter", "completeResolvedCallAndArguments$b$0"));
        }
        $this.completeResolvedCallAndArguments(resolvedCall, results, context, tracing);
    }
}

