/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.parsing.JetScriptDefinition;
import org.jetbrains.jet.lang.parsing.JetScriptDefinitionProvider;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetPackageDirective;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class ScriptNameUtil {
    private ScriptNameUtil() {
    }

    @NotNull
    public static FqName classNameForScript(JetScript script) {
        JetFile file = script.getContainingJetFile();
        JetScriptDefinition scriptDefinition = JetScriptDefinitionProvider.getInstance(file.getProject()).findScriptDefinition(file);
        String name = file.getName();
        int index = name.lastIndexOf(47);
        if (index != -1) {
            name = name.substring(index + 1);
        }
        if (name.endsWith(scriptDefinition.getExtension())) {
            name = name.substring(0, name.length() - scriptDefinition.getExtension().length());
        } else {
            index = name.indexOf(46);
            if (index != -1) {
                name = name.substring(0, index);
            }
        }
        name = Character.toUpperCase(name.charAt(0)) + (name.length() == 0 ? "" : name.substring(1));
        name = name.replace('.', '_');
        JetPackageDirective directive = file.getPackageDirective();
        if (directive != null && directive.getQualifiedName().length() > 0) {
            name = directive.getQualifiedName() + "." + name;
        }
        FqName fqName = new FqName(name);
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/ScriptNameUtil", "classNameForScript"));
        }
        return fqName;
    }
}

