/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ScriptDescriptorImpl;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetImportsFactory;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.Importer;
import org.jetbrains.jet.lang.resolve.JetModuleUtil;
import org.jetbrains.jet.lang.resolve.QualifiedExpressionResolver;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;

public class ImportsResolver {
    @NotNull
    private ModuleDescriptor moduleDescriptor;
    @NotNull
    private QualifiedExpressionResolver qualifiedExpressionResolver;
    @NotNull
    private BindingTrace trace;
    @NotNull
    private JetImportsFactory importsFactory;

    public void setModuleDescriptor(@NotNull ModuleDescriptor moduleDescriptor) {
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/jet/lang/resolve/ImportsResolver", "setModuleDescriptor"));
        }
        this.moduleDescriptor = moduleDescriptor;
    }

    public void setTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/ImportsResolver", "setTrace"));
        }
        this.trace = trace;
    }

    public void setQualifiedExpressionResolver(@NotNull QualifiedExpressionResolver qualifiedExpressionResolver) {
        if (qualifiedExpressionResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedExpressionResolver", "org/jetbrains/jet/lang/resolve/ImportsResolver", "setQualifiedExpressionResolver"));
        }
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
    }

    public void setImportsFactory(@NotNull JetImportsFactory importsFactory) {
        if (importsFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importsFactory", "org/jetbrains/jet/lang/resolve/ImportsResolver", "setImportsFactory"));
        }
        this.importsFactory = importsFactory;
    }

    public void processTypeImports(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/ImportsResolver", "processTypeImports"));
        }
        this.processImports(c, QualifiedExpressionResolver.LookupMode.ONLY_CLASSES);
    }

    public void processMembersImports(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/ImportsResolver", "processMembersImports"));
        }
        this.processImports(c, QualifiedExpressionResolver.LookupMode.EVERYTHING);
    }

    private void processImports(@NotNull TopDownAnalysisContext c, @NotNull QualifiedExpressionResolver.LookupMode lookupMode) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/ImportsResolver", "processImports"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupMode", "org/jetbrains/jet/lang/resolve/ImportsResolver", "processImports"));
        }
        for (JetFile file : c.getFiles()) {
            if (file.isScript()) continue;
            WritableScope fileScope = c.getFileScopes().get(file);
            this.processImportsInFile(lookupMode, fileScope, Lists.newArrayList(file.getImportDirectives()), file.getPackageFqName().isRoot());
        }
        for (JetScript script : c.getScripts().keySet()) {
            WritableScope scriptScope = ((ScriptDescriptorImpl)c.getScripts().get(script)).getScopeForBodyResolution();
            this.processImportsInFile(lookupMode, scriptScope, script.getContainingJetFile().getImportDirectives(), true);
        }
    }

    private void processImportsInFile(@NotNull QualifiedExpressionResolver.LookupMode lookupMode, WritableScope scope, List<JetImportDirective> directives, boolean inRootPackage) {
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupMode", "org/jetbrains/jet/lang/resolve/ImportsResolver", "processImportsInFile"));
        }
        ImportsResolver.processImportsInFile(lookupMode, scope, directives, this.moduleDescriptor, this.trace, this.qualifiedExpressionResolver, this.importsFactory, inRootPackage);
    }

    private static void processImportsInFile(QualifiedExpressionResolver.LookupMode lookupMode, @NotNull WritableScope fileScope, @NotNull List<JetImportDirective> importDirectives, @NotNull ModuleDescriptor module, @NotNull BindingTrace trace, @NotNull QualifiedExpressionResolver qualifiedExpressionResolver, @NotNull JetImportsFactory importsFactory, boolean inRootPackage) {
        if (fileScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileScope", "org/jetbrains/jet/lang/resolve/ImportsResolver", "processImportsInFile"));
        }
        if (importDirectives == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDirectives", "org/jetbrains/jet/lang/resolve/ImportsResolver", "processImportsInFile"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/lang/resolve/ImportsResolver", "processImportsInFile"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/ImportsResolver", "processImportsInFile"));
        }
        if (qualifiedExpressionResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedExpressionResolver", "org/jetbrains/jet/lang/resolve/ImportsResolver", "processImportsInFile"));
        }
        if (importsFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importsFactory", "org/jetbrains/jet/lang/resolve/ImportsResolver", "processImportsInFile"));
        }
        JetScope rootScope = JetModuleUtil.getSubpackagesOfRootScope(module);
        Importer.DelayedImporter delayedImporter = new Importer.DelayedImporter(fileScope);
        if (lookupMode == QualifiedExpressionResolver.LookupMode.EVERYTHING) {
            fileScope.clearImports();
        }
        for (ImportPath defaultImportPath : module.getDefaultImports()) {
            TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(trace, "transient trace to resolve default imports");
            JetImportDirective defaultImportDirective = importsFactory.createImportDirective(defaultImportPath);
            qualifiedExpressionResolver.processImportReference(defaultImportDirective, rootScope, fileScope, delayedImporter, temporaryTrace, module, lookupMode);
        }
        HashMap<JetImportDirective, Collection<? extends DeclarationDescriptor>> resolvedDirectives = Maps.newHashMap();
        JetScope rootScopeForFile = JetModuleUtil.getImportsResolutionScope(module, inRootPackage);
        for (JetImportDirective importDirective : importDirectives) {
            Collection<? extends DeclarationDescriptor> descriptors = qualifiedExpressionResolver.processImportReference(importDirective, rootScopeForFile, fileScope, delayedImporter, trace, module, lookupMode);
            if (!descriptors.isEmpty()) {
                resolvedDirectives.put(importDirective, descriptors);
            }
            if (lookupMode == QualifiedExpressionResolver.LookupMode.ONLY_CLASSES) continue;
            ImportsResolver.checkPlatformTypesMappedToKotlin(module, trace, importDirective, descriptors);
        }
        delayedImporter.processImports();
        if (lookupMode == QualifiedExpressionResolver.LookupMode.EVERYTHING) {
            for (JetImportDirective importDirective : importDirectives) {
                ImportsResolver.reportUselessImport(importDirective, fileScope, (Collection)resolvedDirectives.get(importDirective), trace);
            }
        }
    }

    public static void checkPlatformTypesMappedToKotlin(@NotNull ModuleDescriptor module, @NotNull BindingTrace trace, @NotNull JetImportDirective importDirective, @NotNull Collection<? extends DeclarationDescriptor> descriptors) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/lang/resolve/ImportsResolver", "checkPlatformTypesMappedToKotlin"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/ImportsResolver", "checkPlatformTypesMappedToKotlin"));
        }
        if (importDirective == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDirective", "org/jetbrains/jet/lang/resolve/ImportsResolver", "checkPlatformTypesMappedToKotlin"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/ImportsResolver", "checkPlatformTypesMappedToKotlin"));
        }
        JetExpression importedReference = importDirective.getImportedReference();
        if (importedReference != null) {
            for (DeclarationDescriptor declarationDescriptor : descriptors) {
                ImportsResolver.reportPlatformClassMappedToKotlin(module, trace, importedReference, declarationDescriptor);
            }
        }
    }

    public static void reportPlatformClassMappedToKotlin(@NotNull ModuleDescriptor module, @NotNull BindingTrace trace, @NotNull JetElement element, @NotNull DeclarationDescriptor descriptor) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/lang/resolve/ImportsResolver", "reportPlatformClassMappedToKotlin"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/ImportsResolver", "reportPlatformClassMappedToKotlin"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/resolve/ImportsResolver", "reportPlatformClassMappedToKotlin"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/ImportsResolver", "reportPlatformClassMappedToKotlin"));
        }
        if (!(descriptor instanceof ClassDescriptor)) {
            return;
        }
        PlatformToKotlinClassMap platformToKotlinMap = module.getPlatformToKotlinClassMap();
        Collection<ClassDescriptor> kotlinAnalogsForClass = platformToKotlinMap.mapPlatformClass((ClassDescriptor)descriptor);
        if (!kotlinAnalogsForClass.isEmpty()) {
            trace.report(Errors.PLATFORM_CLASS_MAPPED_TO_KOTLIN.on(element, kotlinAnalogsForClass));
        }
    }

    public static void reportUselessImport(@NotNull JetImportDirective importDirective, @NotNull JetScope fileScope, @Nullable Collection<? extends DeclarationDescriptor> resolvedDirectives, @NotNull BindingTrace trace) {
        if (importDirective == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDirective", "org/jetbrains/jet/lang/resolve/ImportsResolver", "reportUselessImport"));
        }
        if (fileScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileScope", "org/jetbrains/jet/lang/resolve/ImportsResolver", "reportUselessImport"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/ImportsResolver", "reportUselessImport"));
        }
        JetExpression importedReference = importDirective.getImportedReference();
        if (importedReference == null || resolvedDirectives == null) {
            return;
        }
        Name aliasName = JetPsiUtil.getAliasName(importDirective);
        if (aliasName == null) {
            return;
        }
        boolean uselessHiddenImport = true;
        for (DeclarationDescriptor declarationDescriptor : resolvedDirectives) {
            DeclarationDescriptor isResolved = null;
            if (declarationDescriptor instanceof ClassDescriptor) {
                isResolved = fileScope.getClassifier(aliasName);
            } else if (declarationDescriptor instanceof VariableDescriptor) {
                isResolved = fileScope.getLocalVariable(aliasName);
            } else if (declarationDescriptor instanceof PackageViewDescriptor) {
                isResolved = fileScope.getPackage(aliasName);
            }
            if (isResolved != null && !isResolved.equals(declarationDescriptor)) continue;
            uselessHiddenImport = false;
        }
        if (uselessHiddenImport) {
            trace.report(Errors.USELESS_HIDDEN_IMPORT.on(importedReference));
        }
        if (!importDirective.isAllUnder() && importedReference instanceof JetSimpleNameExpression && importDirective.getAliasName() == null) {
            trace.report(Errors.USELESS_SIMPLE_IMPORT.on(importedReference));
        }
    }
}

