/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SourceElement;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertySetterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ReceiverParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.jet.lang.types.JetType;

public class DescriptorFactory {
    private DescriptorFactory() {
    }

    @NotNull
    public static PropertySetterDescriptorImpl createDefaultSetter(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createDefaultSetter"));
        }
        PropertySetterDescriptorImpl propertySetterDescriptorImpl = DescriptorFactory.createSetter(propertyDescriptor, true);
        if (propertySetterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createDefaultSetter"));
        }
        return propertySetterDescriptorImpl;
    }

    @NotNull
    public static PropertySetterDescriptorImpl createSetter(@NotNull PropertyDescriptor propertyDescriptor, boolean isDefault) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createSetter"));
        }
        PropertySetterDescriptorImpl setterDescriptor = new PropertySetterDescriptorImpl(propertyDescriptor, Annotations.EMPTY, propertyDescriptor.getModality(), propertyDescriptor.getVisibility(), !isDefault, isDefault, CallableMemberDescriptor.Kind.DECLARATION, null, SourceElement.NO_SOURCE);
        setterDescriptor.initializeDefault();
        PropertySetterDescriptorImpl propertySetterDescriptorImpl = setterDescriptor;
        if (propertySetterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createSetter"));
        }
        return propertySetterDescriptorImpl;
    }

    @NotNull
    public static PropertyGetterDescriptorImpl createDefaultGetter(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createDefaultGetter"));
        }
        PropertyGetterDescriptorImpl propertyGetterDescriptorImpl = DescriptorFactory.createGetter(propertyDescriptor, true);
        if (propertyGetterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createDefaultGetter"));
        }
        return propertyGetterDescriptorImpl;
    }

    @NotNull
    public static PropertyGetterDescriptorImpl createGetter(@NotNull PropertyDescriptor propertyDescriptor, boolean isDefault) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createGetter"));
        }
        PropertyGetterDescriptorImpl propertyGetterDescriptorImpl = new PropertyGetterDescriptorImpl(propertyDescriptor, Annotations.EMPTY, propertyDescriptor.getModality(), propertyDescriptor.getVisibility(), !isDefault, isDefault, CallableMemberDescriptor.Kind.DECLARATION, null, SourceElement.NO_SOURCE);
        if (propertyGetterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createGetter"));
        }
        return propertyGetterDescriptorImpl;
    }

    @NotNull
    public static ConstructorDescriptorImpl createPrimaryConstructorForObject(@NotNull ClassDescriptor containingClass, @NotNull SourceElement source) {
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createPrimaryConstructorForObject"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createPrimaryConstructorForObject"));
        }
        DefaultConstructorDescriptor defaultConstructorDescriptor = new DefaultConstructorDescriptor(containingClass, source);
        if (defaultConstructorDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createPrimaryConstructorForObject"));
        }
        return defaultConstructorDescriptor;
    }

    public static boolean isDefaultPrimaryConstructor(@NotNull ConstructorDescriptor constructor) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "isDefaultPrimaryConstructor"));
        }
        return constructor instanceof DefaultConstructorDescriptor;
    }

    @Nullable
    public static ReceiverParameterDescriptor createReceiverParameterForCallable(@NotNull CallableDescriptor owner, @Nullable JetType receiverParameterType) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createReceiverParameterForCallable"));
        }
        return receiverParameterType == null ? ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER : new ReceiverParameterDescriptorImpl(owner, receiverParameterType, new ExtensionReceiver(owner, receiverParameterType));
    }

    private static class DefaultConstructorDescriptor
    extends ConstructorDescriptorImpl {
        public DefaultConstructorDescriptor(@NotNull ClassDescriptor containingClass, @NotNull SourceElement source) {
            if (containingClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/jet/lang/resolve/DescriptorFactory$DefaultConstructorDescriptor", "<init>"));
            }
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/jet/lang/resolve/DescriptorFactory$DefaultConstructorDescriptor", "<init>"));
            }
            super(containingClass, null, Annotations.EMPTY, true, CallableMemberDescriptor.Kind.DECLARATION, source);
            this.initialize(Collections.<TypeParameterDescriptor>emptyList(), Collections.<ValueParameterDescriptor>emptyList(), DescriptorUtils.getDefaultConstructorVisibility(containingClass), true);
        }
    }
}

