/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorByExpressionSpecifier;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;

public final class DelegationResolver<T extends CallableMemberDescriptor> {
    @NotNull
    private final JetClassOrObject classOrObject;
    @NotNull
    private final ClassDescriptor ownerDescriptor;
    @NotNull
    private final Collection<? extends CallableDescriptor> existingMembers;
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final MemberExtractor<T> memberExtractor;
    @NotNull
    private final TypeResolver typeResolver;

    public static void generateDelegatesInAClass(@NotNull MutableClassDescriptor classDescriptor, final @NotNull BindingTrace trace, @NotNull JetClassOrObject jetClassOrObject) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DelegationResolver", "generateDelegatesInAClass"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DelegationResolver", "generateDelegatesInAClass"));
        }
        if (jetClassOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetClassOrObject", "org/jetbrains/jet/lang/resolve/DelegationResolver", "generateDelegatesInAClass"));
        }
        TypeResolver eagerTypeResolver = new TypeResolver(){

            @Override
            @Nullable
            public JetType resolve(@NotNull JetTypeReference reference) {
                if (reference == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/jet/lang/resolve/DelegationResolver$1", "resolve"));
                }
                return trace.get(BindingContext.TYPE, reference);
            }
        };
        MemberExtractor<CallableMemberDescriptor> eagerExtractor = new MemberExtractor<CallableMemberDescriptor>(){

            @Override
            @NotNull
            public Collection<CallableMemberDescriptor> getMembersByType(@NotNull JetType type) {
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/DelegationResolver$2", "getMembersByType"));
                }
                Collection<Object> collection = Collections2.filter(type.getMemberScope().getAllDescriptors(), Predicates.instanceOf(CallableMemberDescriptor.class));
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DelegationResolver$2", "getMembersByType"));
                }
                return collection;
            }
        };
        Set<CallableMemberDescriptor> existingMembers = classDescriptor.getAllCallableMembers();
        Collection<CallableMemberDescriptor> delegatedMembers = DelegationResolver.generateDelegatedMembers(jetClassOrObject, classDescriptor, existingMembers, trace, eagerExtractor, eagerTypeResolver);
        for (CallableMemberDescriptor descriptor : delegatedMembers) {
            if (descriptor instanceof PropertyDescriptor) {
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
                classDescriptor.getBuilder().addPropertyDescriptor(propertyDescriptor);
                continue;
            }
            if (!(descriptor instanceof SimpleFunctionDescriptor)) continue;
            SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)descriptor;
            classDescriptor.getBuilder().addFunctionDescriptor(functionDescriptor);
        }
    }

    @NotNull
    public static <T extends CallableMemberDescriptor> Collection<T> generateDelegatedMembers(@NotNull JetClassOrObject classOrObject, @NotNull ClassDescriptor ownerDescriptor, @NotNull Collection<? extends CallableDescriptor> existingMembers, @NotNull BindingTrace trace, @NotNull MemberExtractor<T> memberExtractor, @NotNull TypeResolver typeResolver) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/jet/lang/resolve/DelegationResolver", "generateDelegatedMembers"));
        }
        if (ownerDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerDescriptor", "org/jetbrains/jet/lang/resolve/DelegationResolver", "generateDelegatedMembers"));
        }
        if (existingMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingMembers", "org/jetbrains/jet/lang/resolve/DelegationResolver", "generateDelegatedMembers"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DelegationResolver", "generateDelegatedMembers"));
        }
        if (memberExtractor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberExtractor", "org/jetbrains/jet/lang/resolve/DelegationResolver", "generateDelegatedMembers"));
        }
        if (typeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeResolver", "org/jetbrains/jet/lang/resolve/DelegationResolver", "generateDelegatedMembers"));
        }
        Collection<T> collection = super.generateDelegatedMembers();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DelegationResolver", "generateDelegatedMembers"));
        }
        return collection;
    }

    private DelegationResolver(@NotNull JetClassOrObject classOrObject, @NotNull ClassDescriptor ownerDescriptor, @NotNull Collection<? extends CallableDescriptor> existingMembers, @NotNull BindingTrace trace, @NotNull MemberExtractor<T> extractor, @NotNull TypeResolver resolver) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/jet/lang/resolve/DelegationResolver", "<init>"));
        }
        if (ownerDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerDescriptor", "org/jetbrains/jet/lang/resolve/DelegationResolver", "<init>"));
        }
        if (existingMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingMembers", "org/jetbrains/jet/lang/resolve/DelegationResolver", "<init>"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DelegationResolver", "<init>"));
        }
        if (extractor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractor", "org/jetbrains/jet/lang/resolve/DelegationResolver", "<init>"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/jet/lang/resolve/DelegationResolver", "<init>"));
        }
        this.classOrObject = classOrObject;
        this.ownerDescriptor = ownerDescriptor;
        this.existingMembers = existingMembers;
        this.trace = trace;
        this.memberExtractor = extractor;
        this.typeResolver = resolver;
    }

    @NotNull
    private Collection<T> generateDelegatedMembers() {
        HashSet delegatedMembers = new HashSet();
        for (JetDelegationSpecifier delegationSpecifier : this.classOrObject.getDelegationSpecifiers()) {
            JetType delegatedTraitType;
            JetDelegatorByExpressionSpecifier specifier;
            JetTypeReference typeReference;
            if (!(delegationSpecifier instanceof JetDelegatorByExpressionSpecifier) || (typeReference = (specifier = (JetDelegatorByExpressionSpecifier)delegationSpecifier).getTypeReference()) == null || (delegatedTraitType = this.typeResolver.resolve(typeReference)) == null || delegatedTraitType.isError()) continue;
            Collection delegatesForTrait = this.generateDelegatesForTrait(delegatedMembers, delegatedTraitType);
            delegatedMembers.addAll(delegatesForTrait);
        }
        HashSet hashSet = delegatedMembers;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DelegationResolver", "generateDelegatedMembers"));
        }
        return hashSet;
    }

    @NotNull
    private Collection<T> generateDelegatesForTrait(@NotNull Collection<T> existingDelegates, @NotNull JetType delegatedTraitType) {
        if (existingDelegates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingDelegates", "org/jetbrains/jet/lang/resolve/DelegationResolver", "generateDelegatesForTrait"));
        }
        if (delegatedTraitType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegatedTraitType", "org/jetbrains/jet/lang/resolve/DelegationResolver", "generateDelegatesForTrait"));
        }
        HashSet<CallableMemberDescriptor> result2 = new HashSet<CallableMemberDescriptor>();
        Collection<T> candidates = this.generateDelegationCandidates(delegatedTraitType);
        for (CallableMemberDescriptor candidate : candidates) {
            if (DelegationResolver.existingMemberOverridesDelegatedMember(candidate, this.existingMembers) || this.checkClashWithOtherDelegatedMember(existingDelegates, candidate)) continue;
            result2.add(candidate);
        }
        HashSet<CallableMemberDescriptor> hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DelegationResolver", "generateDelegatesForTrait"));
        }
        return hashSet;
    }

    @NotNull
    private Collection<T> generateDelegationCandidates(@NotNull JetType delegatedTraitType) {
        if (delegatedTraitType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegatedTraitType", "org/jetbrains/jet/lang/resolve/DelegationResolver", "generateDelegationCandidates"));
        }
        Collection<T> descriptorsToDelegate = this.overridableMembersNotFromSuperClassOfTrait(delegatedTraitType);
        ArrayList<CallableMemberDescriptor> result2 = new ArrayList<CallableMemberDescriptor>(descriptorsToDelegate.size());
        for (CallableMemberDescriptor memberDescriptor : descriptorsToDelegate) {
            Modality newModality = memberDescriptor.getModality() == Modality.ABSTRACT ? Modality.OPEN : memberDescriptor.getModality();
            CallableMemberDescriptor copy = memberDescriptor.copy(this.ownerDescriptor, newModality, Visibilities.INHERITED, CallableMemberDescriptor.Kind.DELEGATION, false);
            result2.add(copy);
        }
        ArrayList<CallableMemberDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DelegationResolver", "generateDelegationCandidates"));
        }
        return arrayList;
    }

    private static boolean existingMemberOverridesDelegatedMember(@NotNull CallableMemberDescriptor candidate, @NotNull Collection<? extends CallableDescriptor> existingMembers) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/jet/lang/resolve/DelegationResolver", "existingMemberOverridesDelegatedMember"));
        }
        if (existingMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingMembers", "org/jetbrains/jet/lang/resolve/DelegationResolver", "existingMemberOverridesDelegatedMember"));
        }
        for (CallableDescriptor callableDescriptor : existingMembers) {
            if (!DelegationResolver.haveSameSignatures(callableDescriptor, candidate)) continue;
            return true;
        }
        return false;
    }

    private boolean checkClashWithOtherDelegatedMember(@NotNull Collection<T> delegatedMembers, @NotNull T candidate) {
        if (delegatedMembers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegatedMembers", "org/jetbrains/jet/lang/resolve/DelegationResolver", "checkClashWithOtherDelegatedMember"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/jet/lang/resolve/DelegationResolver", "checkClashWithOtherDelegatedMember"));
        }
        for (CallableMemberDescriptor alreadyDelegatedMember : delegatedMembers) {
            if (!DelegationResolver.haveSameSignatures(alreadyDelegatedMember, candidate)) continue;
            this.trace.report(Errors.MANY_IMPL_MEMBER_NOT_IMPLEMENTED.on(this.classOrObject, this.classOrObject, alreadyDelegatedMember));
            return true;
        }
        return false;
    }

    @NotNull
    private Collection<T> overridableMembersNotFromSuperClassOfTrait(@NotNull JetType trait) {
        if (trait == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trait", "org/jetbrains/jet/lang/resolve/DelegationResolver", "overridableMembersNotFromSuperClassOfTrait"));
        }
        final Collection<T> membersToSkip = this.getMembersFromClassSupertypeOfTrait(trait);
        Collection<CallableMemberDescriptor> collection = Collections2.filter(this.memberExtractor.getMembersByType(trait), new Predicate<CallableMemberDescriptor>(){

            @Override
            public boolean apply(CallableMemberDescriptor descriptor) {
                if (!descriptor.getModality().isOverridable()) {
                    return false;
                }
                for (CallableMemberDescriptor memberToSkip : membersToSkip) {
                    if (!DelegationResolver.haveSameSignatures(memberToSkip, descriptor)) continue;
                    return false;
                }
                return true;
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DelegationResolver", "overridableMembersNotFromSuperClassOfTrait"));
        }
        return collection;
    }

    private static boolean haveSameSignatures(@NotNull CallableDescriptor memberOne, @NotNull CallableDescriptor memberTwo) {
        if (memberOne == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberOne", "org/jetbrains/jet/lang/resolve/DelegationResolver", "haveSameSignatures"));
        }
        if (memberTwo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberTwo", "org/jetbrains/jet/lang/resolve/DelegationResolver", "haveSameSignatures"));
        }
        return OverridingUtil.DEFAULT.isOverridableBy(memberOne, memberTwo).getResult() == OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE;
    }

    @NotNull
    private Collection<T> getMembersFromClassSupertypeOfTrait(@NotNull JetType traitType) {
        if (traitType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traitType", "org/jetbrains/jet/lang/resolve/DelegationResolver", "getMembersFromClassSupertypeOfTrait"));
        }
        JetType classSupertype = null;
        for (JetType supertype : TypeUtils.getAllSupertypes(traitType)) {
            if (!DelegationResolver.isNotTrait(supertype.getConstructor().getDeclarationDescriptor())) continue;
            classSupertype = supertype;
            break;
        }
        Collection collection = classSupertype != null ? this.memberExtractor.getMembersByType(classSupertype) : Collections.emptyList();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DelegationResolver", "getMembersFromClassSupertypeOfTrait"));
        }
        return collection;
    }

    private static boolean isNotTrait(@Nullable DeclarationDescriptor descriptor) {
        if (descriptor instanceof ClassDescriptor) {
            ClassKind kind = ((ClassDescriptor)descriptor).getKind();
            return kind != ClassKind.TRAIT;
        }
        return false;
    }

    public static interface TypeResolver {
        @Nullable
        public JetType resolve(@NotNull JetTypeReference var1);
    }

    public static interface MemberExtractor<T extends CallableMemberDescriptor> {
        @NotNull
        public Collection<T> getMembersByType(@NotNull JetType var1);
    }
}

