/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.impl;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiClass;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.stubs.PsiClassHolderFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.io.StringRef;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.stubs.PsiJetFileStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class PsiJetFileStubImpl
extends PsiFileStubImpl<JetFile>
implements PsiClassHolderFileStub<JetFile>,
PsiJetFileStub {
    private final StringRef packageName;
    private final boolean isScript;

    public PsiJetFileStubImpl(JetFile jetFile, @NotNull StringRef packageName, boolean isScript) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/jet/lang/psi/stubs/impl/PsiJetFileStubImpl", "<init>"));
        }
        super(jetFile);
        this.packageName = packageName;
        this.isScript = isScript;
    }

    public PsiJetFileStubImpl(JetFile jetFile, @NotNull String packageName, boolean isScript) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/jet/lang/psi/stubs/impl/PsiJetFileStubImpl", "<init>"));
        }
        this(jetFile, StringRef.fromString(packageName), isScript);
    }

    @Override
    @NotNull
    public FqName getPackageFqName() {
        FqName fqName = new FqName(StringRef.toString(this.packageName));
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/impl/PsiJetFileStubImpl", "getPackageFqName"));
        }
        return fqName;
    }

    @Override
    public boolean isScript() {
        return this.isScript;
    }

    @Override
    public IStubFileElementType getType() {
        return JetStubElementTypes.FILE;
    }

    @Override
    public String toString() {
        return "PsiJetFileStubImpl[package=" + this.getPackageFqName().asString() + "]";
    }

    @Override
    public PsiClass[] getClasses() {
        ArrayList<PsiClass> result2 = Lists.newArrayList();
        for (StubElement child : this.getChildrenStubs()) {
            if (!(child instanceof PsiClassStub)) continue;
            result2.add((PsiClass)child.getPsi());
        }
        return result2.toArray(new PsiClass[result2.size()]);
    }
}

