/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetTypeParameterList;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwnerStub;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetWithExpressionInitializer;
import org.jetbrains.jet.lang.psi.stubs.PsiJetFunctionStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lexer.JetTokens;

public class JetNamedFunction
extends JetTypeParameterListOwnerStub<PsiJetFunctionStub>
implements JetFunction,
JetWithExpressionInitializer {
    public JetNamedFunction(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetNamedFunction", "<init>"));
        }
        super(node);
    }

    public JetNamedFunction(@NotNull PsiJetFunctionStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/JetNamedFunction", "<init>"));
        }
        super(stub, JetStubElementTypes.FUNCTION);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetNamedFunction", "accept"));
        }
        return visitor.visitNamedFunction(this, data2);
    }

    public boolean hasTypeParameterListBeforeFunctionName() {
        PsiJetFunctionStub stub = (PsiJetFunctionStub)this.getStub();
        if (stub != null) {
            return stub.hasTypeParameterListBeforeFunctionName();
        }
        return this.hasTypeParameterListBeforeFunctionNameByTree();
    }

    private boolean hasTypeParameterListBeforeFunctionNameByTree() {
        JetTypeParameterList typeParameterList = this.getTypeParameterList();
        if (typeParameterList == null) {
            return false;
        }
        PsiElement nameIdentifier = this.getNameIdentifier();
        if (nameIdentifier == null) {
            return false;
        }
        return nameIdentifier.getTextOffset() > typeParameterList.getTextOffset();
    }

    @Override
    public boolean hasBlockBody() {
        PsiJetFunctionStub stub = (PsiJetFunctionStub)this.getStub();
        if (stub != null) {
            return stub.hasBlockBody();
        }
        return this.getEqualsToken() == null;
    }

    @Nullable
    public PsiElement getEqualsToken() {
        return this.findChildByType(JetTokens.EQ);
    }

    @Override
    @Nullable
    public JetExpression getInitializer() {
        return PsiTreeUtil.getNextSiblingOfType(this.getEqualsToken(), JetExpression.class);
    }

    @Override
    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    @Nullable
    public JetParameterList getValueParameterList() {
        return (JetParameterList)this.getStubOrPsiChild(JetStubElementTypes.VALUE_PARAMETER_LIST);
    }

    @Override
    @NotNull
    public List<JetParameter> getValueParameters() {
        JetParameterList list = this.getValueParameterList();
        List<JetParameter> list2 = list != null ? list.getParameters() : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNamedFunction", "getValueParameters"));
        }
        return list2;
    }

    @Override
    @Nullable
    public JetExpression getBodyExpression() {
        return this.findChildByClass(JetExpression.class);
    }

    @Override
    public boolean hasBody() {
        PsiJetFunctionStub stub = (PsiJetFunctionStub)this.getStub();
        if (stub != null) {
            return stub.hasBody();
        }
        return this.getBodyExpression() != null;
    }

    @Override
    public boolean hasDeclaredReturnType() {
        return this.getReturnTypeRef() != null;
    }

    @Override
    @Nullable
    public JetTypeReference getReceiverTypeRef() {
        PsiJetFunctionStub stub = (PsiJetFunctionStub)this.getStub();
        if (stub != null) {
            if (!stub.isExtension()) {
                return null;
            }
            List childTypeReferences = this.getStubOrPsiChildrenAsList(JetStubElementTypes.TYPE_REFERENCE);
            if (!childTypeReferences.isEmpty()) {
                return (JetTypeReference)childTypeReferences.get(0);
            }
            return null;
        }
        return this.getReceiverTypeRefByTree();
    }

    @Nullable
    private JetTypeReference getReceiverTypeRefByTree() {
        IElementType tt;
        for (PsiElement child = this.getFirstChild(); child != null && (tt = child.getNode().getElementType()) != JetTokens.LPAR && tt != JetTokens.COLON; child = child.getNextSibling()) {
            if (!(child instanceof JetTypeReference)) continue;
            return (JetTypeReference)child;
        }
        return null;
    }

    @Override
    @Nullable
    public JetTypeReference getReturnTypeRef() {
        PsiJetFunctionStub stub = (PsiJetFunctionStub)this.getStub();
        if (stub != null) {
            int returnTypeIndex;
            List typeReferences = this.getStubOrPsiChildrenAsList(JetStubElementTypes.TYPE_REFERENCE);
            int n = returnTypeIndex = stub.isExtension() ? 1 : 0;
            if (returnTypeIndex >= typeReferences.size()) {
                return null;
            }
            return (JetTypeReference)typeReferences.get(returnTypeIndex);
        }
        return this.getReturnTypeRefByPsi();
    }

    @Nullable
    private JetTypeReference getReturnTypeRefByPsi() {
        boolean colonPassed = false;
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            IElementType tt = child.getNode().getElementType();
            if (tt == JetTokens.COLON) {
                colonPassed = true;
            }
            if (!colonPassed || !(child instanceof JetTypeReference)) continue;
            return (JetTypeReference)child;
        }
        return null;
    }

    @Override
    @NotNull
    public JetElement asElement() {
        JetNamedFunction jetNamedFunction = this;
        if (jetNamedFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNamedFunction", "asElement"));
        }
        return jetNamedFunction;
    }

    @Override
    public boolean isLocal() {
        PsiElement parent = this.getParent();
        return !(parent instanceof JetFile) && !(parent instanceof JetClassBody);
    }
}

