/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.when;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.when.MappingClassesForWhenByEnumCodegen;
import org.jetbrains.jet.codegen.when.WhenByEnumsMapping;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.org.objectweb.asm.Type;

public class MappingsClassesForWhenByEnum {
    private final GenerationState state;
    private final Set<String> generatedMappingClasses;
    private final MappingClassesForWhenByEnumCodegen mappingsCodegen;

    public MappingsClassesForWhenByEnum(@NotNull GenerationState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/when/MappingsClassesForWhenByEnum", "<init>"));
        }
        this.generatedMappingClasses = new HashSet<String>();
        this.state = state;
        this.mappingsCodegen = new MappingClassesForWhenByEnumCodegen(state);
    }

    public void generateMappingsClassForExpression(@NotNull JetWhenExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/codegen/when/MappingsClassesForWhenByEnum", "generateMappingsClassForExpression"));
        }
        WhenByEnumsMapping mapping = this.state.getBindingContext().get(CodegenBinding.MAPPING_FOR_WHEN_BY_ENUM, expression);
        assert (mapping != null) : "mapping class should not be requested for non enum when";
        if (!this.generatedMappingClasses.contains(mapping.getMappingsClassInternalName())) {
            List<WhenByEnumsMapping> mappings = this.state.getBindingContext().get(CodegenBinding.MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE, mapping.getOuterClassInternalNameForExpression());
            assert (mappings != null) : "guaranteed by usage contract of EnumSwitchCodegen";
            Type mappingsClassType = Type.getObjectType(mapping.getMappingsClassInternalName());
            this.mappingsCodegen.generate(mappings, mappingsClassType, expression.getContainingJetFile());
            this.generatedMappingClasses.add(mapping.getMappingsClassInternalName());
        }
    }
}

