/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.signature;

import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.jet.lang.resolve.java.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.jet.lang.resolve.java.jvmSignature.JvmMethodSignature;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.signature.SignatureVisitor;
import org.jetbrains.org.objectweb.asm.signature.SignatureWriter;
import org.jetbrains.org.objectweb.asm.util.CheckSignatureAdapter;

public class BothSignatureWriter {
    private final SignatureWriter signatureWriter;
    private final SignatureVisitor signatureVisitor;
    private final List<JvmMethodParameterSignature> kotlinParameterTypes;
    private int jvmCurrentTypeArrayLevel;
    private Type jvmCurrentType;
    private Type jvmReturnType;
    private JvmMethodParameterKind currentParameterKind;
    private boolean generic;
    private final Stack<SignatureVisitor> visitors;

    public BothSignatureWriter(@NotNull Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/jet/codegen/signature/BothSignatureWriter", "<init>"));
        }
        this.signatureWriter = new SignatureWriter();
        this.kotlinParameterTypes = new ArrayList<JvmMethodParameterSignature>();
        this.generic = false;
        this.visitors = new Stack();
        this.signatureVisitor = new CheckSignatureAdapter(mode.asmType, this.signatureWriter);
    }

    private void push(SignatureVisitor visitor) {
        this.visitors.push(visitor);
    }

    private void pop() {
        this.visitors.pop();
    }

    private SignatureVisitor signatureVisitor() {
        return !this.visitors.isEmpty() ? this.visitors.peek() : this.signatureVisitor;
    }

    public void writeAsmType(Type asmType) {
        switch (asmType.getSort()) {
            case 10: {
                this.writeClassBegin(asmType);
                this.writeClassEnd();
                return;
            }
            case 9: {
                this.writeArrayType();
                this.writeAsmType(asmType.getElementType());
                this.writeArrayEnd();
                return;
            }
        }
        this.signatureVisitor().visitBaseType(asmType.getDescriptor().charAt(0));
        this.writeAsmType0(asmType);
    }

    private String makeArrayPrefix() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.jvmCurrentTypeArrayLevel; ++i) {
            sb.append('[');
        }
        return sb.toString();
    }

    private void writeAsmType0(Type type) {
        if (this.jvmCurrentType == null) {
            this.jvmCurrentType = Type.getType(this.makeArrayPrefix() + type.getDescriptor());
        }
    }

    public void writeClassBegin(Type asmType) {
        this.signatureVisitor().visitClassType(asmType.getInternalName());
        this.writeAsmType0(asmType);
    }

    public void writeClassEnd() {
        this.signatureVisitor().visitEnd();
    }

    public void writeArrayType() {
        this.push(this.signatureVisitor().visitArrayType());
        if (this.jvmCurrentType == null) {
            ++this.jvmCurrentTypeArrayLevel;
        }
    }

    public void writeArrayEnd() {
        this.pop();
    }

    private static char toJvmVariance(@NotNull Variance variance) {
        if (variance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variance", "org/jetbrains/jet/codegen/signature/BothSignatureWriter", "toJvmVariance"));
        }
        switch (variance) {
            case INVARIANT: {
                return '=';
            }
            case IN_VARIANCE: {
                return '-';
            }
            case OUT_VARIANCE: {
                return '+';
            }
        }
        throw new IllegalStateException("Unknown variance: " + (Object)((Object)variance));
    }

    public void writeTypeArgument(@NotNull Variance projectionKind) {
        if (projectionKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectionKind", "org/jetbrains/jet/codegen/signature/BothSignatureWriter", "writeTypeArgument"));
        }
        this.push(this.signatureVisitor().visitTypeArgument(BothSignatureWriter.toJvmVariance(projectionKind)));
        this.generic = true;
    }

    public void writeTypeArgumentEnd() {
        this.pop();
    }

    public void writeTypeVariable(Name name, Type asmType) {
        this.signatureVisitor().visitTypeVariable(name.asString());
        this.generic = true;
        this.writeAsmType0(asmType);
    }

    public void writeFormalTypeParameter(String name) {
        this.signatureVisitor().visitFormalTypeParameter(name);
        this.generic = true;
    }

    public void writeClassBound() {
        this.push(this.signatureVisitor().visitClassBound());
    }

    public void writeClassBoundEnd() {
        this.pop();
    }

    public void writeInterfaceBound() {
        this.push(this.signatureVisitor().visitInterfaceBound());
    }

    public void writeInterfaceBoundEnd() {
        this.pop();
    }

    public void writeParametersStart() {
        this.jvmCurrentType = null;
        this.jvmCurrentTypeArrayLevel = 0;
    }

    public void writeParameterType(JvmMethodParameterKind parameterKind) {
        if (parameterKind.isSkippedInGenericSignature()) {
            this.generic = true;
            this.push(new SignatureWriter());
        } else {
            this.push(this.signatureVisitor().visitParameterType());
        }
        this.currentParameterKind = parameterKind;
    }

    public void writeParameterTypeEnd() {
        this.pop();
        this.kotlinParameterTypes.add(new JvmMethodParameterSignature(this.jvmCurrentType, this.currentParameterKind));
        this.currentParameterKind = null;
        this.jvmCurrentType = null;
        this.jvmCurrentTypeArrayLevel = 0;
    }

    public void writeReturnType() {
        this.push(this.signatureVisitor().visitReturnType());
    }

    public void writeReturnTypeEnd() {
        this.pop();
        this.jvmReturnType = this.jvmCurrentType;
        this.jvmCurrentType = null;
        this.jvmCurrentTypeArrayLevel = 0;
    }

    public void writeSuperclass() {
        this.push(this.signatureVisitor().visitSuperclass());
    }

    public void writeSuperclassEnd() {
        this.pop();
    }

    public void writeInterface() {
        this.push(this.signatureVisitor().visitInterface());
    }

    public void writeInterfaceEnd() {
        this.pop();
    }

    @Nullable
    public String makeJavaGenericSignature() {
        return this.generic ? this.signatureWriter.toString() : null;
    }

    @NotNull
    public JvmMethodSignature makeJvmMethodSignature(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/signature/BothSignatureWriter", "makeJvmMethodSignature"));
        }
        ArrayList<Type> types = new ArrayList<Type>(this.kotlinParameterTypes.size());
        for (JvmMethodParameterSignature parameter : this.kotlinParameterTypes) {
            types.add(parameter.getAsmType());
        }
        Method asmMethod = new Method(name, this.jvmReturnType, types.toArray(new Type[types.size()]));
        JvmMethodSignature jvmMethodSignature = new JvmMethodSignature(asmMethod, this.makeJavaGenericSignature(), this.kotlinParameterTypes);
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/signature/BothSignatureWriter", "makeJvmMethodSignature"));
        }
        return jvmMethodSignature;
    }

    public String toString() {
        return this.signatureWriter.toString();
    }

    public static enum Mode {
        METHOD(1),
        CLASS(0),
        TYPE(2);

        private final int asmType;

        private Mode(int asmType) {
            this.asmType = asmType;
        }
    }
}

