/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.intrinsics;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.java.JvmPrimitiveType;
import org.jetbrains.jet.lang.resolve.java.mapping.PrimitiveTypesUtil;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class ArrayIterator
extends IntrinsicMethod {
    @Override
    @NotNull
    public Type generateImpl(@NotNull ExpressionCodegen codegen, @NotNull InstructionAdapter v, @NotNull Type returnType, PsiElement element, List<JetExpression> arguments, StackValue receiver) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/intrinsics/ArrayIterator", "generateImpl"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/intrinsics/ArrayIterator", "generateImpl"));
        }
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/jet/codegen/intrinsics/ArrayIterator", "generateImpl"));
        }
        receiver.put(receiver.type, v);
        JetCallExpression call = (JetCallExpression)element;
        FunctionDescriptor funDescriptor = (FunctionDescriptor)codegen.getBindingContext().get(BindingContext.REFERENCE_TARGET, (JetSimpleNameExpression)call.getCalleeExpression());
        assert (funDescriptor != null);
        ClassDescriptor containingDeclaration = (ClassDescriptor)funDescriptor.getContainingDeclaration().getOriginal();
        if (containingDeclaration.equals(KotlinBuiltIns.getInstance().getArray())) {
            v.invokestatic("kotlin/jvm/internal/InternalPackage", "iterator", "([Ljava/lang/Object;)Ljava/util/Iterator;", false);
            Type type = AsmTypeConstants.getType(Iterator.class);
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/intrinsics/ArrayIterator", "generateImpl"));
            }
            return type;
        }
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            PrimitiveType primitiveType = jvmPrimitiveType.getPrimitiveType();
            ClassDescriptor arrayClass = KotlinBuiltIns.getInstance().getPrimitiveArrayClassDescriptor(primitiveType);
            if (!containingDeclaration.equals(arrayClass)) continue;
            FqName fqName = new FqName(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME + "." + primitiveType.getTypeName() + "Iterator");
            String iteratorDesc = AsmUtil.asmDescByFqNameWithoutInnerClasses(fqName);
            String methodSignature = "([" + PrimitiveTypesUtil.asmTypeForPrimitive(jvmPrimitiveType) + ")" + iteratorDesc;
            v.invokestatic("kotlin/jvm/internal/InternalPackage", "iterator", methodSignature, false);
            Type type = Type.getType(iteratorDesc);
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/intrinsics/ArrayIterator", "generateImpl"));
            }
            return type;
        }
        throw new UnsupportedOperationException(containingDeclaration.toString());
    }
}

