/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.google.common.collect.Sets;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.CompilationErrorHandler;
import org.jetbrains.jet.codegen.PackageCodegen;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.resolve.ScriptNameUtil;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.org.objectweb.asm.Type;

public class KotlinCodegenFacade {
    public static void prepareForCompilation(@NotNull GenerationState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/KotlinCodegenFacade", "prepareForCompilation"));
        }
        for (JetFile file : state.getFiles()) {
            if (!file.isScript()) continue;
            JetScript script = file.getScript();
            assert (script != null);
            FqName name = ScriptNameUtil.classNameForScript(script);
            Type type = AsmUtil.asmTypeByFqNameWithoutInnerClasses(name);
            CodegenBinding.registerClassNameForScript(state.getBindingTrace(), script, type);
        }
        state.beforeCompile();
    }

    public static void compileCorrectFiles(@NotNull GenerationState state, @NotNull CompilationErrorHandler errorHandler) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/KotlinCodegenFacade", "compileCorrectFiles"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "org/jetbrains/jet/codegen/KotlinCodegenFacade", "compileCorrectFiles"));
        }
        KotlinCodegenFacade.prepareForCompilation(state);
        MultiMap<FqName, JetFile> packageFqNameToFiles = new MultiMap<FqName, JetFile>();
        for (JetFile file : state.getFiles()) {
            if (file == null) {
                throw new IllegalArgumentException("A null file given for compilation");
            }
            packageFqNameToFiles.putValue(file.getPackageFqName(), file);
        }
        HashSet<FqName> removedPackageFiles = new HashSet<FqName>(state.getPackagesWithRemovedFiles());
        for (FqName fqName : Sets.union(removedPackageFiles, packageFqNameToFiles.keySet())) {
            KotlinCodegenFacade.generatePackage(state, fqName, packageFqNameToFiles.get(fqName), errorHandler);
        }
        state.getFactory().done();
    }

    public static void generatePackage(@NotNull GenerationState state, @NotNull FqName fqName, @NotNull Collection<JetFile> jetFiles, @NotNull CompilationErrorHandler errorHandler) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        if (jetFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetFiles", "org/jetbrains/jet/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "org/jetbrains/jet/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        PackageCodegen codegen = state.getFactory().forPackage(fqName, jetFiles);
        codegen.generate(errorHandler);
    }

    private KotlinCodegenFacade() {
    }
}

