/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Trinity;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.org.objectweb.asm.Type;

public class FrameMap {
    private final TObjectIntHashMap<DeclarationDescriptor> myVarIndex = new TObjectIntHashMap();
    private final TObjectIntHashMap<DeclarationDescriptor> myVarSizes = new TObjectIntHashMap();
    private int myMaxIndex = 0;

    public int enter(DeclarationDescriptor descriptor, Type type) {
        int index = this.myMaxIndex;
        this.myVarIndex.put(descriptor, index);
        this.myMaxIndex += type.getSize();
        this.myVarSizes.put(descriptor, type.getSize());
        return index;
    }

    public int leave(DeclarationDescriptor descriptor) {
        int size = this.myVarSizes.get(descriptor);
        this.myMaxIndex -= size;
        this.myVarSizes.remove(descriptor);
        int oldIndex = this.myVarIndex.remove(descriptor);
        if (oldIndex != this.myMaxIndex) {
            throw new IllegalStateException("descriptor can be left only if it is last");
        }
        return oldIndex;
    }

    public int enterTemp(Type type) {
        int result2 = this.myMaxIndex;
        this.myMaxIndex += type.getSize();
        return result2;
    }

    public void leaveTemp(Type type) {
        this.myMaxIndex -= type.getSize();
    }

    public int getIndex(DeclarationDescriptor descriptor) {
        return this.myVarIndex.contains(descriptor) ? this.myVarIndex.get(descriptor) : -1;
    }

    public Mark mark() {
        return new Mark(this.myMaxIndex);
    }

    public int getCurrentSize() {
        return this.myMaxIndex;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var5_8;
        StringBuilder sb = new StringBuilder();
        if (this.myVarIndex.size() != this.myVarSizes.size()) {
            return "inconsistent";
        }
        ArrayList<Trinity<DeclarationDescriptor, Integer, Integer>> descriptors = Lists.newArrayList();
        Object[] arr$ = this.myVarIndex.keys();
        int len$ = arr$.length;
        boolean bl = false;
        while (var5_8 < len$) {
            Object descriptor0 = arr$[var5_8];
            DeclarationDescriptor descriptor = (DeclarationDescriptor)descriptor0;
            int varIndex = this.myVarIndex.get(descriptor);
            int varSize = this.myVarSizes.get(descriptor);
            descriptors.add(Trinity.create(descriptor, varIndex, varSize));
            ++var5_8;
        }
        Collections.sort(descriptors, new Comparator<Trinity<DeclarationDescriptor, Integer, Integer>>(){

            @Override
            public int compare(Trinity<DeclarationDescriptor, Integer, Integer> left, Trinity<DeclarationDescriptor, Integer, Integer> right) {
                return (Integer)left.second - (Integer)right.second;
            }
        });
        sb.append("size=").append(this.myMaxIndex);
        boolean first = true;
        for (Trinity trinity : descriptors) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(trinity.first).append(",i=").append(trinity.second).append(",s=").append(trinity.third);
        }
        return sb.toString();
    }

    public class Mark {
        private final int myIndex;

        public Mark(int index) {
            this.myIndex = index;
        }

        public void dropTo() {
            ArrayList descriptorsToDrop = new ArrayList();
            TObjectIntIterator iterator2 = FrameMap.this.myVarIndex.iterator();
            while (iterator2.hasNext()) {
                iterator2.advance();
                if (iterator2.value() < this.myIndex) continue;
                descriptorsToDrop.add(iterator2.key());
            }
            for (DeclarationDescriptor declarationDescriptor : descriptorsToDrop) {
                FrameMap.this.myVarIndex.remove(declarationDescriptor);
                FrameMap.this.myVarSizes.remove(declarationDescriptor);
            }
            FrameMap.this.myMaxIndex = this.myIndex;
        }
    }
}

