/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.google.common.collect.Lists;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.OutputFile;
import org.jetbrains.jet.OutputFileCollection;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderFactory;
import org.jetbrains.jet.codegen.PackageCodegen;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.java.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.org.objectweb.asm.Type;

public class ClassFileFactory
implements OutputFileCollection {
    private final GenerationState state;
    private final ClassBuilderFactory builderFactory;
    private final Map<FqName, PackageCodegen> package2codegen;
    private final Map<String, ClassBuilderAndSourceFileList> generators;
    private boolean isDone;

    public ClassFileFactory(@NotNull GenerationState state, @NotNull ClassBuilderFactory builderFactory) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/ClassFileFactory", "<init>"));
        }
        if (builderFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builderFactory", "org/jetbrains/jet/codegen/ClassFileFactory", "<init>"));
        }
        this.package2codegen = new HashMap<FqName, PackageCodegen>();
        this.generators = new LinkedHashMap<String, ClassBuilderAndSourceFileList>();
        this.isDone = false;
        this.state = state;
        this.builderFactory = builderFactory;
    }

    @NotNull
    public ClassBuilder newVisitor(@NotNull JvmDeclarationOrigin origin, @NotNull Type asmType, @NotNull PsiFile sourceFile) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/jet/codegen/ClassFileFactory", "newVisitor"));
        }
        if (asmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmType", "org/jetbrains/jet/codegen/ClassFileFactory", "newVisitor"));
        }
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "org/jetbrains/jet/codegen/ClassFileFactory", "newVisitor"));
        }
        ClassBuilder classBuilder = this.newVisitor(origin, asmType, Collections.singletonList(sourceFile));
        if (classBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassFileFactory", "newVisitor"));
        }
        return classBuilder;
    }

    @NotNull
    public ClassBuilder newVisitor(@NotNull JvmDeclarationOrigin origin, @NotNull Type asmType, @NotNull Collection<? extends PsiFile> sourceFiles) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/jet/codegen/ClassFileFactory", "newVisitor"));
        }
        if (asmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmType", "org/jetbrains/jet/codegen/ClassFileFactory", "newVisitor"));
        }
        if (sourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "org/jetbrains/jet/codegen/ClassFileFactory", "newVisitor"));
        }
        String outputFilePath = asmType.getInternalName() + ".class";
        List<File> ioSourceFiles = ClassFileFactory.toIoFilesIgnoringNonPhysical(sourceFiles);
        this.state.getProgress().reportOutput(ioSourceFiles, new File(outputFilePath));
        ClassBuilder answer = this.builderFactory.newClassBuilder(origin);
        this.generators.put(outputFilePath, new ClassBuilderAndSourceFileList(answer, ioSourceFiles));
        ClassBuilder classBuilder = answer;
        if (classBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassFileFactory", "newVisitor"));
        }
        return classBuilder;
    }

    void done() {
        if (!this.isDone) {
            this.isDone = true;
            for (PackageCodegen codegen : this.package2codegen.values()) {
                codegen.done();
            }
        }
    }

    @Override
    @NotNull
    public List<OutputFile> asList() {
        this.done();
        List<OutputFile> list = ContainerUtil.map(this.generators.keySet(), new Function<String, OutputFile>(){

            @Override
            public OutputFile fun(String relativeClassFilePath) {
                return new OutputClassFile(relativeClassFilePath);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassFileFactory", "asList"));
        }
        return list;
    }

    @Override
    @Nullable
    public OutputFile get(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "org/jetbrains/jet/codegen/ClassFileFactory", "get"));
        }
        return this.generators.containsKey(relativePath) ? new OutputClassFile(relativePath) : null;
    }

    @NotNull
    public String createText() {
        StringBuilder answer = new StringBuilder();
        for (OutputFile file : this.asList()) {
            answer.append("@").append(file.getRelativePath()).append('\n');
            answer.append(file.asText());
        }
        String string = answer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassFileFactory", "createText"));
        }
        return string;
    }

    @NotNull
    public PackageCodegen forPackage(@NotNull FqName fqName, @NotNull Collection<JetFile> files) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/codegen/ClassFileFactory", "forPackage"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/codegen/ClassFileFactory", "forPackage"));
        }
        assert (!this.isDone) : "Already done!";
        PackageCodegen codegen = this.package2codegen.get(fqName);
        if (codegen == null) {
            codegen = new PackageCodegen(this.state, files, fqName);
            this.package2codegen.put(fqName, codegen);
        }
        PackageCodegen packageCodegen = codegen;
        if (packageCodegen == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassFileFactory", "forPackage"));
        }
        return packageCodegen;
    }

    @NotNull
    private static List<File> toIoFilesIgnoringNonPhysical(@NotNull Collection<? extends PsiFile> psiFiles) {
        if (psiFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFiles", "org/jetbrains/jet/codegen/ClassFileFactory", "toIoFilesIgnoringNonPhysical"));
        }
        ArrayList<File> result2 = Lists.newArrayList();
        for (PsiFile psiFile : psiFiles) {
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null) continue;
            result2.add(new File(virtualFile.getPath()));
        }
        ArrayList<File> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassFileFactory", "toIoFilesIgnoringNonPhysical"));
        }
        return arrayList;
    }

    public void removeInlinedClasses(Set<String> classNamesToRemove) {
        for (String classInternalName : classNamesToRemove) {
            this.generators.remove(classInternalName + ".class");
        }
    }

    private static final class ClassBuilderAndSourceFileList {
        private final ClassBuilder classBuilder;
        private final List<File> sourceFiles;

        private ClassBuilderAndSourceFileList(ClassBuilder classBuilder, List<File> sourceFiles) {
            this.classBuilder = classBuilder;
            this.sourceFiles = sourceFiles;
        }
    }

    private class OutputClassFile
    implements OutputFile {
        private final String relativeClassFilePath;

        public OutputClassFile(String relativeClassFilePath) {
            this.relativeClassFilePath = relativeClassFilePath;
        }

        @Override
        @NotNull
        public String getRelativePath() {
            String string = this.relativeClassFilePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassFileFactory$OutputClassFile", "getRelativePath"));
            }
            return string;
        }

        @Override
        @NotNull
        public List<File> getSourceFiles() {
            ClassBuilderAndSourceFileList pair = (ClassBuilderAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath);
            if (pair == null) {
                throw new IllegalStateException("No record for binary file " + this.relativeClassFilePath);
            }
            List list = pair.sourceFiles;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassFileFactory$OutputClassFile", "getSourceFiles"));
            }
            return list;
        }

        @Override
        @NotNull
        public byte[] asByteArray() {
            byte[] byArray = ClassFileFactory.this.builderFactory.asBytes(((ClassBuilderAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath)).classBuilder);
            if (byArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassFileFactory$OutputClassFile", "asByteArray"));
            }
            return byArray;
        }

        @Override
        @NotNull
        public String asText() {
            String string = ClassFileFactory.this.builderFactory.asText(((ClassBuilderAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath)).classBuilder);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassFileFactory$OutputClassFile", "asText"));
            }
            return string;
        }

        @Override
        @NotNull
        public String toString() {
            String string = this.getRelativePath() + " (compiled from " + this.getSourceFiles() + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassFileFactory$OutputClassFile", "toString"));
            }
            return string;
        }
    }
}

