/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.Callable;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.java.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.jet.lang.resolve.java.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.jet.lang.resolve.java.jvmSignature.JvmMethodSignature;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.util.Printer;

public class CallableMethod
implements Callable {
    private final Type owner;
    private final Type defaultImplOwner;
    private final Type defaultImplParam;
    private final JvmMethodSignature signature;
    private final int invokeOpcode;
    private final Type thisClass;
    private final Type receiverParameterType;
    private final Type generateCalleeType;

    public CallableMethod(@NotNull Type owner, @Nullable Type defaultImplOwner, @Nullable Type defaultImplParam, @NotNull JvmMethodSignature signature, int invokeOpcode, @Nullable Type thisClass, @Nullable Type receiverParameterType, @Nullable Type generateCalleeType) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/codegen/CallableMethod", "<init>"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/CallableMethod", "<init>"));
        }
        this.owner = owner;
        this.defaultImplOwner = defaultImplOwner;
        this.defaultImplParam = defaultImplParam;
        this.signature = signature;
        this.invokeOpcode = invokeOpcode;
        this.thisClass = thisClass;
        this.receiverParameterType = receiverParameterType;
        this.generateCalleeType = generateCalleeType;
    }

    @NotNull
    public Type getOwner() {
        Type type = this.owner;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/CallableMethod", "getOwner"));
        }
        return type;
    }

    @NotNull
    public List<JvmMethodParameterSignature> getValueParameters() {
        List<JvmMethodParameterSignature> list = this.signature.getValueParameters();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/CallableMethod", "getValueParameters"));
        }
        return list;
    }

    @NotNull
    public List<Type> getValueParameterTypes() {
        List<JvmMethodParameterSignature> valueParameters = this.signature.getValueParameters();
        ArrayList<Type> result2 = new ArrayList<Type>(valueParameters.size());
        for (JvmMethodParameterSignature parameter : valueParameters) {
            if (parameter.getKind() != JvmMethodParameterKind.VALUE) continue;
            result2.add(parameter.getAsmType());
        }
        ArrayList<Type> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/CallableMethod", "getValueParameterTypes"));
        }
        return arrayList;
    }

    @NotNull
    public Method getAsmMethod() {
        Method method = this.signature.getAsmMethod();
        if (method == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/CallableMethod", "getAsmMethod"));
        }
        return method;
    }

    public int getInvokeOpcode() {
        return this.invokeOpcode;
    }

    @Nullable
    public Type getThisType() {
        return this.thisClass;
    }

    @Nullable
    public Type getReceiverClass() {
        return this.receiverParameterType;
    }

    private void invoke(InstructionAdapter v) {
        v.visitMethodInsn(this.getInvokeOpcode(), this.owner.getInternalName(), this.getAsmMethod().getName(), this.getAsmMethod().getDescriptor());
    }

    public void invokeWithNotNullAssertion(@NotNull InstructionAdapter v, @NotNull GenerationState state, @NotNull ResolvedCall resolvedCall) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/CallableMethod", "invokeWithNotNullAssertion"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/CallableMethod", "invokeWithNotNullAssertion"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/codegen/CallableMethod", "invokeWithNotNullAssertion"));
        }
        this.invokeWithoutAssertions(v);
        AsmUtil.genNotNullAssertionForMethod(v, state, resolvedCall);
    }

    public void invokeWithoutAssertions(@NotNull InstructionAdapter v) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/CallableMethod", "invokeWithoutAssertions"));
        }
        this.invoke(v);
    }

    @Nullable
    public Type getGenerateCalleeType() {
        return this.generateCalleeType;
    }

    private void invokeDefault(InstructionAdapter v) {
        if (this.defaultImplOwner == null || this.defaultImplParam == null) {
            throw new IllegalStateException();
        }
        Method method = this.getAsmMethod();
        String desc = method.getDescriptor().replace(")", "I)");
        if ("<init>".equals(method.getName())) {
            v.visitMethodInsn(183, this.defaultImplOwner.getInternalName(), "<init>", desc, false);
        } else {
            if (this.getInvokeOpcode() != 184) {
                desc = desc.replace("(", "(" + this.defaultImplParam.getDescriptor());
            }
            v.visitMethodInsn(184, this.defaultImplOwner.getInternalName(), method.getName() + "$default", desc, false);
        }
    }

    public void invokeDefaultWithNotNullAssertion(@NotNull InstructionAdapter v, @NotNull GenerationState state, @NotNull ResolvedCall resolvedCall) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/CallableMethod", "invokeDefaultWithNotNullAssertion"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/CallableMethod", "invokeDefaultWithNotNullAssertion"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/codegen/CallableMethod", "invokeDefaultWithNotNullAssertion"));
        }
        this.invokeDefault(v);
        AsmUtil.genNotNullAssertionForMethod(v, state, resolvedCall);
    }

    public boolean isNeedsThis() {
        return this.thisClass != null && this.generateCalleeType == null;
    }

    @NotNull
    public Type getReturnType() {
        Type type = this.signature.getReturnType();
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/CallableMethod", "getReturnType"));
        }
        return type;
    }

    public String toString() {
        return Printer.OPCODES[this.invokeOpcode] + " " + this.owner.getInternalName() + "." + this.signature;
    }
}

