/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common.arguments;

import com.sampullara.cli.Argument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.jet.cli.common.arguments.ValueDescription;

public class K2JVMCompilerArguments
extends CommonCompilerArguments {
    @Argument(value="d", description="Destination for generated class files")
    @ValueDescription(value="<directory|jar>")
    public String destination;
    @Argument(value="classpath", description="Paths where to find user class files")
    @ValueDescription(value="<path>")
    public String classpath;
    @Argument(value="annotations", description="Paths to external annotations")
    @ValueDescription(value="<path>")
    public String annotations;
    @Argument(value="includeRuntime", description="Include Kotlin runtime in to resulting .jar")
    public boolean includeRuntime;
    @Argument(value="noJdk", description="Don't include Java runtime into classpath")
    public boolean noJdk;
    @Argument(value="noStdlib", description="Don't include Kotlin runtime into classpath")
    public boolean noStdlib;
    @Argument(value="noJdkAnnotations", description="Don't include JDK external annotations into classpath")
    public boolean noJdkAnnotations;
    @Argument(value="notNullAssertions", description="Generate not-null assertion after each invocation of method returning not-null")
    public boolean notNullAssertions;
    @Argument(value="notNullParamAssertions", description="Generate not-null assertions on parameters of methods accessible from Java")
    public boolean notNullParamAssertions;
    @Argument(value="module", description="Path to the module file to compile")
    @ValueDescription(value="<path>")
    public String module;
    @Argument(value="script", description="Evaluate the script file")
    public boolean script;
    @Argument(value="kotlinHome", description="Path to Kotlin compiler home directory, used for annotations and runtime libraries discovery")
    @ValueDescription(value="<path>")
    public String kotlinHome;
    @Argument(value="inline", description="Inlining mode (default is on)")
    @ValueDescription(value="{on,off}")
    public String inline;
    @Argument(value="optimize", description="Optimization mode (default is on)")
    @ValueDescription(value="{on,off}")
    public String optimize;

    @Override
    @NotNull
    public String executableScriptFileName() {
        if ("kotlinc-jvm" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/arguments/K2JVMCompilerArguments", "executableScriptFileName"));
        }
        return "kotlinc-jvm";
    }
}

