/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common.arguments;

import com.intellij.util.SmartList;
import com.sampullara.cli.Argument;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.cli.common.arguments.ValueDescription;

public abstract class CommonCompilerArguments {
    @Argument(value="tags", description="Demarcate each compilation message (error, warning, etc) with an open and close tag")
    public boolean tags;
    @Argument(value="verbose", description="Enable verbose logging output")
    public boolean verbose;
    @Argument(value="version", description="Display compiler version")
    public boolean version;
    @Argument(value="help", alias="h", description="Print a synopsis of standard options")
    public boolean help;
    @Argument(value="suppress", description="Suppress all compiler warnings")
    @ValueDescription(value="warnings")
    public String suppress;
    public List<String> freeArgs = new SmartList<String>();

    public boolean suppressAllWarnings() {
        return "warnings".equalsIgnoreCase(this.suppress);
    }

    @NotNull
    public String executableScriptFileName() {
        if ("kotlinc" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/arguments/CommonCompilerArguments", "executableScriptFileName"));
        }
        return "kotlinc";
    }

    public static final class DummyImpl
    extends CommonCompilerArguments {
    }
}

