/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.XmlSerializerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BasePrimitiveBinding
implements Binding {
    protected final Accessor myAccessor;
    protected final String myName;
    @Nullable
    protected final Converter<Object> myConverter;
    @Nullable
    protected Binding myBinding;

    protected BasePrimitiveBinding(@NotNull Accessor accessor, @Nullable String suggestedName, @Nullable Class<? extends Converter> converterClass) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/BasePrimitiveBinding", "<init>"));
        }
        this.myAccessor = accessor;
        this.myName = StringUtil.isEmpty(suggestedName) ? this.myAccessor.getName() : suggestedName;
        this.myConverter = converterClass == null || converterClass == Converter.class ? null : XmlSerializerImpl.newInstance(converterClass);
    }

    @Override
    public void init() {
        if (this.myConverter == null) {
            this.myBinding = XmlSerializerImpl.getBinding(this.myAccessor);
        }
    }
}

