/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.containers.WeakHashMap;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

public class WeakStringInterner
extends StringInterner {
    private final WeakHashMap<String, WeakReference<String>> myMap = new WeakHashMap();

    @Override
    @NotNull
    public String intern(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/containers/WeakStringInterner", "intern"));
        }
        String interned = (String)SoftReference.dereference((Reference)this.myMap.get(name));
        if (interned != null) {
            String string = interned;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/WeakStringInterner", "intern"));
            }
            return string;
        }
        this.myMap.put((Object)name, new WeakReference<String>(name));
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/WeakStringInterner", "intern"));
        }
        return string;
    }
}

