/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.List;
import java.util.RandomAccess;

public class Stack<T>
extends ArrayList<T> {
    public Stack() {
    }

    public Stack(Collection<T> init) {
        super(init);
    }

    public void push(T t) {
        this.add(t);
    }

    public T peek() {
        int size = this.size();
        if (size == 0) {
            throw new EmptyStackException();
        }
        return (T)this.get(size - 1);
    }

    public T pop() {
        int size = this.size();
        if (size == 0) {
            throw new EmptyStackException();
        }
        return (T)this.remove(size - 1);
    }

    public boolean empty() {
        return this.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof RandomAccess && o instanceof List) {
            List other = (List)o;
            if (this.size() != other.size()) {
                return false;
            }
            for (int i = 0; i < other.size(); ++i) {
                Object o1 = other.get(i);
                Object o2 = this.get(i);
                if (o1 != null ? o1.equals(o2) : o2 == null) continue;
                return false;
            }
            return true;
        }
        return super.equals(o);
    }
}

