/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class SequenceIterator<T>
implements Iterator<T> {
    private final Iterator<T>[] myIterators;
    private int myCurrentIndex;

    public SequenceIterator(Iterator<T> ... iterators) {
        if (iterators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterators", "com/intellij/util/containers/SequenceIterator", "<init>"));
        }
        this.myIterators = new Iterator[iterators.length];
        System.arraycopy(iterators, 0, this.myIterators, 0, iterators.length);
    }

    @Override
    public boolean hasNext() {
        for (int index = this.myCurrentIndex; index < this.myIterators.length; ++index) {
            Iterator<T> iterator2 = this.myIterators[index];
            if (iterator2 == null || !iterator2.hasNext()) continue;
            this.myCurrentIndex = index;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.myIterators[this.myCurrentIndex].next();
        }
        throw new NoSuchElementException("Iterator has no more elements");
    }

    @Override
    public void remove() {
        if (this.myCurrentIndex >= this.myIterators.length) {
            throw new IllegalStateException();
        }
        this.myIterators[this.myCurrentIndex].remove();
    }
}

