/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.java.PsiCommaSeparatedListImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AnnotationParamListElement
extends PsiCommaSeparatedListImpl
implements PsiAnnotationParameterList {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.AnnotationParamListElement");
    private volatile PsiNameValuePair[] myCachedMembers = null;

    public AnnotationParamListElement() {
        super(ANNOTATION_PARAMETER_LIST, NAME_VALUE_PAIR_BIT_SET);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedMembers = null;
    }

    @Override
    @NotNull
    public PsiNameValuePair[] getAttributes() {
        PsiNameValuePair[] cachedMembers = this.myCachedMembers;
        if (cachedMembers == null) {
            cachedMembers = (PsiNameValuePair[])this.getChildrenAsPsiElements(NAME_VALUE_PAIR_BIT_SET, PsiNameValuePair.ARRAY_FACTORY);
            this.myCachedMembers = cachedMembers;
        }
        if (cachedMembers == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/AnnotationParamListElement", "getAttributes"));
        }
        return cachedMembers;
    }

    @Override
    public int getChildRole(ASTNode child) {
        IElementType i = child.getElementType();
        if (i == COMMA) {
            return 23;
        }
        if (i == LPARENTH) {
            return 24;
        }
        if (i == RPARENTH) {
            return 25;
        }
        if (ANNOTATION_MEMBER_VALUE_BIT_SET.contains(child.getElementType()) || i == NAME_VALUE_PAIR && child.getFirstChildNode() != null && child.getFirstChildNode().getElementType() == ANNOTATION_ARRAY_INITIALIZER) {
            return 249;
        }
        return 0;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        switch (role) {
            default: {
                LOG.assertTrue(false);
                return null;
            }
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 25: 
        }
        return this.findChildByType(RPARENTH);
    }

    @Override
    public String toString() {
        return "PsiAnnotationParameterList";
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/java/AnnotationParamListElement", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotationParameterList(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        if (first.getElementType() == NAME_VALUE_PAIR && last.getElementType() == NAME_VALUE_PAIR) {
            PsiNameValuePair pair;
            ASTNode node;
            ASTNode[] nodes;
            ASTNode rparenth;
            CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
            ASTNode lparenth = this.findChildByRole(24);
            if (lparenth == null) {
                LeafElement created = Factory.createSingleLeafElement(LPARENTH, "(", 0, 1, treeCharTab, this.getManager());
                super.addInternal(created, created, this.getFirstChildNode(), true);
            }
            if ((rparenth = this.findChildByRole(25)) == null) {
                LeafElement created = Factory.createSingleLeafElement(RPARENTH, ")", 0, 1, treeCharTab, this.getManager());
                super.addInternal(created, created, this.getLastChildNode(), false);
            }
            if ((nodes = this.getChildren(NAME_VALUE_PAIR_BIT_SET)).length == 1 && (node = nodes[0]) instanceof PsiNameValuePair && (pair = (PsiNameValuePair)((Object)node)).getName() == null) {
                String text = pair.getValue().getText();
                try {
                    PsiAnnotation annotation = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createAnnotationFromText("@AAA(value = " + text + ")", null);
                    this.replaceChild(node, annotation.getParameterList().getAttributes()[0].getNode());
                }
                catch (IncorrectOperationException e) {
                    LOG.error(e);
                }
            }
            if (anchor == null && before != null) {
                anchor = this.findChildByRole(before != false ? 25 : 24);
            }
        }
        return super.addInternal(first, last, anchor, before);
    }
}

