/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullableNotNullManager {
    private static final Logger LOG = Logger.getInstance("#" + NullableNotNullManager.class.getName());
    public String myDefaultNullable = "org.jetbrains.annotations.Nullable";
    public String myDefaultNotNull = "org.jetbrains.annotations.NotNull";
    public final JDOMExternalizableStringList myNullables = new JDOMExternalizableStringList();
    public final JDOMExternalizableStringList myNotNulls = new JDOMExternalizableStringList();
    public static final String[] DEFAULT_NULLABLES = new String[]{"org.jetbrains.annotations.Nullable", "javax.annotation.Nullable", "edu.umd.cs.findbugs.annotations.Nullable", "android.support.annotation.Nullable"};
    public static final String[] DEFAULT_NOT_NULLS = new String[]{"org.jetbrains.annotations.NotNull", "javax.annotation.Nonnull", "edu.umd.cs.findbugs.annotations.NonNull", "android.support.annotation.NonNull"};

    public NullableNotNullManager() {
        Collections.addAll(this.myNotNulls, DEFAULT_NOT_NULLS);
        Collections.addAll(this.myNullables, DEFAULT_NULLABLES);
    }

    public static NullableNotNullManager getInstance(Project project) {
        return ServiceManager.getService(project, NullableNotNullManager.class);
    }

    @Nullable
    public String getNullable(PsiModifierListOwner owner) {
        PsiAnnotation annotation = this.getNullableAnnotation(owner, false);
        return annotation == null ? null : annotation.getQualifiedName();
    }

    @Nullable
    public PsiAnnotation getNullableAnnotation(PsiModifierListOwner owner, boolean checkBases) {
        return this.findNullabilityAnnotation(owner, checkBases, true);
    }

    @Nullable
    public PsiAnnotation getNotNullAnnotation(PsiModifierListOwner owner, boolean checkBases) {
        return this.findNullabilityAnnotation(owner, checkBases, false);
    }

    @Nullable
    public String getNotNull(PsiModifierListOwner owner) {
        PsiAnnotation annotation = this.getNotNullAnnotation(owner, false);
        return annotation == null ? null : annotation.getQualifiedName();
    }

    @Nullable
    private PsiAnnotation findNullabilityAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases, boolean nullable) {
        PsiAnnotation annotation;
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/NullableNotNullManager", "findNullabilityAnnotation"));
        }
        HashSet<String> qNames = ContainerUtil.newHashSet(nullable ? this.getNullables() : this.getNotNulls());
        PsiAnnotation psiAnnotation = annotation = checkBases && (owner instanceof PsiClass || owner instanceof PsiMethod) ? AnnotationUtil.findAnnotationInHierarchy(owner, qNames) : AnnotationUtil.findAnnotation(owner, qNames);
        if (annotation != null) {
            return annotation;
        }
        if (owner instanceof PsiParameter && !TypeConversionUtil.isPrimitiveAndNotNull(((PsiParameter)owner).getType())) {
            if (AnnotationUtil.isAnnotated(owner, nullable ? Arrays.asList(DEFAULT_NOT_NULLS) : Arrays.asList(DEFAULT_NULLABLES), checkBases, false)) {
                return null;
            }
            return NullableNotNullManager.findContainerAnnotation(owner, nullable ? "javax.annotation.ParametersAreNullableByDefault" : "javax.annotation.ParametersAreNonnullByDefault");
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation findContainerAnnotation(PsiModifierListOwner owner, String annotationFQN) {
        for (PsiElement element = owner.getParent(); element != null; element = element.getContext()) {
            PsiAnnotation annotation;
            if (element instanceof PsiModifierListOwner && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)element, annotationFQN)) != null) {
                return annotation;
            }
            if (!(element instanceof PsiClassOwner)) continue;
            String packageName = ((PsiClassOwner)element).getPackageName();
            PsiPackage psiPackage = JavaPsiFacade.getInstance(element.getProject()).findPackage(packageName);
            return AnnotationUtil.findAnnotation((PsiModifierListOwner)psiPackage, annotationFQN);
        }
        return null;
    }

    public List<String> getNullables() {
        return this.myNullables;
    }

    public List<String> getNotNulls() {
        return this.myNotNulls;
    }
}

