/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.reference.AccessTranslator;
import org.jetbrains.k2js.translate.reference.BackingFieldAccessTranslator;
import org.jetbrains.k2js.translate.reference.ClassObjectAccessTranslator;
import org.jetbrains.k2js.translate.reference.ReferenceAccessTranslator;
import org.jetbrains.k2js.translate.reference.VariableAccessTranslator;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public final class ReferenceTranslator {
    private ReferenceTranslator() {
    }

    @NotNull
    public static JsExpression translateSimpleName(@NotNull JetSimpleNameExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "translateSimpleName"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "translateSimpleName"));
        }
        JsExpression jsExpression = ReferenceTranslator.getAccessTranslator(expression, context2).translateAsGet();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "translateSimpleName"));
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateSimpleNameWithQualifier(@NotNull JetSimpleNameExpression expression, @Nullable JsExpression qualifier, @NotNull TranslationContext context2) {
        ClassDescriptor entryClass;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "translateSimpleNameWithQualifier"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "translateSimpleNameWithQualifier"));
        }
        JsExpression simpleName = ReferenceTranslator.translateSimpleName(expression, context2);
        DeclarationDescriptor descriptor = BindingUtils.getDescriptorForReferenceExpression(context2.bindingContext(), expression);
        if (descriptor instanceof ClassDescriptor && (entryClass = (ClassDescriptor)descriptor).getKind() == ClassKind.ENUM_ENTRY) {
            DeclarationDescriptor enumClass = entryClass.getContainingDeclaration();
            qualifier = Namer.getClassObjectAccessor(ReferenceTranslator.translateAsFQReference(enumClass, context2));
        }
        if (qualifier != null) {
            JsAstUtils.setQualifier(simpleName, qualifier);
        }
        JsExpression jsExpression = simpleName;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "translateSimpleNameWithQualifier"));
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateAsFQReference(@NotNull DeclarationDescriptor referencedDescriptor, @NotNull TranslationContext context2) {
        if (referencedDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedDescriptor", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "translateAsFQReference"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "translateAsFQReference"));
        }
        JsExpression alias = context2.getAliasForDescriptor(referencedDescriptor);
        JsExpression jsExpression = alias != null ? alias : context2.getQualifiedReference(referencedDescriptor);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "translateAsFQReference"));
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateAsLocalNameReference(@NotNull DeclarationDescriptor descriptor, @NotNull TranslationContext context2) {
        JsExpression alias;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "translateAsLocalNameReference"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "translateAsLocalNameReference"));
        }
        if ((descriptor instanceof FunctionDescriptor || descriptor instanceof VariableDescriptor) && (alias = context2.getAliasForDescriptor(descriptor)) != null) {
            JsExpression jsExpression = alias;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "translateAsLocalNameReference"));
            }
            return jsExpression;
        }
        JsNameRef jsNameRef = context2.getNameForDescriptor(descriptor).makeRef();
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "translateAsLocalNameReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull JetSimpleNameExpression referenceExpression, @NotNull TranslationContext context2) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
        }
        AccessTranslator accessTranslator = ReferenceTranslator.getAccessTranslator(referenceExpression, null, context2);
        if (accessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
        }
        return accessTranslator;
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull JetSimpleNameExpression referenceExpression, @Nullable JsExpression receiver, @NotNull TranslationContext context2) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
        }
        if (JetPsiUtil.isBackingFieldReference(referenceExpression)) {
            BackingFieldAccessTranslator backingFieldAccessTranslator = BackingFieldAccessTranslator.newInstance(referenceExpression, context2);
            if (backingFieldAccessTranslator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
            }
            return backingFieldAccessTranslator;
        }
        if (ReferenceTranslator.canBePropertyAccess(referenceExpression, context2)) {
            VariableAccessTranslator variableAccessTranslator = VariableAccessTranslator.newInstance(context2, referenceExpression, receiver);
            if (variableAccessTranslator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
            }
            return variableAccessTranslator;
        }
        if (ClassObjectAccessTranslator.isClassObjectReference(referenceExpression, context2)) {
            ClassObjectAccessTranslator classObjectAccessTranslator = ClassObjectAccessTranslator.newInstance(referenceExpression, context2);
            if (classObjectAccessTranslator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
            }
            return classObjectAccessTranslator;
        }
        ReferenceAccessTranslator referenceAccessTranslator = ReferenceAccessTranslator.newInstance(referenceExpression, context2);
        if (referenceAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
        }
        return referenceAccessTranslator;
    }

    public static boolean canBePropertyAccess(@NotNull JetExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "canBePropertyAccess"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/ReferenceTranslator", "canBePropertyAccess"));
        }
        JetSimpleNameExpression simpleNameExpression = null;
        if (expression instanceof JetQualifiedExpression) {
            simpleNameExpression = PsiUtils.getSelectorAsSimpleName((JetQualifiedExpression)expression);
        } else if (expression instanceof JetSimpleNameExpression) {
            simpleNameExpression = (JetSimpleNameExpression)expression;
        }
        if (simpleNameExpression == null) {
            return false;
        }
        DeclarationDescriptor descriptor = BindingUtils.getDescriptorForReferenceExpression(context2.bindingContext(), simpleNameExpression);
        return descriptor instanceof VariableDescriptor && !(descriptor instanceof ValueParameterDescriptor);
    }
}

