/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.reference.AccessTranslator;
import org.jetbrains.k2js.translate.reference.ArrayAccessTranslator;
import org.jetbrains.k2js.translate.reference.CachedAccessTranslator;
import org.jetbrains.k2js.translate.reference.QualifiedExpressionTranslator;
import org.jetbrains.k2js.translate.reference.ReferenceTranslator;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class AccessTranslationUtils {
    private AccessTranslationUtils() {
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull JetExpression referenceExpression, @NotNull TranslationContext context2) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
        }
        AccessTranslator accessTranslator = AccessTranslationUtils.getAccessTranslator(referenceExpression, context2, false);
        if (accessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
        }
        return accessTranslator;
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull JetExpression referenceExpression, @NotNull TranslationContext context2, boolean forceOrderOfEvaluation) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
        }
        assert (referenceExpression instanceof JetReferenceExpression || referenceExpression instanceof JetQualifiedExpression);
        if (referenceExpression instanceof JetQualifiedExpression) {
            AccessTranslator accessTranslator = QualifiedExpressionTranslator.getAccessTranslator((JetQualifiedExpression)referenceExpression, context2, forceOrderOfEvaluation);
            if (accessTranslator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
            }
            return accessTranslator;
        }
        if (referenceExpression instanceof JetSimpleNameExpression) {
            AccessTranslator accessTranslator = ReferenceTranslator.getAccessTranslator((JetSimpleNameExpression)referenceExpression, context2);
            if (accessTranslator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
            }
            return accessTranslator;
        }
        assert (referenceExpression instanceof JetArrayAccessExpression);
        AccessTranslator accessTranslator = AccessTranslationUtils.getArrayAccessTranslator((JetArrayAccessExpression)referenceExpression, context2, forceOrderOfEvaluation);
        if (accessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "getAccessTranslator"));
        }
        return accessTranslator;
    }

    @NotNull
    private static AccessTranslator getArrayAccessTranslator(@NotNull JetArrayAccessExpression expression, @NotNull TranslationContext context2, boolean forceOrderOfEvaluation) {
        TranslationContext accessArrayContext;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "getArrayAccessTranslator"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "getArrayAccessTranslator"));
        }
        if (forceOrderOfEvaluation) {
            LinkedHashMap<JetExpression, JsExpression> indexesMap = new LinkedHashMap<JetExpression, JsExpression>();
            for (JetExpression indexExpression : expression.getIndexExpressions()) {
                JsExpression jsIndexExpression = Translation.translateAsExpression(indexExpression, context2);
                if (TranslationUtils.isCacheNeeded(jsIndexExpression)) {
                    TemporaryVariable temporaryVariable = context2.declareTemporary(null);
                    context2.addStatementToCurrentBlock(JsAstUtils.assignment(temporaryVariable.reference(), jsIndexExpression).makeStmt());
                    jsIndexExpression = temporaryVariable.reference();
                }
                indexesMap.put(indexExpression, jsIndexExpression);
            }
            accessArrayContext = context2.innerContextWithAliasesForExpressions(indexesMap);
        } else {
            accessArrayContext = context2;
        }
        ArrayAccessTranslator arrayAccessTranslator = ArrayAccessTranslator.newInstance(expression, accessArrayContext);
        if (arrayAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "getArrayAccessTranslator"));
        }
        return arrayAccessTranslator;
    }

    @NotNull
    public static CachedAccessTranslator getCachedAccessTranslator(@NotNull JetExpression referenceExpression, @NotNull TranslationContext context2) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "getCachedAccessTranslator"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "getCachedAccessTranslator"));
        }
        CachedAccessTranslator cachedAccessTranslator = AccessTranslationUtils.getAccessTranslator(referenceExpression, context2).getCached();
        if (cachedAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "getCachedAccessTranslator"));
        }
        return cachedAccessTranslator;
    }

    @NotNull
    public static JsExpression translateAsGet(@NotNull JetExpression expression, @NotNull TranslationContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "translateAsGet"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "translateAsGet"));
        }
        JsExpression jsExpression = AccessTranslationUtils.getAccessTranslator(expression, context2).translateAsGet();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/reference/AccessTranslationUtils", "translateAsGet"));
        }
        return jsExpression;
    }
}

