/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetIsExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.NamePredicate;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class PatternTranslator
extends AbstractTranslator {
    @NotNull
    public static PatternTranslator newInstance(@NotNull TranslationContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/PatternTranslator", "newInstance"));
        }
        PatternTranslator patternTranslator = new PatternTranslator(context2);
        if (patternTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/PatternTranslator", "newInstance"));
        }
        return patternTranslator;
    }

    private PatternTranslator(@NotNull TranslationContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/PatternTranslator", "<init>"));
        }
        super(context2);
    }

    @NotNull
    public JsExpression translateIsExpression(@NotNull JetIsExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/PatternTranslator", "translateIsExpression"));
        }
        JsExpression left = Translation.translateAsExpression(expression.getLeftHandSide(), this.context());
        JetTypeReference typeReference = expression.getTypeRef();
        assert (typeReference != null);
        JsExpression result2 = this.translateIsCheck(left, typeReference);
        if (expression.isNegated()) {
            JsPrefixOperation jsPrefixOperation = JsAstUtils.negated(result2);
            if (jsPrefixOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/PatternTranslator", "translateIsExpression"));
            }
            return jsPrefixOperation;
        }
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/PatternTranslator", "translateIsExpression"));
        }
        return jsExpression;
    }

    @NotNull
    public JsExpression translateIsCheck(@NotNull JsExpression subject, @NotNull JetTypeReference typeReference) {
        if (subject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subject", "org/jetbrains/k2js/translate/expression/PatternTranslator", "translateIsCheck"));
        }
        if (typeReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeReference", "org/jetbrains/k2js/translate/expression/PatternTranslator", "translateIsCheck"));
        }
        JsExpression result2 = this.translateAsIntrinsicTypeCheck(subject, typeReference);
        if (result2 != null) {
            JsExpression jsExpression = result2;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/PatternTranslator", "translateIsCheck"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = this.translateAsIsCheck(subject, typeReference);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/PatternTranslator", "translateIsCheck"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateAsIsCheck(@NotNull JsExpression expressionToMatch, @NotNull JetTypeReference typeReference) {
        if (expressionToMatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToMatch", "org/jetbrains/k2js/translate/expression/PatternTranslator", "translateAsIsCheck"));
        }
        if (typeReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeReference", "org/jetbrains/k2js/translate/expression/PatternTranslator", "translateAsIsCheck"));
        }
        JsInvocation isCheck = new JsInvocation(this.context().namer().isOperationReference(), expressionToMatch, this.getClassNameReference(typeReference));
        if (this.isNullable(typeReference)) {
            JsExpression jsExpression = PatternTranslator.addNullCheck(expressionToMatch, isCheck);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/PatternTranslator", "translateAsIsCheck"));
            }
            return jsExpression;
        }
        JsInvocation jsInvocation = isCheck;
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/PatternTranslator", "translateAsIsCheck"));
        }
        return jsInvocation;
    }

    @Nullable
    private JsExpression translateAsIntrinsicTypeCheck(@NotNull JsExpression expressionToMatch, @NotNull JetTypeReference typeReference) {
        String jsSTypeName;
        if (expressionToMatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToMatch", "org/jetbrains/k2js/translate/expression/PatternTranslator", "translateAsIntrinsicTypeCheck"));
        }
        if (typeReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeReference", "org/jetbrains/k2js/translate/expression/PatternTranslator", "translateAsIntrinsicTypeCheck"));
        }
        Name typeName = JsDescriptorUtils.getNameIfStandardType(BindingUtils.getTypeByReference(this.bindingContext(), typeReference));
        if (typeName == null) {
            return null;
        }
        if (NamePredicate.STRING.apply(typeName)) {
            jsSTypeName = "string";
        } else {
            if (NamePredicate.LONG.apply(typeName)) {
                return JsAstUtils.isLong(expressionToMatch);
            }
            if (NamePredicate.NUMBER.apply(typeName)) {
                return JsAstUtils.isNumber(expressionToMatch);
            }
            if (NamePredicate.CHAR.apply(typeName)) {
                return JsAstUtils.isChar(expressionToMatch);
            }
            if (NamePredicate.PRIMITIVE_NUMBERS_MAPPED_TO_PRIMITIVE_JS.apply(typeName)) {
                jsSTypeName = "number";
            } else {
                return null;
            }
        }
        return JsAstUtils.typeof(expressionToMatch, this.program().getStringLiteral(jsSTypeName));
    }

    @NotNull
    private static JsExpression addNullCheck(@NotNull JsExpression expressionToMatch, @NotNull JsInvocation isCheck) {
        if (expressionToMatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToMatch", "org/jetbrains/k2js/translate/expression/PatternTranslator", "addNullCheck"));
        }
        if (isCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isCheck", "org/jetbrains/k2js/translate/expression/PatternTranslator", "addNullCheck"));
        }
        JsBinaryOperation jsBinaryOperation = JsAstUtils.or(TranslationUtils.isNullCheck(expressionToMatch), isCheck);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/PatternTranslator", "addNullCheck"));
        }
        return jsBinaryOperation;
    }

    private boolean isNullable(JetTypeReference typeReference) {
        return BindingUtils.getTypeByReference(this.bindingContext(), typeReference).isNullable();
    }

    @NotNull
    private JsNameRef getClassNameReference(@NotNull JetTypeReference typeReference) {
        if (typeReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeReference", "org/jetbrains/k2js/translate/expression/PatternTranslator", "getClassNameReference"));
        }
        ClassDescriptor referencedClass = BindingUtils.getClassDescriptorForTypeReference(this.bindingContext(), typeReference);
        JsNameRef jsNameRef = this.context().getQualifiedReference(referencedClass);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/PatternTranslator", "getClassNameReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsExpression translateExpressionPattern(@NotNull JsExpression expressionToMatch, @NotNull JetExpression patternExpression) {
        if (expressionToMatch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToMatch", "org/jetbrains/k2js/translate/expression/PatternTranslator", "translateExpressionPattern"));
        }
        if (patternExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternExpression", "org/jetbrains/k2js/translate/expression/PatternTranslator", "translateExpressionPattern"));
        }
        JsExpression expressionToMatchAgainst = this.translateExpressionForExpressionPattern(patternExpression);
        JsBinaryOperation jsBinaryOperation = JsAstUtils.equality(expressionToMatch, expressionToMatchAgainst);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/PatternTranslator", "translateExpressionPattern"));
        }
        return jsBinaryOperation;
    }

    @NotNull
    public JsExpression translateExpressionForExpressionPattern(@NotNull JetExpression patternExpression) {
        if (patternExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternExpression", "org/jetbrains/k2js/translate/expression/PatternTranslator", "translateExpressionForExpressionPattern"));
        }
        JsExpression jsExpression = Translation.translateAsExpression(patternExpression, this.context());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/PatternTranslator", "translateExpressionForExpressionPattern"));
        }
        return jsExpression;
    }
}

