/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.renderer;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.renderer.DescriptorRenderer;
import org.jetbrains.jet.renderer.DescriptorRendererImpl;

public class DescriptorRendererBuilder {
    private boolean shortNames = false;
    private boolean withDefinedIn = true;
    private Set<DescriptorRenderer.Modifier> modifiers = EnumSet.allOf(DescriptorRenderer.Modifier.class);
    private boolean startFromName = false;
    private boolean debugMode = false;
    private boolean classWithPrimaryConstructor = false;
    private boolean verbose = false;
    private boolean unitReturnType = true;
    private boolean normalizedVisibilities = false;
    private boolean showInternalKeyword = true;
    private boolean prettyFunctionTypes = true;
    private boolean uninferredTypeParameterAsName = false;
    private boolean includePropertyConstant = false;
    private boolean includeSynthesizedParameterNames = true;
    private boolean withoutFunctionParameterNames = false;
    private boolean withoutTypeParameters = false;
    private boolean withoutSuperTypes = false;
    private Function1<JetType, JetType> typeNormalizer = new Function1<JetType, JetType>(){

        @Override
        public JetType invoke(JetType type) {
            return type;
        }
    };
    @NotNull
    private DescriptorRenderer.OverrideRenderingPolicy overrideRenderingPolicy = DescriptorRenderer.OverrideRenderingPolicy.RENDER_OPEN;
    @NotNull
    private DescriptorRenderer.ValueParametersHandler valueParametersHandler = new DescriptorRenderer.DefaultValueParameterHandler();
    @NotNull
    private DescriptorRenderer.TextFormat textFormat = DescriptorRenderer.TextFormat.PLAIN;
    @NotNull
    private Collection<FqName> excludedAnnotationClasses = Collections.emptyList();
    private boolean receiverAfterName = false;
    private boolean renderClassObjectName = false;

    @NotNull
    public DescriptorRendererBuilder setShortNames(boolean shortNames) {
        this.shortNames = shortNames;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "setShortNames"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setWithDefinedIn(boolean withDefinedIn) {
        this.withDefinedIn = withDefinedIn;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "setWithDefinedIn"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setModifiers(Set<DescriptorRenderer.Modifier> modifiers) {
        this.modifiers = modifiers;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "setModifiers"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setModifiers(DescriptorRenderer.Modifier ... modifiers) {
        DescriptorRendererBuilder descriptorRendererBuilder = this.setModifiers(KotlinPackage.setOf(modifiers));
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "setModifiers"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setStartFromName(boolean startFromName) {
        this.startFromName = startFromName;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "setStartFromName"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "setDebugMode"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setClassWithPrimaryConstructor(boolean classWithPrimaryConstructor) {
        this.classWithPrimaryConstructor = classWithPrimaryConstructor;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "setClassWithPrimaryConstructor"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setVerbose(boolean verbose) {
        this.verbose = verbose;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "setVerbose"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setUnitReturnType(boolean unitReturnType) {
        this.unitReturnType = unitReturnType;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "setUnitReturnType"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setNormalizedVisibilities(boolean normalizedVisibilities) {
        this.normalizedVisibilities = normalizedVisibilities;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "setNormalizedVisibilities"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setShowInternalKeyword(boolean showInternalKeyword) {
        this.showInternalKeyword = showInternalKeyword;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "setShowInternalKeyword"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setOverrideRenderingPolicy(@NotNull DescriptorRenderer.OverrideRenderingPolicy overrideRenderingPolicy) {
        if (overrideRenderingPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overrideRenderingPolicy", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "setOverrideRenderingPolicy"));
        }
        this.overrideRenderingPolicy = overrideRenderingPolicy;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "setOverrideRenderingPolicy"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setValueParametersHandler(@NotNull DescriptorRenderer.ValueParametersHandler valueParametersHandler) {
        if (valueParametersHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParametersHandler", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "setValueParametersHandler"));
        }
        this.valueParametersHandler = valueParametersHandler;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "setValueParametersHandler"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setTextFormat(@NotNull DescriptorRenderer.TextFormat textFormat) {
        if (textFormat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textFormat", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "setTextFormat"));
        }
        this.textFormat = textFormat;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "setTextFormat"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setExcludedAnnotationClasses(@NotNull Collection<FqName> excludedAnnotationClasses) {
        if (excludedAnnotationClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedAnnotationClasses", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "setExcludedAnnotationClasses"));
        }
        this.excludedAnnotationClasses = excludedAnnotationClasses;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "setExcludedAnnotationClasses"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setPrettyFunctionTypes(boolean prettyFunctionTypes) {
        this.prettyFunctionTypes = prettyFunctionTypes;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "setPrettyFunctionTypes"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRendererBuilder setUninferredTypeParameterAsName(boolean uninferredTypeParameterAsName) {
        this.uninferredTypeParameterAsName = uninferredTypeParameterAsName;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "setUninferredTypeParameterAsName"));
        }
        return descriptorRendererBuilder;
    }

    public DescriptorRendererBuilder setIncludePropertyConstant(boolean includePropertyConstant) {
        this.includePropertyConstant = includePropertyConstant;
        return this;
    }

    public DescriptorRendererBuilder setIncludeSynthesizedParameterNames(boolean includeSynthesizedParameterNames) {
        this.includeSynthesizedParameterNames = includeSynthesizedParameterNames;
        return this;
    }

    public DescriptorRendererBuilder setWithoutTypeParameters(boolean withoutTypeParameters) {
        this.withoutTypeParameters = withoutTypeParameters;
        return this;
    }

    public DescriptorRendererBuilder setWithoutFunctionParameterNames(boolean withoutFunctionParameterNames) {
        this.withoutFunctionParameterNames = withoutFunctionParameterNames;
        return this;
    }

    public DescriptorRendererBuilder setReceiverAfterName(boolean receiverAfterName) {
        this.receiverAfterName = receiverAfterName;
        return this;
    }

    public DescriptorRendererBuilder setRenderClassObjectName(boolean renderClassObjectName) {
        this.renderClassObjectName = renderClassObjectName;
        return this;
    }

    public DescriptorRendererBuilder setWithoutSuperTypes(boolean withoutSuperTypes) {
        this.withoutSuperTypes = withoutSuperTypes;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setTypeNormalizer(@NotNull Function1<JetType, JetType> typeNormalizer) {
        if (typeNormalizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeNormalizer", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "setTypeNormalizer"));
        }
        this.typeNormalizer = typeNormalizer;
        DescriptorRendererBuilder descriptorRendererBuilder = this;
        if (descriptorRendererBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "setTypeNormalizer"));
        }
        return descriptorRendererBuilder;
    }

    @NotNull
    public DescriptorRenderer build() {
        DescriptorRendererImpl descriptorRendererImpl = new DescriptorRendererImpl(this.shortNames, this.withDefinedIn, this.modifiers, this.startFromName, this.debugMode, this.classWithPrimaryConstructor, this.verbose, this.unitReturnType, this.normalizedVisibilities, this.showInternalKeyword, this.prettyFunctionTypes, this.uninferredTypeParameterAsName, this.overrideRenderingPolicy, this.valueParametersHandler, this.textFormat, this.excludedAnnotationClasses, this.includePropertyConstant, this.includeSynthesizedParameterNames, this.withoutFunctionParameterNames, this.withoutTypeParameters, this.receiverAfterName, this.renderClassObjectName, this.withoutSuperTypes, this.typeNormalizer);
        if (descriptorRendererImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/renderer/DescriptorRendererBuilder", "build"));
        }
        return descriptorRendererImpl;
    }
}

