/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetBreakExpression;
import org.jetbrains.jet.lang.psi.JetContinueExpression;
import org.jetbrains.jet.lang.psi.JetDoWhileExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetIsExpression;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetThrowExpression;
import org.jetbrains.jet.lang.psi.JetTryExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.psi.JetWhileExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.bindingContextUtil.BindingContextUtilPackage;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.expressions.BasicExpressionTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.ClosureExpressionsTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.ControlStructureTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingComponents;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingFacade;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingVisitorForStatements;
import org.jetbrains.jet.lang.types.expressions.PatternMatchingTypingVisitor;
import org.jetbrains.jet.util.ReenteringLazyValueComputationException;

public class ExpressionTypingVisitorDispatcher
extends JetVisitor<JetTypeInfo, ExpressionTypingContext>
implements ExpressionTypingInternals {
    private final ExpressionTypingComponents components;
    private final BasicExpressionTypingVisitor basic;
    private final ExpressionTypingVisitorForStatements statements;
    private final ClosureExpressionsTypingVisitor closures;
    private final ControlStructureTypingVisitor controlStructures;
    private final PatternMatchingTypingVisitor patterns;

    @NotNull
    public static ExpressionTypingFacade create(@NotNull ExpressionTypingComponents components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "create"));
        }
        ExpressionTypingVisitorDispatcher expressionTypingVisitorDispatcher = new ExpressionTypingVisitorDispatcher(components, null);
        if (expressionTypingVisitorDispatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "create"));
        }
        return expressionTypingVisitorDispatcher;
    }

    @NotNull
    public static ExpressionTypingInternals createForBlock(@NotNull ExpressionTypingComponents components, @NotNull WritableScope writableScope) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "createForBlock"));
        }
        if (writableScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writableScope", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "createForBlock"));
        }
        ExpressionTypingVisitorDispatcher expressionTypingVisitorDispatcher = new ExpressionTypingVisitorDispatcher(components, writableScope);
        if (expressionTypingVisitorDispatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "createForBlock"));
        }
        return expressionTypingVisitorDispatcher;
    }

    private ExpressionTypingVisitorDispatcher(@NotNull ExpressionTypingComponents components, WritableScope writableScope) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "<init>"));
        }
        this.components = components;
        this.basic = new BasicExpressionTypingVisitor(this);
        this.controlStructures = new ControlStructureTypingVisitor(this);
        this.patterns = new PatternMatchingTypingVisitor(this);
        this.statements = writableScope != null ? new ExpressionTypingVisitorForStatements(this, writableScope, this.basic, this.controlStructures, this.patterns) : null;
        this.closures = new ClosureExpressionsTypingVisitor(this);
    }

    @Override
    @NotNull
    public ExpressionTypingComponents getComponents() {
        ExpressionTypingComponents expressionTypingComponents = this.components;
        if (expressionTypingComponents == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "getComponents"));
        }
        return expressionTypingComponents;
    }

    @Override
    @NotNull
    public JetTypeInfo checkInExpression(@NotNull JetElement callElement, @NotNull JetSimpleNameExpression operationSign, @NotNull ValueArgument leftArgument, @Nullable JetExpression right, @NotNull ExpressionTypingContext context2) {
        if (callElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "checkInExpression"));
        }
        if (operationSign == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationSign", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "checkInExpression"));
        }
        if (leftArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftArgument", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "checkInExpression"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "checkInExpression"));
        }
        JetTypeInfo jetTypeInfo = this.basic.checkInExpression(callElement, operationSign, leftArgument, right, context2);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "checkInExpression"));
        }
        return jetTypeInfo;
    }

    @Override
    @NotNull
    public final JetTypeInfo safeGetTypeInfo(@NotNull JetExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "safeGetTypeInfo"));
        }
        JetTypeInfo typeInfo = this.getTypeInfo(expression, context2);
        if (typeInfo.getType() != null) {
            JetTypeInfo jetTypeInfo = typeInfo;
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "safeGetTypeInfo"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo jetTypeInfo = JetTypeInfo.create(ErrorUtils.createErrorType("Type for " + expression.getText()), context2.dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "safeGetTypeInfo"));
        }
        return jetTypeInfo;
    }

    @Override
    @NotNull
    public final JetTypeInfo getTypeInfo(@NotNull JetExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
        }
        JetTypeInfo jetTypeInfo = this.getTypeInfo(expression, context2, this);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
        }
        return jetTypeInfo;
    }

    @Override
    @NotNull
    public final JetTypeInfo getTypeInfo(@NotNull JetExpression expression, ExpressionTypingContext context2, boolean isStatement) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
        }
        if (!isStatement) {
            JetTypeInfo jetTypeInfo = this.getTypeInfo(expression, context2);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
            }
            return jetTypeInfo;
        }
        if (this.statements != null) {
            JetTypeInfo jetTypeInfo = this.getTypeInfo(expression, context2, this.statements);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo jetTypeInfo = this.getTypeInfo(expression, context2, this.createStatementVisitor(context2));
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
        }
        return jetTypeInfo;
    }

    private ExpressionTypingVisitorForStatements createStatementVisitor(ExpressionTypingContext context2) {
        return new ExpressionTypingVisitorForStatements(this, ExpressionTypingUtils.newWritableScopeImpl(context2, "statement scope"), this.basic, this.controlStructures, this.patterns);
    }

    @Override
    public void checkStatementType(@NotNull JetExpression expression, ExpressionTypingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "checkStatementType"));
        }
        expression.accept(this.createStatementVisitor(context2), context2);
    }

    @NotNull
    private JetTypeInfo getTypeInfo(@NotNull JetExpression expression, ExpressionTypingContext context2, JetVisitor<JetTypeInfo, ExpressionTypingContext> visitor) {
        JetTypeInfo result2;
        block10: {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
            }
            JetTypeInfo recordedTypeInfo = BindingContextUtils.getRecordedTypeInfo(expression, context2.trace.getBindingContext());
            if (recordedTypeInfo != null) {
                JetTypeInfo jetTypeInfo = recordedTypeInfo;
                if (jetTypeInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
                }
                return jetTypeInfo;
            }
            result2 = expression.accept(visitor, context2);
            if (!context2.trace.get(BindingContext.PROCESSED, expression).booleanValue()) break block10;
            JetTypeInfo jetTypeInfo = JetTypeInfo.create(context2.trace.getBindingContext().get(BindingContext.EXPRESSION_TYPE, expression), result2.getDataFlowInfo());
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
            }
            return jetTypeInfo;
        }
        try {
            if (result2.getType() instanceof DeferredType) {
                result2 = JetTypeInfo.create(((DeferredType)result2.getType()).getDelegate(), result2.getDataFlowInfo());
            }
            if (result2.getType() != null) {
                context2.trace.record(BindingContext.EXPRESSION_TYPE, expression, result2.getType());
            }
        }
        catch (ReenteringLazyValueComputationException e) {
            context2.trace.report(Errors.TYPECHECKER_HAS_RUN_INTO_RECURSIVE_PROBLEM.on(expression));
            result2 = JetTypeInfo.create(null, context2.dataFlowInfo);
        }
        context2.trace.record(BindingContext.PROCESSED, expression);
        BindingContextUtilPackage.recordScopeAndDataFlowInfo(context2.replaceDataFlowInfo(result2.getDataFlowInfo()), expression);
        JetTypeInfo jetTypeInfo = result2;
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
        }
        return jetTypeInfo;
    }

    @Override
    public JetTypeInfo visitFunctionLiteralExpression(@NotNull JetFunctionLiteralExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitFunctionLiteralExpression"));
        }
        return expression.accept(this.closures, data2);
    }

    @Override
    public JetTypeInfo visitObjectLiteralExpression(@NotNull JetObjectLiteralExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitObjectLiteralExpression"));
        }
        return expression.accept(this.closures, data2);
    }

    @Override
    public JetTypeInfo visitThrowExpression(@NotNull JetThrowExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitThrowExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitReturnExpression(@NotNull JetReturnExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitReturnExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitContinueExpression(@NotNull JetContinueExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitContinueExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitIfExpression(@NotNull JetIfExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitIfExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitTryExpression(@NotNull JetTryExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitTryExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitForExpression(@NotNull JetForExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitForExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitWhileExpression(@NotNull JetWhileExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitWhileExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitDoWhileExpression(@NotNull JetDoWhileExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitDoWhileExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitBreakExpression(@NotNull JetBreakExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitBreakExpression"));
        }
        return expression.accept(this.controlStructures, data2);
    }

    @Override
    public JetTypeInfo visitIsExpression(@NotNull JetIsExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitIsExpression"));
        }
        return expression.accept(this.patterns, data2);
    }

    @Override
    public JetTypeInfo visitWhenExpression(@NotNull JetWhenExpression expression, ExpressionTypingContext data2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitWhenExpression"));
        }
        return expression.accept(this.patterns, data2);
    }

    @Override
    public JetTypeInfo visitJetElement(@NotNull JetElement element, ExpressionTypingContext data2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/types/expressions/ExpressionTypingVisitorDispatcher", "visitJetElement"));
        }
        return element.accept(this.basic, data2);
    }
}

