/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public class JetScopeSelectorUtil {
    public static final ScopeByNameSelector<ClassifierDescriptor> CLASSIFIER_DESCRIPTOR_SCOPE_SELECTOR = new ScopeByNameSelector<ClassifierDescriptor>(){

        @Override
        @Nullable
        public ClassifierDescriptor get(@NotNull JetScope scope, @NotNull Name name) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$1", "get"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$1", "get"));
            }
            return scope.getClassifier(name);
        }
    };
    public static final ScopeByNameSelector<PackageViewDescriptor> PACKAGE_SCOPE_SELECTOR = new ScopeByNameSelector<PackageViewDescriptor>(){

        @Override
        @Nullable
        public PackageViewDescriptor get(@NotNull JetScope scope, @NotNull Name name) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$2", "get"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$2", "get"));
            }
            return scope.getPackage(name);
        }
    };
    public static final ScopeByNameSelector<VariableDescriptor> VARIABLE_DESCRIPTOR_SCOPE_SELECTOR = new ScopeByNameSelector<VariableDescriptor>(){

        @Override
        @Nullable
        public VariableDescriptor get(@NotNull JetScope scope, @NotNull Name name) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$3", "get"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$3", "get"));
            }
            return scope.getLocalVariable(name);
        }
    };
    public static final ScopeByNameMultiSelector<FunctionDescriptor> NAMED_FUNCTION_SCOPE_SELECTOR = new ScopeByNameMultiSelector<FunctionDescriptor>(){

        @Override
        @NotNull
        public Collection<FunctionDescriptor> get(@NotNull JetScope scope, @NotNull Name name) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$4", "get"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$4", "get"));
            }
            Collection<FunctionDescriptor> collection = scope.getFunctions(name);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$4", "get"));
            }
            return collection;
        }
    };
    public static final ScopeByNameMultiSelector<VariableDescriptor> NAMED_PROPERTIES_SCOPE_SELECTOR = new ScopeByNameMultiSelector<VariableDescriptor>(){

        @Override
        @NotNull
        public Collection<VariableDescriptor> get(@NotNull JetScope scope, @NotNull Name name) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$5", "get"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$5", "get"));
            }
            Collection<VariableDescriptor> collection = scope.getProperties(name);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$5", "get"));
            }
            return collection;
        }
    };
    public static final ScopeDescriptorSelector<DeclarationDescriptor> ALL_DESCRIPTORS_SCOPE_SELECTOR = new ScopeDescriptorSelector<DeclarationDescriptor>(){

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> get(@NotNull JetScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$6", "get"));
            }
            Collection<DeclarationDescriptor> collection = scope.getAllDescriptors();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$6", "get"));
            }
            return collection;
        }
    };

    private JetScopeSelectorUtil() {
    }

    @NotNull
    public static <D extends DeclarationDescriptor> Collection<D> collect(Collection<JetScope> scopes, ScopeByNameMultiSelector<D> selector, Name name) {
        HashSet<D> descriptors = new HashSet<D>();
        for (JetScope scope : scopes) {
            descriptors.addAll(selector.get(scope, name));
        }
        HashSet<D> hashSet = descriptors;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil", "collect"));
        }
        return hashSet;
    }

    @NotNull
    public static <D extends DeclarationDescriptor> Collection<D> collect(Collection<JetScope> scopes, ScopeDescriptorSelector<D> selector) {
        HashSet<D> descriptors = new HashSet<D>();
        for (JetScope scope : scopes) {
            descriptors.addAll(selector.get(scope));
        }
        HashSet<D> hashSet = descriptors;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil", "collect"));
        }
        return hashSet;
    }

    @Nullable
    public static <D extends DeclarationDescriptor> D getFirstMatch(@NotNull JetScope[] scopes, @NotNull Name name, @NotNull ScopeByNameSelector<D> descriptorSelector) {
        if (scopes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopes", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil", "getFirstMatch"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil", "getFirstMatch"));
        }
        if (descriptorSelector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorSelector", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil", "getFirstMatch"));
        }
        for (JetScope scope : scopes) {
            D descriptor = descriptorSelector.get(scope, name);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    @NotNull
    public static <D extends DeclarationDescriptor> Set<D> getFromAllScopes(@NotNull JetScope[] scopes, @NotNull Name name, @NotNull ScopeByNameMultiSelector<D> descriptorsSelector) {
        if (scopes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopes", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil", "getFromAllScopes"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil", "getFromAllScopes"));
        }
        if (descriptorsSelector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorsSelector", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil", "getFromAllScopes"));
        }
        if (scopes.length == 0) {
            Set set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil", "getFromAllScopes"));
            }
            return set;
        }
        LinkedHashSet<D> descriptors = new LinkedHashSet<D>();
        for (JetScope jetScope : scopes) {
            descriptors.addAll(descriptorsSelector.get(jetScope, name));
        }
        LinkedHashSet<D> linkedHashSet = descriptors;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil", "getFromAllScopes"));
        }
        return linkedHashSet;
    }

    public static interface ScopeDescriptorSelector<D extends DeclarationDescriptor> {
        @NotNull
        public Collection<D> get(JetScope var1);
    }

    public static interface ScopeByNameMultiSelector<D extends DeclarationDescriptor> {
        @NotNull
        public Collection<D> get(JetScope var1, Name var2);
    }

    public static interface ScopeByNameSelector<D extends DeclarationDescriptor> {
        @Nullable
        public D get(@NotNull JetScope var1, @NotNull Name var2);
    }
}

