/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.data;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.resolve.lazy.data.JetClassLikeInfo;
import org.jetbrains.jet.lang.resolve.name.FqName;

public abstract class JetClassOrObjectInfo<E extends JetClassOrObject>
implements JetClassLikeInfo {
    protected final E element;

    protected JetClassOrObjectInfo(@NotNull E element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/resolve/lazy/data/JetClassOrObjectInfo", "<init>"));
        }
        this.element = element;
    }

    @Override
    public JetClassOrObject getCorrespondingClassOrObject() {
        return this.element;
    }

    @Override
    @Nullable
    public JetModifierList getModifierList() {
        return this.element.getModifierList();
    }

    @Override
    @NotNull
    public List<JetDeclaration> getDeclarations() {
        List<JetDeclaration> list = this.element.getDeclarations();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/data/JetClassOrObjectInfo", "getDeclarations"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<JetClassObject> getClassObjects() {
        JetClassBody body = this.element.getBody();
        if (body == null) {
            List<JetClassObject> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/data/JetClassOrObjectInfo", "getClassObjects"));
            }
            return list;
        }
        List<JetClassObject> list = body.getAllClassObjects();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/data/JetClassOrObjectInfo", "getClassObjects"));
        }
        return list;
    }

    @Override
    @NotNull
    public PsiElement getScopeAnchor() {
        E e = this.element;
        if (e == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/data/JetClassOrObjectInfo", "getScopeAnchor"));
        }
        return e;
    }

    @Override
    @NotNull
    public FqName getContainingPackageFqName() {
        PsiFile file = this.element.getContainingFile();
        if (file instanceof JetFile) {
            JetFile jetFile = (JetFile)file;
            FqName fqName2 = jetFile.getPackageFqName();
            if (fqName2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/data/JetClassOrObjectInfo", "getContainingPackageFqName"));
            }
            return fqName2;
        }
        throw new IllegalArgumentException("Not in a JetFile: " + this.element);
    }

    public String toString() {
        return "info for " + this.element.getText();
    }
}

