/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Function0;
import kotlin.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetImportsFactory;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetStubbedPsiUtil;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.JetModuleUtil;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.lazy.LazyImportScope;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.scopes.ChainedScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.storage.MemoizedFunctionToNotNull;
import org.jetbrains.jet.storage.NotNullLazyValue;

public class ScopeProvider {
    private final ResolveSession resolveSession;
    private final MemoizedFunctionToNotNull<JetFile, LazyImportScope> explicitImportScopes;
    private final NotNullLazyValue<JetScope> defaultImportsScope;

    public ScopeProvider(@NotNull ResolveSession resolveSession) {
        if (resolveSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveSession", "org/jetbrains/jet/lang/resolve/lazy/ScopeProvider", "<init>"));
        }
        this.resolveSession = resolveSession;
        this.explicitImportScopes = resolveSession.getStorageManager().createMemoizedFunction(new Function1<JetFile, LazyImportScope>(){

            @Override
            public LazyImportScope invoke(@NotNull JetFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/lazy/ScopeProvider$1", "invoke"));
                }
                return ScopeProvider.this.createExplicitImportScope(file);
            }
        });
        this.defaultImportsScope = resolveSession.getStorageManager().createLazyValue(new Function0<JetScope>(){

            @Override
            public JetScope invoke() {
                return ScopeProvider.this.createScopeWithDefaultImports();
            }
        });
    }

    private LazyImportScope createExplicitImportScope(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/lazy/ScopeProvider", "createExplicitImportScope"));
        }
        return LazyImportScope.createImportScopeForFile(this.resolveSession, this.getFilePackageDescriptor(file), file, this.resolveSession.getTrace(), "Lazy Imports Scope for file " + file.getName());
    }

    @NotNull
    public JetScope getFileScope(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/lazy/ScopeProvider", "getFileScope"));
        }
        ChainedScope chainedScope = new ChainedScope(this.resolveSession.getPackageFragment(file.getPackageFqName()), "File scope: " + file.getName(), this.getFilePackageDescriptor(file).getMemberScope(), JetModuleUtil.getSubpackagesOfRootScope(this.resolveSession.getModuleDescriptor()), (JetScope)this.explicitImportScopes.invoke(file), (JetScope)this.defaultImportsScope.invoke());
        if (chainedScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ScopeProvider", "getFileScope"));
        }
        return chainedScope;
    }

    @NotNull
    public LazyImportScope getExplicitImportsScopeForFile(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/lazy/ScopeProvider", "getExplicitImportsScopeForFile"));
        }
        LazyImportScope lazyImportScope = (LazyImportScope)this.explicitImportScopes.invoke(file);
        if (lazyImportScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ScopeProvider", "getExplicitImportsScopeForFile"));
        }
        return lazyImportScope;
    }

    private JetScope createScopeWithDefaultImports() {
        PackageViewDescriptor rootPackage = this.resolveSession.getModuleDescriptor().getPackage(FqName.ROOT);
        if (rootPackage == null) {
            throw new IllegalStateException("Root package not found");
        }
        JetImportsFactory importsFactory = this.resolveSession.getJetImportsFactory();
        List<ImportPath> defaultImports = this.resolveSession.getModuleDescriptor().getDefaultImports();
        Collection<JetImportDirective> defaultImportDirectives = importsFactory.createImportDirectives(defaultImports);
        return new LazyImportScope(this.resolveSession, rootPackage, Lists.reverse(Lists.newArrayList(defaultImportDirectives)), TemporaryBindingTrace.create(this.resolveSession.getTrace(), "Transient trace for default imports lazy resolve"), "Lazy default imports scope", false);
    }

    @NotNull
    private PackageViewDescriptor getFilePackageDescriptor(JetFile file) {
        FqName fqName2 = file.getPackageFqName();
        PackageViewDescriptor packageDescriptor = this.resolveSession.getModuleDescriptor().getPackage(fqName2);
        if (packageDescriptor == null) {
            throw new IllegalStateException("Package not found: " + fqName2 + " maybe the file is not in scope of this resolve session: " + file.getName());
        }
        PackageViewDescriptor packageViewDescriptor = packageDescriptor;
        if (packageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ScopeProvider", "getFilePackageDescriptor"));
        }
        return packageViewDescriptor;
    }

    @NotNull
    public JetScope getResolutionScopeForDeclaration(@NotNull PsiElement elementOfDeclaration) {
        if (elementOfDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementOfDeclaration", "org/jetbrains/jet/lang/resolve/lazy/ScopeProvider", "getResolutionScopeForDeclaration"));
        }
        JetDeclaration jetDeclaration = JetStubbedPsiUtil.getPsiOrStubParent(elementOfDeclaration, JetDeclaration.class, false);
        assert (!(elementOfDeclaration instanceof JetDeclaration) || jetDeclaration == elementOfDeclaration) : "For JetDeclaration element getParentOfType() should return itself.";
        assert (jetDeclaration != null) : "Should be contained inside declaration.";
        JetDeclaration parentDeclaration = JetStubbedPsiUtil.getContainingDeclaration(jetDeclaration);
        if (jetDeclaration instanceof JetPropertyAccessor) {
            parentDeclaration = JetStubbedPsiUtil.getContainingDeclaration(parentDeclaration, JetDeclaration.class);
        }
        if (parentDeclaration == null) {
            JetScope jetScope = this.getFileScope((JetFile)elementOfDeclaration.getContainingFile());
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ScopeProvider", "getResolutionScopeForDeclaration"));
            }
            return jetScope;
        }
        if (parentDeclaration instanceof JetClassOrObject) {
            JetClassOrObject classOrObject = (JetClassOrObject)parentDeclaration;
            LazyClassDescriptor classDescriptor = (LazyClassDescriptor)this.resolveSession.getClassDescriptor(classOrObject);
            if (jetDeclaration instanceof JetClassInitializer || jetDeclaration instanceof JetProperty) {
                JetScope jetScope = classDescriptor.getScopeForInitializerResolution();
                if (jetScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ScopeProvider", "getResolutionScopeForDeclaration"));
                }
                return jetScope;
            }
            JetScope jetScope = classDescriptor.getScopeForMemberDeclarationResolution();
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ScopeProvider", "getResolutionScopeForDeclaration"));
            }
            return jetScope;
        }
        if (parentDeclaration instanceof JetClassObject) {
            assert (jetDeclaration instanceof JetObjectDeclaration) : "Should be situation for getting scope for object in class [object {...}]";
            JetClassObject classObject = (JetClassObject)parentDeclaration;
            LazyClassDescriptor classObjectDescriptor = (LazyClassDescriptor)this.resolveSession.getClassObjectDescriptor(classObject).getContainingDeclaration();
            JetScope jetScope = classObjectDescriptor.getScopeForMemberDeclarationResolution();
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/ScopeProvider", "getResolutionScopeForDeclaration"));
            }
            return jetScope;
        }
        throw new IllegalStateException("Don't call this method for local declarations: " + jetDeclaration + " " + jetDeclaration.getText());
    }
}

