/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.ConstantsPackage;
import org.jetbrains.jet.lang.resolve.java.resolver.ErrorReporter;
import org.jetbrains.jet.lang.resolve.kotlin.AnnotationDescriptorLoader;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.name.ClassId;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.storage.MemoizedFunctionToNotNull;
import org.jetbrains.jet.storage.StorageManager;

public class DescriptorLoadersStorage {
    private ErrorReporter errorReporter;
    private ModuleDescriptor module;
    private final MemoizedFunctionToNotNull<KotlinJvmBinaryClass, Storage> storage;

    public DescriptorLoadersStorage(@NotNull StorageManager storageManager) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage", "<init>"));
        }
        this.storage = storageManager.createMemoizedFunction(new Function1<KotlinJvmBinaryClass, Storage>(){

            @Override
            @NotNull
            public Storage invoke(@NotNull KotlinJvmBinaryClass kotlinClass) {
                Storage storage2;
                if (kotlinClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage$1", "invoke"));
                }
                try {
                    storage2 = DescriptorLoadersStorage.this.loadAnnotationsAndInitializers(kotlinClass);
                }
                catch (IOException e) {
                    DescriptorLoadersStorage.this.errorReporter.reportLoadingError("Error loading member information from Kotlin class: " + kotlinClass, e);
                    Storage storage3 = Storage.EMPTY;
                    if (storage3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage$1", "invoke"));
                    }
                    return storage3;
                }
                if (storage2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage$1", "invoke"));
                }
                return storage2;
            }
        });
    }

    @Inject
    public void setModule(ModuleDescriptor module) {
        this.module = module;
    }

    @Inject
    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @NotNull
    protected MemoizedFunctionToNotNull<KotlinJvmBinaryClass, Storage> getStorage() {
        MemoizedFunctionToNotNull<KotlinJvmBinaryClass, Storage> memoizedFunctionToNotNull = this.storage;
        if (memoizedFunctionToNotNull == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage", "getStorage"));
        }
        return memoizedFunctionToNotNull;
    }

    @NotNull
    private Storage loadAnnotationsAndInitializers(@NotNull KotlinJvmBinaryClass kotlinClass) throws IOException {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage", "loadAnnotationsAndInitializers"));
        }
        final HashMap<MemberSignature, List<AnnotationDescriptor>> memberAnnotations = new HashMap<MemberSignature, List<AnnotationDescriptor>>();
        final HashMap propertyConstants = new HashMap();
        kotlinClass.visitMembers(new KotlinJvmBinaryClass.MemberVisitor(){

            @Override
            @Nullable
            public KotlinJvmBinaryClass.MethodAnnotationVisitor visitMethod(@NotNull Name name, @NotNull String desc) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage$2", "visitMethod"));
                }
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage$2", "visitMethod"));
                }
                return new AnnotationVisitorForMethod(MemberSignature.fromMethodNameAndDesc(name.asString() + desc));
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            @Nullable
            public KotlinJvmBinaryClass.AnnotationVisitor visitField(@NotNull Name name, @NotNull String desc, @Nullable Object initializer) {
                Object normalizedValue;
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage$2", "visitField"));
                }
                if (desc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage$2", "visitField"));
                }
                MemberSignature signature = MemberSignature.fromFieldNameAndDesc(name, desc);
                if (initializer == null) return new MemberAnnotationVisitor(signature);
                if ("ZBCS".contains(desc)) {
                    int intValue = (Integer)initializer;
                    if ("Z".equals(desc)) {
                        normalizedValue = intValue != 0;
                    } else if ("B".equals(desc)) {
                        normalizedValue = (byte)intValue;
                    } else if ("C".equals(desc)) {
                        normalizedValue = Character.valueOf((char)intValue);
                    } else {
                        if (!"S".equals(desc)) throw new AssertionError((Object)desc);
                        normalizedValue = (short)intValue;
                    }
                } else {
                    normalizedValue = initializer;
                }
                propertyConstants.put(signature, ConstantsPackage.createCompileTimeConstant(normalizedValue, true, true, true, null));
                return new MemberAnnotationVisitor(signature);
            }

            class MemberAnnotationVisitor
            implements KotlinJvmBinaryClass.AnnotationVisitor {
                private final List<AnnotationDescriptor> result;
                protected final MemberSignature signature;

                public MemberAnnotationVisitor(@NotNull MemberSignature signature) {
                    if (signature == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage$2$MemberAnnotationVisitor", "<init>"));
                    }
                    this.result = new ArrayList<AnnotationDescriptor>();
                    this.signature = signature;
                }

                @Override
                @Nullable
                public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull ClassId classId) {
                    if (classId == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage$2$MemberAnnotationVisitor", "visitAnnotation"));
                    }
                    return AnnotationDescriptorLoader.resolveAnnotation(classId, this.result, DescriptorLoadersStorage.this.module);
                }

                @Override
                public void visitEnd() {
                    if (!this.result.isEmpty()) {
                        memberAnnotations.put(this.signature, this.result);
                    }
                }
            }

            class AnnotationVisitorForMethod
            extends MemberAnnotationVisitor
            implements KotlinJvmBinaryClass.MethodAnnotationVisitor {
                public AnnotationVisitorForMethod(@NotNull MemberSignature signature) {
                    if (signature == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage$2$AnnotationVisitorForMethod", "<init>"));
                    }
                    super(signature);
                }

                @Override
                @Nullable
                public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitParameterAnnotation(int index, @NotNull ClassId classId) {
                    if (classId == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage$2$AnnotationVisitorForMethod", "visitParameterAnnotation"));
                    }
                    MemberSignature paramSignature = MemberSignature.fromMethodSignatureAndParameterIndex(this.signature, index);
                    ArrayList<AnnotationDescriptor> result2 = (ArrayList<AnnotationDescriptor>)memberAnnotations.get(paramSignature);
                    if (result2 == null) {
                        result2 = new ArrayList<AnnotationDescriptor>();
                        memberAnnotations.put(paramSignature, result2);
                    }
                    return AnnotationDescriptorLoader.resolveAnnotation(classId, result2, DescriptorLoadersStorage.this.module);
                }
            }
        });
        Storage storage2 = new Storage(memberAnnotations, propertyConstants);
        if (storage2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage", "loadAnnotationsAndInitializers"));
        }
        return storage2;
    }

    protected static class Storage {
        private final Map<MemberSignature, List<AnnotationDescriptor>> memberAnnotations;
        private final Map<MemberSignature, CompileTimeConstant<?>> propertyConstants;
        public static final Storage EMPTY = new Storage(Collections.<MemberSignature, List<AnnotationDescriptor>>emptyMap(), Collections.<MemberSignature, CompileTimeConstant<?>>emptyMap());

        public Storage(@NotNull Map<MemberSignature, List<AnnotationDescriptor>> annotations, @NotNull Map<MemberSignature, CompileTimeConstant<?>> constants) {
            if (annotations == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage$Storage", "<init>"));
            }
            if (constants == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constants", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage$Storage", "<init>"));
            }
            this.memberAnnotations = annotations;
            this.propertyConstants = constants;
        }

        public Map<MemberSignature, List<AnnotationDescriptor>> getMemberAnnotations() {
            return this.memberAnnotations;
        }

        public Map<MemberSignature, CompileTimeConstant<?>> getPropertyConstants() {
            return this.propertyConstants;
        }
    }

    public static final class MemberSignature {
        private final String signature;

        private MemberSignature(@NotNull String signature) {
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage$MemberSignature", "<init>"));
            }
            this.signature = signature;
        }

        @NotNull
        public static MemberSignature fromMethodNameAndDesc(@NotNull String nameAndDesc) {
            if (nameAndDesc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameAndDesc", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage$MemberSignature", "fromMethodNameAndDesc"));
            }
            MemberSignature memberSignature = new MemberSignature(nameAndDesc);
            if (memberSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage$MemberSignature", "fromMethodNameAndDesc"));
            }
            return memberSignature;
        }

        @NotNull
        public static MemberSignature fromFieldNameAndDesc(@NotNull Name name, @NotNull String desc) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage$MemberSignature", "fromFieldNameAndDesc"));
            }
            if (desc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage$MemberSignature", "fromFieldNameAndDesc"));
            }
            MemberSignature memberSignature = new MemberSignature(name.asString() + "#" + desc);
            if (memberSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage$MemberSignature", "fromFieldNameAndDesc"));
            }
            return memberSignature;
        }

        @NotNull
        public static MemberSignature fromMethodSignatureAndParameterIndex(@NotNull MemberSignature signature, int index) {
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage$MemberSignature", "fromMethodSignatureAndParameterIndex"));
            }
            MemberSignature memberSignature = new MemberSignature(signature.signature + "@" + index);
            if (memberSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DescriptorLoadersStorage$MemberSignature", "fromMethodSignatureAndParameterIndex"));
            }
            return memberSignature;
        }

        public int hashCode() {
            return this.signature.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof MemberSignature && this.signature.equals(((MemberSignature)o).signature);
        }

        public String toString() {
            return this.signature;
        }
    }
}

