/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Maps;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentProvider;
import org.jetbrains.jet.lang.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class MutablePackageFragmentProvider
implements PackageFragmentProvider {
    private final ModuleDescriptor module;
    private final Map<FqName, MutablePackageFragmentDescriptor> fqNameToPackage;
    private final MultiMap<FqName, FqName> subPackages;

    public MutablePackageFragmentProvider(@NotNull ModuleDescriptor module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/lang/resolve/MutablePackageFragmentProvider", "<init>"));
        }
        this.fqNameToPackage = Maps.newHashMap();
        this.subPackages = MultiMap.create();
        this.module = module;
        this.fqNameToPackage.put(FqName.ROOT, new MutablePackageFragmentDescriptor(module, FqName.ROOT));
    }

    @Override
    @NotNull
    public List<PackageFragmentDescriptor> getPackageFragments(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/MutablePackageFragmentProvider", "getPackageFragments"));
        }
        List<PackageFragmentDescriptor> list = ContainerUtil.createMaybeSingletonList(this.fqNameToPackage.get(fqName2));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/MutablePackageFragmentProvider", "getPackageFragments"));
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<FqName> getSubPackagesOf(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/MutablePackageFragmentProvider", "getSubPackagesOf"));
        }
        Collection<FqName> collection = this.subPackages.get(fqName2);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/MutablePackageFragmentProvider", "getSubPackagesOf"));
        }
        return collection;
    }

    @NotNull
    public MutablePackageFragmentDescriptor getOrCreateFragment(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/MutablePackageFragmentProvider", "getOrCreateFragment"));
        }
        if (!this.fqNameToPackage.containsKey(fqName2)) {
            FqName parent = fqName2.parent();
            this.getOrCreateFragment(parent);
            this.fqNameToPackage.put(fqName2, new MutablePackageFragmentDescriptor(this.module, fqName2));
            this.subPackages.putValue(parent, fqName2);
        }
        MutablePackageFragmentDescriptor mutablePackageFragmentDescriptor = this.fqNameToPackage.get(fqName2);
        if (mutablePackageFragmentDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/MutablePackageFragmentProvider", "getOrCreateFragment"));
        }
        return mutablePackageFragmentDescriptor;
    }

    @NotNull
    public ModuleDescriptor getModule() {
        ModuleDescriptor moduleDescriptor = this.module;
        if (moduleDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/MutablePackageFragmentProvider", "getModule"));
        }
        return moduleDescriptor;
    }

    @NotNull
    public Collection<MutablePackageFragmentDescriptor> getAllFragments() {
        Collection<MutablePackageFragmentDescriptor> collection = this.fqNameToPackage.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/MutablePackageFragmentProvider", "getAllFragments"));
        }
        return collection;
    }
}

