/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorToSourceUtils;

public class LibrarySourceHacks {
    public static final Key<Boolean> SKIP_TOP_LEVEL_MEMBERS = Key.create("SKIP_TOP_LEVEL_MEMBERS");

    private LibrarySourceHacks() {
    }

    public static <D extends CallableDescriptor> List<D> filterOutMembersFromLibrarySource(Collection<D> members) {
        ArrayList<CallableDescriptor> filteredMembers = Lists.newArrayList();
        for (CallableDescriptor member : members) {
            if (LibrarySourceHacks.shouldSkip(member)) continue;
            filteredMembers.add(member);
        }
        return filteredMembers;
    }

    private static boolean shouldSkip(CallableDescriptor member) {
        CallableDescriptor original = member.getOriginal();
        if (!(original instanceof CallableMemberDescriptor)) {
            return false;
        }
        if (!(original.getContainingDeclaration() instanceof PackageFragmentDescriptor)) {
            return false;
        }
        PsiElement declaration = DescriptorToSourceUtils.callableDescriptorToDeclaration((CallableMemberDescriptor)original);
        if (declaration == null) {
            return false;
        }
        PsiFile file = declaration.getContainingFile();
        return file != null && Boolean.TRUE.equals(file.getUserData(SKIP_TOP_LEVEL_MEMBERS));
    }
}

