/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.MemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.name.SpecialNames;
import org.jetbrains.jet.lang.resolve.scopes.FilteringScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.LazyType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class DescriptorUtils {
    public static final Name ENUM_VALUES = Name.identifier("values");
    public static final Name ENUM_VALUE_OF = Name.identifier("valueOf");

    private DescriptorUtils() {
    }

    @Nullable
    public static ReceiverParameterDescriptor getExpectedThisObjectIfNeeded(@NotNull DeclarationDescriptor containingDeclaration) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getExpectedThisObjectIfNeeded"));
        }
        if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            return classDescriptor.getThisAsReceiverParameter();
        }
        if (containingDeclaration instanceof ScriptDescriptor) {
            ScriptDescriptor scriptDescriptor = (ScriptDescriptor)containingDeclaration;
            return scriptDescriptor.getThisAsReceiverParameter();
        }
        return ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER;
    }

    public static boolean isLocal(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isLocal"));
        }
        DeclarationDescriptor current = descriptor;
        while (current instanceof MemberDescriptor) {
            if (DescriptorUtils.isAnonymousObject(current) || ((DeclarationDescriptorWithVisibility)current).getVisibility() == Visibilities.LOCAL) {
                return true;
            }
            current = current.getContainingDeclaration();
        }
        return false;
    }

    @NotNull
    public static FqNameUnsafe getFqName(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getFqName"));
        }
        FqName safe = DescriptorUtils.getFqNameSafeIfPossible(descriptor);
        FqNameUnsafe fqNameUnsafe = safe != null ? safe.toUnsafe() : DescriptorUtils.getFqNameUnsafe(descriptor);
        if (fqNameUnsafe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getFqName"));
        }
        return fqNameUnsafe;
    }

    @NotNull
    public static FqName getFqNameSafe(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getFqNameSafe"));
        }
        FqName safe = DescriptorUtils.getFqNameSafeIfPossible(descriptor);
        FqName fqName2 = safe != null ? safe : DescriptorUtils.getFqNameUnsafe(descriptor).toSafe();
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getFqNameSafe"));
        }
        return fqName2;
    }

    @Nullable
    private static FqName getFqNameSafeIfPossible(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getFqNameSafeIfPossible"));
        }
        if (descriptor instanceof ModuleDescriptor || ErrorUtils.isError(descriptor)) {
            return FqName.ROOT;
        }
        if (descriptor instanceof PackageViewDescriptor) {
            return ((PackageViewDescriptor)descriptor).getFqName();
        }
        if (descriptor instanceof PackageFragmentDescriptor) {
            return ((PackageFragmentDescriptor)descriptor).getFqName();
        }
        return null;
    }

    @NotNull
    private static FqNameUnsafe getFqNameUnsafe(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getFqNameUnsafe"));
        }
        DeclarationDescriptor containingDeclaration = DescriptorUtils.getContainingDeclarationSkippingClassObjects(descriptor);
        assert (containingDeclaration != null) : "Not package/module descriptor doesn't have containing declaration: " + descriptor;
        FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(containingDeclaration).child(descriptor.getName());
        if (fqNameUnsafe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getFqNameUnsafe"));
        }
        return fqNameUnsafe;
    }

    @Nullable
    private static DeclarationDescriptor getContainingDeclarationSkippingClassObjects(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getContainingDeclarationSkippingClassObjects"));
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        return DescriptorUtils.isClassObject(containingDeclaration) ? containingDeclaration.getContainingDeclaration() : containingDeclaration;
    }

    @NotNull
    public static FqName getFqNameFromTopLevelClass(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getFqNameFromTopLevelClass"));
        }
        DeclarationDescriptor containingDeclaration = DescriptorUtils.getContainingDeclarationSkippingClassObjects(descriptor);
        Name name = descriptor.getName();
        if (!(containingDeclaration instanceof ClassDescriptor)) {
            FqName fqName2 = FqName.topLevel(name);
            if (fqName2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getFqNameFromTopLevelClass"));
            }
            return fqName2;
        }
        FqName fqName3 = DescriptorUtils.getFqNameFromTopLevelClass(containingDeclaration).child(name);
        if (fqName3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getFqNameFromTopLevelClass"));
        }
        return fqName3;
    }

    public static boolean isTopLevelDeclaration(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isTopLevelDeclaration"));
        }
        return descriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor;
    }

    public static boolean isStaticDeclaration(@NotNull CallableDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isStaticDeclaration"));
        }
        if (descriptor instanceof ConstructorDescriptor) {
            return false;
        }
        DeclarationDescriptor container = descriptor.getContainingDeclaration();
        return container instanceof PackageFragmentDescriptor || container instanceof ClassDescriptor && descriptor.getExpectedThisObject() == null;
    }

    public static boolean areInSameModule(@NotNull DeclarationDescriptor first, @NotNull DeclarationDescriptor second) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "areInSameModule"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "areInSameModule"));
        }
        return DescriptorUtils.getContainingModule(first).equals(DescriptorUtils.getContainingModule(second));
    }

    @Nullable
    public static <D extends DeclarationDescriptor> D getParentOfType(@Nullable DeclarationDescriptor descriptor, @NotNull Class<D> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getParentOfType"));
        }
        return DescriptorUtils.getParentOfType(descriptor, aClass, true);
    }

    @Nullable
    public static <D extends DeclarationDescriptor> D getParentOfType(@Nullable DeclarationDescriptor descriptor, @NotNull Class<D> aClass, boolean strict) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getParentOfType"));
        }
        if (descriptor == null) {
            return null;
        }
        if (strict) {
            descriptor = descriptor.getContainingDeclaration();
        }
        while (descriptor != null) {
            if (aClass.isInstance(descriptor)) {
                return (D)descriptor;
            }
            descriptor = descriptor.getContainingDeclaration();
        }
        return null;
    }

    @NotNull
    public static ModuleDescriptor getContainingModule(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getContainingModule"));
        }
        if (descriptor instanceof PackageViewDescriptor) {
            ModuleDescriptor moduleDescriptor = ((PackageViewDescriptor)descriptor).getModule();
            if (moduleDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getContainingModule"));
            }
            return moduleDescriptor;
        }
        ModuleDescriptor module = DescriptorUtils.getParentOfType(descriptor, ModuleDescriptor.class, false);
        assert (module != null) : "Descriptor without a containing module: " + descriptor;
        ModuleDescriptor moduleDescriptor = module;
        if (moduleDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getContainingModule"));
        }
        return moduleDescriptor;
    }

    public static boolean isAncestor(@Nullable DeclarationDescriptor ancestor, @NotNull DeclarationDescriptor declarationDescriptor, boolean strict) {
        DeclarationDescriptor descriptor;
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isAncestor"));
        }
        if (ancestor == null) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor2 = descriptor = strict ? declarationDescriptor.getContainingDeclaration() : declarationDescriptor;
        while (descriptor != null) {
            if (ancestor == descriptor) {
                return true;
            }
            descriptor = descriptor.getContainingDeclaration();
        }
        return false;
    }

    public static boolean isSubclass(@NotNull ClassDescriptor subClass, @NotNull ClassDescriptor superClass) {
        if (subClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subClass", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isSubclass"));
        }
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isSubclass"));
        }
        return DescriptorUtils.isSubtypeOfClass(subClass.getDefaultType(), superClass.getOriginal());
    }

    private static boolean isSubtypeOfClass(@NotNull JetType type, @NotNull DeclarationDescriptor superClass) {
        DeclarationDescriptor originalDescriptor;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isSubtypeOfClass"));
        }
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isSubtypeOfClass"));
        }
        ClassifierDescriptor descriptor = type.getConstructor().getDeclarationDescriptor();
        if (descriptor != null && (originalDescriptor = descriptor.getOriginal()) instanceof ClassifierDescriptor && superClass instanceof ClassifierDescriptor && ((ClassifierDescriptor)superClass).getTypeConstructor().equals(((ClassifierDescriptor)originalDescriptor).getTypeConstructor())) {
            return true;
        }
        for (JetType superType : type.getConstructor().getSupertypes()) {
            if (!DescriptorUtils.isSubtypeOfClass(superType, superClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFunctionLiteral(@NotNull FunctionDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isFunctionLiteral"));
        }
        return descriptor instanceof AnonymousFunctionDescriptor;
    }

    public static boolean isClassObject(@Nullable DeclarationDescriptor descriptor) {
        return DescriptorUtils.isKindOf(descriptor, ClassKind.CLASS_OBJECT);
    }

    public static boolean isAnonymousObject(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isAnonymousObject"));
        }
        return DescriptorUtils.isClass(descriptor) && descriptor.getName().equals(SpecialNames.NO_NAME_PROVIDED);
    }

    public static boolean isObject(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isObject"));
        }
        return DescriptorUtils.isKindOf(descriptor, ClassKind.OBJECT);
    }

    public static boolean isEnumEntry(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isEnumEntry"));
        }
        return DescriptorUtils.isKindOf(descriptor, ClassKind.ENUM_ENTRY);
    }

    public static boolean isSingleton(@Nullable DeclarationDescriptor classifier2) {
        if (classifier2 instanceof ClassDescriptor) {
            ClassDescriptor clazz = (ClassDescriptor)classifier2;
            return clazz.getKind().isSingleton();
        }
        return false;
    }

    public static boolean isEnumClass(@Nullable DeclarationDescriptor descriptor) {
        return DescriptorUtils.isKindOf(descriptor, ClassKind.ENUM_CLASS);
    }

    public static boolean isAnnotationClass(@Nullable DeclarationDescriptor descriptor) {
        return DescriptorUtils.isKindOf(descriptor, ClassKind.ANNOTATION_CLASS);
    }

    public static boolean isTrait(@Nullable DeclarationDescriptor descriptor) {
        return DescriptorUtils.isKindOf(descriptor, ClassKind.TRAIT);
    }

    public static boolean isClass(@Nullable DeclarationDescriptor descriptor) {
        return DescriptorUtils.isKindOf(descriptor, ClassKind.CLASS);
    }

    public static boolean containerKindIs(@NotNull DeclarationDescriptor descriptor, @NotNull ClassKind kind) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "containerKindIs"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "containerKindIs"));
        }
        DeclarationDescriptor parentDeclaration = descriptor.getContainingDeclaration();
        return parentDeclaration != null && DescriptorUtils.isKindOf(parentDeclaration, kind);
    }

    public static boolean isKindOf(@Nullable DeclarationDescriptor descriptor, @NotNull ClassKind classKind) {
        if (classKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classKind", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isKindOf"));
        }
        return descriptor instanceof ClassDescriptor && ((ClassDescriptor)descriptor).getKind() == classKind;
    }

    @NotNull
    public static List<ClassDescriptor> getSuperclassDescriptors(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getSuperclassDescriptors"));
        }
        Collection<JetType> superclassTypes = classDescriptor.getTypeConstructor().getSupertypes();
        ArrayList<ClassDescriptor> superClassDescriptors = new ArrayList<ClassDescriptor>();
        for (JetType type : superclassTypes) {
            ClassDescriptor result2 = DescriptorUtils.getClassDescriptorForType(type);
            if (DescriptorUtils.isAny(result2)) continue;
            superClassDescriptors.add(result2);
        }
        ArrayList<ClassDescriptor> arrayList = superClassDescriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getSuperclassDescriptors"));
        }
        return arrayList;
    }

    @NotNull
    public static ClassDescriptor getClassDescriptorForType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getClassDescriptorForType"));
        }
        ClassDescriptor classDescriptor = DescriptorUtils.getClassDescriptorForTypeConstructor(type.getConstructor());
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getClassDescriptorForType"));
        }
        return classDescriptor;
    }

    @NotNull
    public static ClassDescriptor getClassDescriptorForTypeConstructor(@NotNull TypeConstructor typeConstructor) {
        if (typeConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeConstructor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getClassDescriptorForTypeConstructor"));
        }
        ClassifierDescriptor descriptor = typeConstructor.getDeclarationDescriptor();
        assert (descriptor instanceof ClassDescriptor) : "Classifier descriptor of a type should be of type ClassDescriptor: " + typeConstructor;
        ClassDescriptor classDescriptor = (ClassDescriptor)descriptor;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getClassDescriptorForTypeConstructor"));
        }
        return classDescriptor;
    }

    public static boolean isAny(@NotNull DeclarationDescriptor superClassDescriptor) {
        if (superClassDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClassDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isAny"));
        }
        return superClassDescriptor.equals(KotlinBuiltIns.getInstance().getAny());
    }

    public static boolean isSyntheticClassObject(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isSyntheticClassObject"));
        }
        return DescriptorUtils.isClassObject(descriptor) && DescriptorUtils.isSingleton(descriptor.getContainingDeclaration());
    }

    @NotNull
    public static Visibility getDefaultConstructorVisibility(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getDefaultConstructorVisibility"));
        }
        ClassKind classKind = classDescriptor.getKind();
        if (classKind == ClassKind.ENUM_CLASS || classKind.isSingleton()) {
            Visibility visibility = Visibilities.PRIVATE;
            if (visibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getDefaultConstructorVisibility"));
            }
            return visibility;
        }
        if (DescriptorUtils.isAnonymousObject(classDescriptor)) {
            Visibility visibility = Visibilities.INTERNAL;
            if (visibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getDefaultConstructorVisibility"));
            }
            return visibility;
        }
        assert (classKind == ClassKind.CLASS || classKind == ClassKind.TRAIT || classKind == ClassKind.ANNOTATION_CLASS);
        Visibility visibility = Visibilities.PUBLIC;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getDefaultConstructorVisibility"));
        }
        return visibility;
    }

    @NotNull
    public static Visibility getSyntheticClassObjectVisibility() {
        Visibility visibility = Visibilities.PUBLIC;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getSyntheticClassObjectVisibility"));
        }
        return visibility;
    }

    @Nullable
    public static ClassDescriptor getInnerClassByName(@NotNull ClassDescriptor classDescriptor, @NotNull String innerClassName) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getInnerClassByName"));
        }
        if (innerClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClassName", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getInnerClassByName"));
        }
        ClassifierDescriptor classifier2 = classDescriptor.getDefaultType().getMemberScope().getClassifier(Name.identifier(innerClassName));
        assert (classifier2 instanceof ClassDescriptor) : "Inner class " + innerClassName + " in " + classDescriptor + " should be instance of ClassDescriptor, but was: " + (classifier2 == null ? "null" : classifier2.getClass());
        return (ClassDescriptor)classifier2;
    }

    @Nullable
    public static JetType getReceiverParameterType(@Nullable ReceiverParameterDescriptor receiverParameterDescriptor) {
        return receiverParameterDescriptor == null ? null : receiverParameterDescriptor.getType();
    }

    public static boolean isStaticNestedClass(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isStaticNestedClass"));
        }
        DeclarationDescriptor containing = descriptor.getContainingDeclaration();
        return descriptor instanceof ClassDescriptor && containing instanceof ClassDescriptor && !((ClassDescriptor)descriptor).isInner();
    }

    @NotNull
    public static JetScope getStaticNestedClassesScope(@NotNull ClassDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getStaticNestedClassesScope"));
        }
        JetScope innerClassesScope = descriptor.getUnsubstitutedInnerClassesScope();
        FilteringScope filteringScope = new FilteringScope(innerClassesScope, new Function1<DeclarationDescriptor, Boolean>(){

            @Override
            public Boolean invoke(DeclarationDescriptor descriptor) {
                return descriptor instanceof ClassDescriptor && !((ClassDescriptor)descriptor).isInner();
            }
        });
        if (filteringScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getStaticNestedClassesScope"));
        }
        return filteringScope;
    }

    public static boolean isTopLevelOrInnerClass(@NotNull ClassDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isTopLevelOrInnerClass"));
        }
        DeclarationDescriptor containing = descriptor.getContainingDeclaration();
        return DescriptorUtils.isTopLevelDeclaration(descriptor) || containing instanceof ClassDescriptor && DescriptorUtils.isTopLevelOrInnerClass((ClassDescriptor)containing);
    }

    @NotNull
    public static <D extends CallableMemberDescriptor> D unwrapFakeOverride(@NotNull D descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "unwrapFakeOverride"));
        }
        while (descriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            Set<? extends CallableMemberDescriptor> overridden = descriptor.getOverriddenDescriptors();
            if (overridden.isEmpty()) {
                throw new IllegalStateException("Fake override should have at least one overridden descriptor: " + descriptor);
            }
            descriptor = overridden.iterator().next();
        }
        D d = descriptor;
        if (d == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "unwrapFakeOverride"));
        }
        return d;
    }

    public static boolean shouldRecordInitializerForProperty(@NotNull VariableDescriptor variable, @NotNull JetType type) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "shouldRecordInitializerForProperty"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "shouldRecordInitializerForProperty"));
        }
        if (variable.isVar() || type.isError()) {
            return false;
        }
        if (type instanceof LazyType || type.isNullable()) {
            return true;
        }
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        return builtIns.isPrimitiveType(type) || ((Object)builtIns.getStringType()).equals(type) || ((Object)builtIns.getNumber().getDefaultType()).equals(type) || ((Object)builtIns.getAnyType()).equals(type);
    }
}

