/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.elements;

import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.stubs.PsiJetParameterStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementType;
import org.jetbrains.jet.lang.psi.stubs.impl.PsiJetParameterStubImpl;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class JetParameterElementType
extends JetStubElementType<PsiJetParameterStub, JetParameter> {
    public JetParameterElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/jet/lang/psi/stubs/elements/JetParameterElementType", "<init>"));
        }
        super(debugName, JetParameter.class, PsiJetParameterStub.class);
    }

    @Override
    public PsiJetParameterStub createStub(@NotNull JetParameter psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/jet/lang/psi/stubs/elements/JetParameterElementType", "createStub"));
        }
        FqName fqName2 = psi.getFqName();
        StringRef fqNameRef = StringRef.fromString(fqName2 != null ? fqName2.asString() : null);
        return new PsiJetParameterStubImpl(parentStub, fqNameRef, StringRef.fromString(psi.getName()), psi.isMutable(), psi.hasValOrVarNode(), psi.hasDefaultValue());
    }

    @Override
    public void serialize(@NotNull PsiJetParameterStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/stubs/elements/JetParameterElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/jet/lang/psi/stubs/elements/JetParameterElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        dataStream.writeBoolean(stub.isMutable());
        dataStream.writeBoolean(stub.hasValOrValNode());
        dataStream.writeBoolean(stub.hasDefaultValue());
        FqName name = stub.getFqName();
        dataStream.writeName(name != null ? name.asString() : null);
    }

    @Override
    @NotNull
    public PsiJetParameterStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/jet/lang/psi/stubs/elements/JetParameterElementType", "deserialize"));
        }
        StringRef name = dataStream.readName();
        boolean isMutable = dataStream.readBoolean();
        boolean hasValOrValNode = dataStream.readBoolean();
        boolean hasDefaultValue = dataStream.readBoolean();
        StringRef fqName2 = dataStream.readName();
        PsiJetParameterStubImpl psiJetParameterStubImpl = new PsiJetParameterStubImpl(parentStub, fqName2, name, isMutable, hasValOrValNode, hasDefaultValue);
        if (psiJetParameterStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/elements/JetParameterElementType", "deserialize"));
        }
        return psiJetParameterStubImpl;
    }
}

