/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.impl;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SourceElement;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.impl.DeclarationDescriptorNonRootImpl;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.DescriptorFactory;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.DescriptorSubstitutor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.Variance;

public abstract class FunctionDescriptorImpl
extends DeclarationDescriptorNonRootImpl
implements FunctionDescriptor {
    private List<TypeParameterDescriptor> typeParameters;
    private List<ValueParameterDescriptor> unsubstitutedValueParameters;
    private JetType unsubstitutedReturnType;
    private ReceiverParameterDescriptor receiverParameter;
    private ReceiverParameterDescriptor expectedThisObject;
    private Modality modality;
    private Visibility visibility;
    private final Set<FunctionDescriptor> overriddenFunctions;
    private final FunctionDescriptor original;
    private final CallableMemberDescriptor.Kind kind;

    protected FunctionDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @Nullable FunctionDescriptor original, @NotNull Annotations annotations, @NotNull Name name, @NotNull CallableMemberDescriptor.Kind kind, @NotNull SourceElement source) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "<init>"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "<init>"));
        }
        super(containingDeclaration, annotations, name, source);
        this.overriddenFunctions = new LinkedHashSet<FunctionDescriptor>();
        this.original = original == null ? this : original;
        this.kind = kind;
    }

    @NotNull
    public FunctionDescriptorImpl initialize(@Nullable JetType receiverParameterType, @Nullable ReceiverParameterDescriptor expectedThisObject, @NotNull List<? extends TypeParameterDescriptor> typeParameters, @NotNull List<ValueParameterDescriptor> unsubstitutedValueParameters, @Nullable JetType unsubstitutedReturnType, @Nullable Modality modality, @NotNull Visibility visibility) {
        int i;
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "initialize"));
        }
        if (unsubstitutedValueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unsubstitutedValueParameters", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "initialize"));
        }
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "initialize"));
        }
        this.typeParameters = new ArrayList<TypeParameterDescriptor>(typeParameters);
        this.unsubstitutedValueParameters = unsubstitutedValueParameters;
        this.unsubstitutedReturnType = unsubstitutedReturnType;
        this.modality = modality;
        this.visibility = visibility;
        this.receiverParameter = DescriptorFactory.createReceiverParameterForCallable(this, receiverParameterType);
        this.expectedThisObject = expectedThisObject;
        for (i = 0; i < typeParameters.size(); ++i) {
            TypeParameterDescriptor typeParameterDescriptor = typeParameters.get(i);
            if (typeParameterDescriptor.getIndex() == i) continue;
            throw new IllegalStateException(typeParameterDescriptor + " index is " + typeParameterDescriptor.getIndex() + " but position is " + i);
        }
        for (i = 0; i < unsubstitutedValueParameters.size(); ++i) {
            int firstValueParameterOffset = 0;
            ValueParameterDescriptor valueParameterDescriptor = unsubstitutedValueParameters.get(i);
            if (valueParameterDescriptor.getIndex() == i + firstValueParameterOffset) continue;
            throw new IllegalStateException(valueParameterDescriptor + "index is " + valueParameterDescriptor.getIndex() + " but position is " + i);
        }
        FunctionDescriptorImpl functionDescriptorImpl = this;
        if (functionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "initialize"));
        }
        return functionDescriptorImpl;
    }

    public void setVisibility(@NotNull Visibility visibility) {
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "setVisibility"));
        }
        this.visibility = visibility;
    }

    public void setReturnType(@NotNull JetType unsubstitutedReturnType) {
        if (unsubstitutedReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unsubstitutedReturnType", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "setReturnType"));
        }
        if (this.unsubstitutedReturnType != null) {
            // empty if block
        }
        this.unsubstitutedReturnType = unsubstitutedReturnType;
    }

    @Override
    @Nullable
    public ReceiverParameterDescriptor getReceiverParameter() {
        return this.receiverParameter;
    }

    @Override
    @Nullable
    public ReceiverParameterDescriptor getExpectedThisObject() {
        return this.expectedThisObject;
    }

    @Override
    @NotNull
    public Set<? extends FunctionDescriptor> getOverriddenDescriptors() {
        Set<FunctionDescriptor> set = this.overriddenFunctions;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "getOverriddenDescriptors"));
        }
        return set;
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = this.modality;
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "getModality"));
        }
        return modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = this.visibility;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "getVisibility"));
        }
        return visibility;
    }

    @Override
    public void addOverriddenDescriptor(@NotNull CallableMemberDescriptor overriddenFunction) {
        if (overriddenFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overriddenFunction", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "addOverriddenDescriptor"));
        }
        this.overriddenFunctions.add((FunctionDescriptor)overriddenFunction);
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getTypeParameters() {
        List<TypeParameterDescriptor> list = this.typeParameters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "getTypeParameters"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<ValueParameterDescriptor> getValueParameters() {
        List<ValueParameterDescriptor> list = this.unsubstitutedValueParameters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "getValueParameters"));
        }
        return list;
    }

    @Override
    public boolean hasStableParameterNames() {
        return true;
    }

    @Override
    public boolean hasSynthesizedParameterNames() {
        return false;
    }

    @Override
    public JetType getReturnType() {
        return this.unsubstitutedReturnType;
    }

    @Override
    @NotNull
    public FunctionDescriptor getOriginal() {
        FunctionDescriptor functionDescriptor = this.original == this ? this : this.original.getOriginal();
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "getOriginal"));
        }
        return functionDescriptor;
    }

    @Override
    @NotNull
    public CallableMemberDescriptor.Kind getKind() {
        CallableMemberDescriptor.Kind kind = this.kind;
        if (kind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "getKind"));
        }
        return kind;
    }

    @Override
    public final FunctionDescriptor substitute(@NotNull TypeSubstitutor originalSubstitutor) {
        if (originalSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalSubstitutor", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "substitute"));
        }
        if (originalSubstitutor.isEmpty()) {
            return this;
        }
        return this.doSubstitute(originalSubstitutor, this.getContainingDeclaration(), this.modality, this.visibility, this.getOriginal(), true, this.getKind());
    }

    @Nullable
    protected FunctionDescriptor doSubstitute(@NotNull TypeSubstitutor originalSubstitutor, @NotNull DeclarationDescriptor newOwner, @NotNull Modality newModality, @NotNull Visibility newVisibility, @Nullable FunctionDescriptor original, boolean copyOverrides, @NotNull CallableMemberDescriptor.Kind kind) {
        if (originalSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalSubstitutor", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "doSubstitute"));
        }
        if (newOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newOwner", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "doSubstitute"));
        }
        if (newModality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newModality", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "doSubstitute"));
        }
        if (newVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newVisibility", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "doSubstitute"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "doSubstitute"));
        }
        FunctionDescriptorImpl substitutedDescriptor = this.createSubstitutedCopy(newOwner, original, kind);
        List<TypeParameterDescriptor> originalTypeParameters = this.getTypeParameters();
        ArrayList<TypeParameterDescriptor> substitutedTypeParameters = new ArrayList<TypeParameterDescriptor>(originalTypeParameters.size());
        TypeSubstitutor substitutor = DescriptorSubstitutor.substituteTypeParameters(originalTypeParameters, originalSubstitutor, substitutedDescriptor, substitutedTypeParameters);
        JetType substitutedReceiverParameterType = null;
        if (this.receiverParameter != null && (substitutedReceiverParameterType = substitutor.substitute(this.getReceiverParameter().getType(), Variance.IN_VARIANCE)) == null) {
            return null;
        }
        ReceiverParameterDescriptor substitutedExpectedThis = null;
        if (this.expectedThisObject != null && (substitutedExpectedThis = this.expectedThisObject.substitute(substitutor)) == null) {
            return null;
        }
        List<ValueParameterDescriptor> substitutedValueParameters = FunctionDescriptorImpl.getSubstitutedValueParameters(substitutedDescriptor, this, substitutor);
        if (substitutedValueParameters == null) {
            return null;
        }
        JetType substitutedReturnType = substitutor.substitute(this.getReturnType(), Variance.OUT_VARIANCE);
        if (substitutedReturnType == null) {
            return null;
        }
        substitutedDescriptor.initialize(substitutedReceiverParameterType, substitutedExpectedThis, substitutedTypeParameters, substitutedValueParameters, substitutedReturnType, newModality, newVisibility);
        if (copyOverrides) {
            for (FunctionDescriptor overriddenFunction : this.overriddenFunctions) {
                OverridingUtil.bindOverride(substitutedDescriptor, overriddenFunction.substitute(substitutor));
            }
        }
        return substitutedDescriptor;
    }

    @NotNull
    protected abstract FunctionDescriptorImpl createSubstitutedCopy(@NotNull DeclarationDescriptor var1, @Nullable FunctionDescriptor var2, @NotNull CallableMemberDescriptor.Kind var3);

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data2) {
        return visitor.visitFunctionDescriptor(this, data2);
    }

    @Nullable
    public static List<ValueParameterDescriptor> getSubstitutedValueParameters(FunctionDescriptor substitutedDescriptor, @NotNull FunctionDescriptor functionDescriptor, @NotNull TypeSubstitutor substitutor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "getSubstitutedValueParameters"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/descriptors/impl/FunctionDescriptorImpl", "getSubstitutedValueParameters"));
        }
        ArrayList<ValueParameterDescriptor> result2 = new ArrayList<ValueParameterDescriptor>();
        List<ValueParameterDescriptor> unsubstitutedValueParameters = functionDescriptor.getValueParameters();
        for (ValueParameterDescriptor unsubstitutedValueParameter : unsubstitutedValueParameters) {
            JetType substituteVarargElementType;
            JetType substitutedType = substitutor.substitute(unsubstitutedValueParameter.getType(), Variance.IN_VARIANCE);
            JetType varargElementType = unsubstitutedValueParameter.getVarargElementType();
            JetType jetType = substituteVarargElementType = varargElementType == null ? null : substitutor.substitute(varargElementType, Variance.IN_VARIANCE);
            if (substitutedType == null) {
                return null;
            }
            result2.add(new ValueParameterDescriptorImpl(substitutedDescriptor, unsubstitutedValueParameter, unsubstitutedValueParameter.getIndex(), unsubstitutedValueParameter.getAnnotations(), unsubstitutedValueParameter.getName(), substitutedType, unsubstitutedValueParameter.declaresDefaultValue(), substituteVarargElementType, SourceElement.NO_SOURCE));
        }
        return result2;
    }
}

