/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.binding;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.JvmRuntimeTypes;
import org.jetbrains.jet.codegen.SamCodegenUtil;
import org.jetbrains.jet.codegen.SamType;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.when.SwitchCodegenUtil;
import org.jetbrains.jet.codegen.when.WhenByEnumsMapping;
import org.jetbrains.jet.lang.cfg.WhenChecker;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetCallableReferenceExpression;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperCall;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorToSourceUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.jet.lang.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.EnumValue;
import org.jetbrains.jet.lang.resolve.constants.NullValue;
import org.jetbrains.jet.lang.resolve.kotlin.PackagePartClassUtils;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.name.SpecialNames;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.source.SourcePackage;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.org.objectweb.asm.Type;

class CodegenAnnotatingVisitor
extends JetVisitorVoid {
    private static final TokenSet BINARY_OPERATIONS = TokenSet.orSet(JetTokens.AUGMENTED_ASSIGNMENTS, TokenSet.create(JetTokens.PLUS, JetTokens.MINUS, JetTokens.MUL, JetTokens.DIV, JetTokens.PERC, JetTokens.RANGE, JetTokens.LT, JetTokens.GT, JetTokens.LTEQ, JetTokens.GTEQ, JetTokens.IDENTIFIER));
    private final Map<String, Integer> anonymousSubclassesCount;
    private final Stack<ClassDescriptorWithState> classStack;
    private final Stack<String> nameStack;
    private final BindingTrace bindingTrace;
    private final BindingContext bindingContext;
    private final GenerationState.GenerateClassFilter filter;
    private final JvmRuntimeTypes runtimeTypes;

    public CodegenAnnotatingVisitor(@NotNull GenerationState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "<init>"));
        }
        this.anonymousSubclassesCount = new HashMap<String, Integer>();
        this.classStack = new Stack();
        this.nameStack = new Stack();
        this.bindingTrace = state.getBindingTrace();
        this.bindingContext = state.getBindingContext();
        this.filter = state.getGenerateDeclaredClassFilter();
        this.runtimeTypes = state.getJvmRuntimeTypes();
    }

    @NotNull
    private ClassDescriptor recordClassForFunction(@NotNull JetElement element, @NotNull FunctionDescriptor funDescriptor, @NotNull Collection<JetType> supertypes, @NotNull String name) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "recordClassForFunction"));
        }
        if (funDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "funDescriptor", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "recordClassForFunction"));
        }
        if (supertypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "recordClassForFunction"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "recordClassForFunction"));
        }
        String simpleName = name.substring(name.lastIndexOf(47) + 1);
        ClassDescriptorImpl classDescriptor = new ClassDescriptorImpl(funDescriptor.getContainingDeclaration(), Name.special("<closure-" + simpleName + ">"), Modality.FINAL, supertypes, SourcePackage.toSourceElement(element));
        classDescriptor.initialize(JetScope.EMPTY, Collections.<ConstructorDescriptor>emptySet(), null);
        this.bindingTrace.record(CodegenBinding.CLASS_FOR_FUNCTION, funDescriptor, classDescriptor);
        ClassDescriptorImpl classDescriptorImpl = classDescriptor;
        if (classDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "recordClassForFunction"));
        }
        return classDescriptorImpl;
    }

    private String inventAnonymousClassName(JetElement declaration) {
        String top = CodegenAnnotatingVisitor.peekFromStack(this.nameStack);
        Integer cnt = this.anonymousSubclassesCount.get(top);
        if (cnt == null) {
            cnt = 0;
        }
        String name = top + "$" + (cnt + 1);
        ClassDescriptor descriptor = this.bindingContext.get(BindingContext.CLASS, declaration);
        if (!(descriptor != null || declaration instanceof JetFunctionLiteralExpression || declaration instanceof JetNamedFunction || declaration instanceof JetObjectLiteralExpression || declaration instanceof JetCallableReferenceExpression)) {
            throw new IllegalStateException("Class-less declaration which is not JetFunctionLiteralExpression|JetNamedFunction|JetObjectLiteralExpression|JetCallableReferenceExpression : " + declaration.getClass().getName());
        }
        this.anonymousSubclassesCount.put(top, cnt + 1);
        return name;
    }

    @Override
    public void visitJetElement(@NotNull JetElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitJetElement"));
        }
        super.visitJetElement(element);
        element.acceptChildren(this);
    }

    @Override
    public void visitJetFile(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitJetFile"));
        }
        if (file.isScript()) {
            ClassDescriptor classDescriptor = this.bindingContext.get(CodegenBinding.CLASS_FOR_SCRIPT, this.bindingContext.get(BindingContext.SCRIPT, file.getScript()));
            this.pushClassDescriptor(classDescriptor);
            this.nameStack.push(CodegenBinding.asmTypeForScriptPsi(this.bindingContext, file.getScript()).getInternalName());
        } else {
            this.nameStack.push(AsmUtil.internalNameByFqNameWithoutInnerClasses(file.getPackageFqName()));
        }
        file.acceptChildren(this);
        this.nameStack.pop();
        if (file.isScript()) {
            this.popClassDescriptor();
        }
    }

    @Override
    public void visitEnumEntry(@NotNull JetEnumEntry enumEntry) {
        if (enumEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitEnumEntry"));
        }
        ClassDescriptor descriptor = this.bindingContext.get(BindingContext.CLASS, enumEntry);
        assert (descriptor != null) : String.format("No descriptor for enum entry \n---\n%s\n---\n", JetPsiUtil.getElementTextWithContext(enumEntry));
        if (!enumEntry.getDeclarations().isEmpty()) {
            this.bindingTrace.record(CodegenBinding.ENUM_ENTRY_CLASS_NEED_SUBCLASS, descriptor);
            super.visitEnumEntry(enumEntry);
        }
    }

    @Override
    public void visitClassObject(@NotNull JetClassObject classObject) {
        if (classObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObject", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitClassObject"));
        }
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, classObject.getObjectDeclaration());
        assert (classDescriptor != null) : String.format("No class found in binding context for: \n---\n%s\n---\n", JetPsiUtil.getElementTextWithContext(classObject));
        String name = CodegenAnnotatingVisitor.peekFromStack(this.nameStack) + "$object";
        this.recordClosure(classDescriptor, name);
        this.pushClassDescriptor(classDescriptor);
        this.nameStack.push(name);
        super.visitClassObject(classObject);
        this.nameStack.pop();
        this.popClassDescriptor();
    }

    @Override
    public void visitObjectDeclaration(@NotNull JetObjectDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitObjectDeclaration"));
        }
        if (declaration.getParent() instanceof JetObjectLiteralExpression || declaration.getParent() instanceof JetClassObject) {
            super.visitObjectDeclaration(declaration);
        } else {
            if (!this.filter.shouldProcess(declaration)) {
                return;
            }
            ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, declaration);
            if (classDescriptor == null) {
                return;
            }
            String name = this.getName(classDescriptor);
            this.recordClosure(classDescriptor, name);
            this.pushClassDescriptor(classDescriptor);
            this.nameStack.push(name);
            super.visitObjectDeclaration(declaration);
            this.nameStack.pop();
            this.popClassDescriptor();
        }
    }

    @Override
    public void visitClass(@NotNull JetClass klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitClass"));
        }
        if (!this.filter.shouldProcess(klass)) {
            return;
        }
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, klass);
        if (classDescriptor == null) {
            return;
        }
        String name = this.getName(classDescriptor);
        this.recordClosure(classDescriptor, name);
        this.pushClassDescriptor(classDescriptor);
        this.nameStack.push(name);
        super.visitClass(klass);
        this.nameStack.pop();
        this.popClassDescriptor();
    }

    private String getName(ClassDescriptor classDescriptor) {
        String base = CodegenAnnotatingVisitor.peekFromStack(this.nameStack);
        Name descriptorName = SpecialNames.safeIdentifier(classDescriptor.getName());
        return DescriptorUtils.isTopLevelDeclaration(classDescriptor) ? (base.isEmpty() ? descriptorName.asString() : base + '/' + descriptorName) : base + '$' + descriptorName;
    }

    @Override
    public void visitObjectLiteralExpression(@NotNull JetObjectLiteralExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitObjectLiteralExpression"));
        }
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, expression.getObjectDeclaration());
        if (classDescriptor == null) {
            super.visitObjectLiteralExpression(expression);
            return;
        }
        String name = this.inventAnonymousClassName(expression.getObjectDeclaration());
        this.recordClosure(classDescriptor, name);
        this.pushClassDescriptor(classDescriptor);
        this.nameStack.push(CodegenBinding.getAsmType(this.bindingContext, classDescriptor).getInternalName());
        super.visitObjectLiteralExpression(expression);
        this.nameStack.pop();
        this.popClassDescriptor();
    }

    @Override
    public void visitFunctionLiteralExpression(@NotNull JetFunctionLiteralExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitFunctionLiteralExpression"));
        }
        JetFunctionLiteral functionLiteral = expression.getFunctionLiteral();
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, functionLiteral);
        if (functionDescriptor == null) {
            return;
        }
        String name = this.inventAnonymousClassName(expression);
        Collection<JetType> supertypes = this.runtimeTypes.getSupertypesForClosure(functionDescriptor);
        ClassDescriptor classDescriptor = this.recordClassForFunction(functionLiteral, functionDescriptor, supertypes, name);
        this.recordClosure(classDescriptor, name);
        this.pushClassDescriptor(classDescriptor);
        this.nameStack.push(name);
        super.visitFunctionLiteralExpression(expression);
        this.nameStack.pop();
        this.popClassDescriptor();
    }

    private void pushClassDescriptor(ClassDescriptor classDescriptor) {
        this.classStack.push(new ClassDescriptorWithState(classDescriptor));
    }

    private void popClassDescriptor() {
        this.classStack.pop();
    }

    private ClassDescriptor getOuterClassDescriptor() {
        ListIterator iterator2 = this.classStack.listIterator(this.classStack.size());
        while (iterator2.hasPrevious()) {
            ClassDescriptorWithState previous = (ClassDescriptorWithState)iterator2.previous();
            if (previous.isDelegationToSuperCall()) continue;
            return previous.getDescriptor();
        }
        return null;
    }

    @Override
    public void visitDelegationToSuperCallSpecifier(@NotNull JetDelegatorToSuperCall call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitDelegationToSuperCallSpecifier"));
        }
        ClassDescriptorWithState state = CodegenAnnotatingVisitor.peekFromStack(this.classStack);
        if (state == null) {
            return;
        }
        state.setDelegationToSuperCall(true);
        super.visitDelegationToSuperCallSpecifier(call);
        state.setDelegationToSuperCall(false);
    }

    @Override
    public void visitCallableReferenceExpression(@NotNull JetCallableReferenceExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitCallableReferenceExpression"));
        }
        FunctionDescriptor functionDescriptor = this.bindingContext.get(BindingContext.FUNCTION, expression);
        if (functionDescriptor == null) {
            return;
        }
        ResolvedCall<? extends CallableDescriptor> referencedFunction = CallUtilPackage.getResolvedCall(expression.getCallableReference(), this.bindingContext);
        if (referencedFunction == null) {
            return;
        }
        Collection<JetType> supertypes = this.runtimeTypes.getSupertypesForFunctionReference((FunctionDescriptor)referencedFunction.getResultingDescriptor());
        String name = this.inventAnonymousClassName(expression);
        ClassDescriptor classDescriptor = this.recordClassForFunction(expression, functionDescriptor, supertypes, name);
        this.recordClosure(classDescriptor, name);
        this.pushClassDescriptor(classDescriptor);
        this.nameStack.push(name);
        super.visitCallableReferenceExpression(expression);
        this.nameStack.pop();
        this.popClassDescriptor();
    }

    private void recordClosure(@NotNull ClassDescriptor classDescriptor, @NotNull String name) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "recordClosure"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "recordClosure"));
        }
        CodegenBinding.recordClosure(this.bindingTrace, classDescriptor, this.getOuterClassDescriptor(), Type.getObjectType(name));
    }

    @Override
    public void visitProperty(@NotNull JetProperty property2) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitProperty"));
        }
        DeclarationDescriptor propertyDescriptor = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, property2);
        if (propertyDescriptor == null) {
            return;
        }
        String nameForClassOrPackageMember = this.getNameForClassOrPackageMember(propertyDescriptor);
        if (nameForClassOrPackageMember != null) {
            this.nameStack.push(nameForClassOrPackageMember);
        } else {
            this.nameStack.push(CodegenAnnotatingVisitor.peekFromStack(this.nameStack) + '$' + SpecialNames.safeIdentifier(property2.getNameAsSafeName()).asString());
        }
        super.visitProperty(property2);
        this.nameStack.pop();
    }

    @Override
    public void visitNamedFunction(@NotNull JetNamedFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitNamedFunction"));
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function);
        if (functionDescriptor == null) {
            return;
        }
        String nameForClassOrPackageMember = this.getNameForClassOrPackageMember(functionDescriptor);
        if (nameForClassOrPackageMember != null) {
            this.nameStack.push(nameForClassOrPackageMember);
            super.visitNamedFunction(function);
            this.nameStack.pop();
        } else {
            String name = this.inventAnonymousClassName(function);
            Collection<JetType> supertypes = this.runtimeTypes.getSupertypesForClosure(functionDescriptor);
            ClassDescriptor classDescriptor = this.recordClassForFunction(function, functionDescriptor, supertypes, name);
            this.recordClosure(classDescriptor, name);
            this.pushClassDescriptor(classDescriptor);
            this.nameStack.push(name);
            super.visitNamedFunction(function);
            this.nameStack.pop();
            this.popClassDescriptor();
        }
    }

    @Nullable
    private String getNameForClassOrPackageMember(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "getNameForClassOrPackageMember"));
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        String peek = CodegenAnnotatingVisitor.peekFromStack(this.nameStack);
        String name = SpecialNames.safeIdentifier(descriptor.getName()).asString();
        if (containingDeclaration instanceof ClassDescriptor) {
            return peek + '$' + name;
        }
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            JetFile containingFile = DescriptorToSourceUtils.getContainingFile(descriptor);
            assert (containingFile != null) : "File not found for " + descriptor;
            return PackagePartClassUtils.getPackagePartInternalName(containingFile) + '$' + name;
        }
        return null;
    }

    @Override
    public void visitCallExpression(@NotNull JetCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitCallExpression"));
        }
        super.visitCallExpression(expression);
        ResolvedCall<? extends CallableDescriptor> call = CallUtilPackage.getResolvedCall(expression, this.bindingContext);
        if (call == null) {
            return;
        }
        CallableDescriptor descriptor = call.getResultingDescriptor();
        if (!(descriptor instanceof FunctionDescriptor)) {
            return;
        }
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)descriptor);
        if (original == null) {
            return;
        }
        List<ResolvedValueArgument> valueArguments2 = call.getValueArgumentsByIndex();
        if (valueArguments2 == null) {
            throw new IllegalStateException("Failed to arrange value arguments by index: " + descriptor);
        }
        for (ValueParameterDescriptor valueParameter : original.getValueParameters()) {
            SamType samType = SamType.create(valueParameter.getType());
            if (samType == null) continue;
            ResolvedValueArgument resolvedValueArgument = valueArguments2.get(valueParameter.getIndex());
            assert (resolvedValueArgument instanceof ExpressionValueArgument) : resolvedValueArgument;
            ValueArgument valueArgument = ((ExpressionValueArgument)resolvedValueArgument).getValueArgument();
            assert (valueArgument != null);
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            assert (argumentExpression != null) : valueArgument.asElement().getText();
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, argumentExpression, samType);
        }
    }

    @Override
    public void visitBinaryExpression(@NotNull JetBinaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitBinaryExpression"));
        }
        super.visitBinaryExpression(expression);
        DeclarationDescriptor operationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getOperationReference());
        if (!(operationDescriptor instanceof FunctionDescriptor)) {
            return;
        }
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)operationDescriptor);
        if (original == null) {
            return;
        }
        SamType samType = SamType.create(original.getValueParameters().get(0).getType());
        if (samType == null) {
            return;
        }
        IElementType token = expression.getOperationToken();
        if (BINARY_OPERATIONS.contains(token)) {
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, expression.getRight(), samType);
        } else if (token == JetTokens.IN_KEYWORD || token == JetTokens.NOT_IN) {
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, expression.getLeft(), samType);
        }
    }

    @Override
    public void visitArrayAccessExpression(@NotNull JetArrayAccessExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitArrayAccessExpression"));
        }
        super.visitArrayAccessExpression(expression);
        DeclarationDescriptor operationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression);
        if (!(operationDescriptor instanceof FunctionDescriptor)) {
            return;
        }
        boolean isSetter = operationDescriptor.getName().asString().equals("set");
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter((FunctionDescriptor)operationDescriptor);
        if (original == null) {
            return;
        }
        List<JetExpression> indexExpressions = expression.getIndexExpressions();
        List<ValueParameterDescriptor> parameters = original.getValueParameters();
        for (ValueParameterDescriptor valueParameter : parameters) {
            SamType samType = SamType.create(valueParameter.getType());
            if (samType == null) continue;
            if (isSetter && valueParameter.getIndex() == parameters.size() - 1) {
                PsiElement parent = expression.getParent();
                if (!(parent instanceof JetBinaryExpression) || ((JetBinaryExpression)parent).getOperationToken() != JetTokens.EQ) continue;
                JetExpression right = ((JetBinaryExpression)parent).getRight();
                this.bindingTrace.record(CodegenBinding.SAM_VALUE, right, samType);
                continue;
            }
            JetExpression indexExpression = indexExpressions.get(valueParameter.getIndex());
            this.bindingTrace.record(CodegenBinding.SAM_VALUE, indexExpression, samType);
        }
    }

    @Override
    public void visitWhenExpression(@NotNull JetWhenExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "visitWhenExpression"));
        }
        super.visitWhenExpression(expression);
        if (!this.isWhenWithEnums(expression)) {
            return;
        }
        String currentClassName = this.getCurrentTopLevelClassOrPackagePartInternalName(expression.getContainingJetFile());
        if (this.bindingContext.get(CodegenBinding.MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE, currentClassName) == null) {
            this.bindingTrace.record(CodegenBinding.MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE, currentClassName, new ArrayList(1));
        }
        List<WhenByEnumsMapping> mappings = this.bindingContext.get(CodegenBinding.MAPPINGS_FOR_WHENS_BY_ENUM_IN_CLASS_FILE, currentClassName);
        assert (mappings != null) : "guaranteed by contract";
        int fieldNumber = mappings.size();
        JetType type = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, expression.getSubjectExpression());
        assert (type != null) : "should not be null in a valid when by enums";
        ClassDescriptor classDescriptor = (ClassDescriptor)type.getConstructor().getDeclarationDescriptor();
        assert (classDescriptor != null) : "because it's enum";
        WhenByEnumsMapping mapping2 = new WhenByEnumsMapping(classDescriptor, currentClassName, fieldNumber);
        for (CompileTimeConstant constant : SwitchCodegenUtil.getAllConstants(expression, this.bindingContext)) {
            if (constant instanceof NullValue) continue;
            assert (constant instanceof EnumValue) : "expression in when should be EnumValue";
            mapping2.putFirstTime((EnumValue)constant, mapping2.size() + 1);
        }
        mappings.add(mapping2);
        this.bindingTrace.record(CodegenBinding.MAPPING_FOR_WHEN_BY_ENUM, expression, mapping2);
    }

    private boolean isWhenWithEnums(@NotNull JetWhenExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "isWhenWithEnums"));
        }
        return WhenChecker.isWhenByEnum(expression, this.bindingContext) && SwitchCodegenUtil.checkAllItemsAreConstantsSatisfying(expression, this.bindingContext, new Function1<CompileTimeConstant, Boolean>(){

            @Override
            public Boolean invoke(@NotNull CompileTimeConstant constant) {
                if (constant == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constant", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor$1", "invoke"));
                }
                return constant instanceof EnumValue || constant instanceof NullValue;
            }
        });
    }

    @NotNull
    private String getCurrentTopLevelClassOrPackagePartInternalName(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "getCurrentTopLevelClassOrPackagePartInternalName"));
        }
        ListIterator iterator2 = this.classStack.listIterator(this.classStack.size());
        while (iterator2.hasPrevious()) {
            ClassDescriptor previous = ((ClassDescriptorWithState)iterator2.previous()).getDescriptor();
            if (!DescriptorUtils.isTopLevelOrInnerClass(previous)) continue;
            String string = CodegenBinding.getAsmType(this.bindingContext, previous).getInternalName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "getCurrentTopLevelClassOrPackagePartInternalName"));
            }
            return string;
        }
        String string = PackagePartClassUtils.getPackagePartInternalName(file);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "getCurrentTopLevelClassOrPackagePartInternalName"));
        }
        return string;
    }

    private static <T> T peekFromStack(@NotNull Stack<T> stack) {
        if (stack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stack", "org/jetbrains/jet/codegen/binding/CodegenAnnotatingVisitor", "peekFromStack"));
        }
        return stack.empty() ? null : (T)stack.peek();
    }

    private static class ClassDescriptorWithState {
        private boolean isDelegationToSuperCall;
        private final ClassDescriptor descriptor;

        public ClassDescriptorWithState(ClassDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public boolean isDelegationToSuperCall() {
            return this.isDelegationToSuperCall;
        }

        public void setDelegationToSuperCall(boolean isDelegationToSuperCall) {
            this.isDelegationToSuperCall = isDelegationToSuperCall;
        }

        public ClassDescriptor getDescriptor() {
            return this.descriptor;
        }
    }
}

