/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.google.common.collect.Lists;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Function0;
import kotlin.Function1;
import kotlin.Function2;
import kotlin.KotlinPackage;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.backend.common.CodegenUtil;
import org.jetbrains.jet.backend.common.DataClassMethodGenerator;
import org.jetbrains.jet.codegen.AnnotationCodegen;
import org.jetbrains.jet.codegen.ArgumentGenerator;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.CallBasedArgumentGenerator;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.ClassBodyCodegen;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.ClosureCodegen;
import org.jetbrains.jet.codegen.CompilationException;
import org.jetbrains.jet.codegen.DefaultParameterValueLoader;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FieldInfo;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.FunctionGenerationStrategy;
import org.jetbrains.jet.codegen.JavaSerializerExtension;
import org.jetbrains.jet.codegen.JvmCodegenUtil;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.MethodKind;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.PropertyCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.binding.MutableClosure;
import org.jetbrains.jet.codegen.bridges.BridgesPackage;
import org.jetbrains.jet.codegen.context.ClassContext;
import org.jetbrains.jet.codegen.context.ConstructorContext;
import org.jetbrains.jet.codegen.context.FieldOwnerContext;
import org.jetbrains.jet.codegen.context.MethodContext;
import org.jetbrains.jet.codegen.signature.BothSignatureWriter;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.descriptors.serialization.BitEncoding;
import org.jetbrains.jet.descriptors.serialization.ClassData;
import org.jetbrains.jet.descriptors.serialization.DescriptorSerializer;
import org.jetbrains.jet.descriptors.serialization.NameSerializationUtil;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorByExpressionSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperCall;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DeclarationResolver;
import org.jetbrains.jet.lang.resolve.DescriptorToSourceUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.jet.lang.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.VarargValueArgument;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.java.JvmAbi;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.diagnostics.DiagnosticsPackage;
import org.jetbrains.jet.lang.resolve.java.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.jet.lang.resolve.java.jvmSignature.JvmClassSignature;
import org.jetbrains.jet.lang.resolve.java.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.jet.lang.resolve.java.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.jet.lang.resolve.java.jvmSignature.JvmMethodSignature;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.SubstitutionUtils;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class ImplementationBodyCodegen
extends ClassBodyCodegen {
    private JetDelegatorToSuperCall superCall;
    private Type superClassAsmType;
    @Nullable
    private JetType superClassType;
    private final Type classAsmType;
    private List<PropertyAndDefaultValue> classObjectPropertiesToCopy;
    private final List<Function2<ImplementationBodyCodegen, ClassBuilder, Unit>> additionalTasks;
    private final List<JetEnumEntry> myEnumConstants;

    public ImplementationBodyCodegen(@NotNull JetClassOrObject aClass, @NotNull ClassContext context2, @NotNull ClassBuilder v, @NotNull GenerationState state, @Nullable MemberCodegen<?> parentCodegen) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "<init>"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "<init>"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "<init>"));
        }
        super(aClass, context2, v, state, parentCodegen);
        this.additionalTasks = new ArrayList<Function2<ImplementationBodyCodegen, ClassBuilder, Unit>>();
        this.myEnumConstants = new ArrayList<JetEnumEntry>();
        this.classAsmType = this.typeMapper.mapClass(this.descriptor);
    }

    @Override
    protected void generateDeclaration() {
        boolean isStatic;
        this.getSuperClass();
        JvmClassSignature signature = this.signature();
        boolean isAbstract = false;
        boolean isInterface = false;
        boolean isFinal = false;
        boolean isAnnotation = false;
        boolean isEnum = false;
        if (this.myClass instanceof JetClass) {
            JetClass jetClass = (JetClass)this.myClass;
            if (jetClass.hasModifier(JetTokens.ABSTRACT_KEYWORD)) {
                isAbstract = true;
            }
            if (jetClass.isTrait()) {
                isAbstract = true;
                isInterface = true;
            } else if (jetClass.isAnnotation()) {
                isAbstract = true;
                isInterface = true;
                isAnnotation = true;
                signature.getInterfaces().add("java/lang/annotation/Annotation");
            } else if (jetClass.isEnum()) {
                isAbstract = JvmCodegenUtil.hasAbstractMembers(this.descriptor);
                isEnum = true;
            }
            if (this.descriptor.getKind() == ClassKind.OBJECT || this.descriptor.getKind() == ClassKind.CLASS_OBJECT) {
                isFinal = true;
            }
            if (!jetClass.hasModifier(JetTokens.OPEN_KEYWORD) && !isAbstract) {
                isFinal = true;
            }
            isStatic = !jetClass.isInner();
        } else {
            isStatic = this.myClass.getParent() instanceof JetClassObject;
            isFinal = true;
        }
        int access = 0;
        if (this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES && !DescriptorUtils.isTopLevelDeclaration(this.descriptor)) {
            access |= AsmUtil.getVisibilityAccessFlag(this.descriptor);
            if (isStatic) {
                access |= 8;
            }
        } else {
            access |= AsmUtil.getVisibilityAccessFlagForClass(this.descriptor);
        }
        if (isAbstract) {
            access |= 0x400;
        }
        access = isInterface ? (access |= 0x200) : (access |= 0x20);
        if (isFinal) {
            access |= 0x10;
        }
        if (isAnnotation) {
            access |= 0x2000;
        }
        if (KotlinBuiltIns.getInstance().isDeprecated(this.descriptor)) {
            access |= 0x20000;
        }
        if (isEnum) {
            for (JetDeclaration declaration : this.myClass.getDeclarations()) {
                if (!(declaration instanceof JetEnumEntry) || !CodegenBinding.enumEntryNeedSubclass(this.state.getBindingContext(), (JetEnumEntry)declaration)) continue;
                access &= 0xFFFFFFEF;
            }
            access |= 0x4000;
        }
        List<String> interfaces = signature.getInterfaces();
        this.v.defineClass(this.myClass, 50, access, signature.getName(), signature.getJavaGenericSignature(), signature.getSuperclassName(), ArrayUtil.toStringArray(interfaces));
        this.v.visitSource(this.myClass.getContainingFile().getName(), null);
        this.writeEnclosingMethod();
        this.writeOuterClasses();
        this.writeInnerClasses();
        AnnotationCodegen.forClass(this.v.getVisitor(), this.typeMapper).genAnnotations(this.descriptor, null);
        this.generateReflectionObjectFieldIfNeeded();
    }

    @Override
    protected void generateKotlinAnnotation() {
        if (DescriptorUtils.isAnonymousObject(this.descriptor)) {
            AsmUtil.writeKotlinSyntheticClassAnnotation(this.v, JvmAnnotationNames.KotlinSyntheticClass.Kind.ANONYMOUS_OBJECT);
            return;
        }
        if (!DescriptorUtils.isTopLevelOrInnerClass(this.descriptor)) {
            AsmUtil.writeKotlinSyntheticClassAnnotation(this.v, JvmAnnotationNames.KotlinSyntheticClass.Kind.LOCAL_CLASS);
            return;
        }
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        DescriptorSerializer serializer2 = new DescriptorSerializer(new JavaSerializerExtension(this.v.getSerializationBindings()));
        ProtoBuf.Class classProto = serializer2.classProto(this.descriptor).build();
        ClassData data2 = new ClassData(NameSerializationUtil.createNameResolver(serializer2.getNameTable()), classProto);
        AnnotationVisitor av = this.v.getVisitor().visitAnnotation(AsmUtil.asmDescByFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_CLASS), true);
        av.visit("abiVersion", 18);
        AnnotationVisitor array = av.visitArray("data");
        for (String string : BitEncoding.encodeBytes(data2.toBytes())) {
            array.visit(null, string);
        }
        array.visitEnd();
        av.visitEnd();
    }

    private void writeEnclosingMethod() {
        boolean isLocalOrAnonymousClass;
        DeclarationDescriptor parentDescriptor = this.descriptor.getContainingDeclaration();
        boolean isObjectLiteral = DescriptorUtils.isAnonymousObject(this.descriptor);
        boolean bl = isLocalOrAnonymousClass = isObjectLiteral || !(parentDescriptor instanceof PackageFragmentDescriptor) && !(parentDescriptor instanceof ClassDescriptor);
        if (isLocalOrAnonymousClass && this.state.getClassBuilderMode() != ClassBuilderMode.LIGHT_CLASSES) {
            AsmUtil.writeOuterClassAndEnclosingMethod(this.descriptor, this.descriptor, this.typeMapper, this.v);
        }
    }

    private void writeInnerClasses() {
        Collection<ClassDescriptor> result2 = this.bindingContext.get(CodegenBinding.INNER_CLASSES, this.descriptor);
        if (result2 != null) {
            for (ClassDescriptor innerClass : result2) {
                this.writeInnerClass(innerClass);
            }
        }
    }

    private void writeOuterClasses() {
        for (DeclarationDescriptor inner = this.descriptor; inner != null && !DescriptorUtils.isTopLevelDeclaration(inner); inner = inner.getContainingDeclaration()) {
            if (!(inner instanceof ClassDescriptor)) continue;
            this.writeInnerClass((ClassDescriptor)inner);
        }
    }

    private void writeInnerClass(@NotNull ClassDescriptor innerClass) {
        String outerClassInternalName;
        if (innerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClass", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "writeInnerClass"));
        }
        DeclarationDescriptor containing = innerClass.getContainingDeclaration();
        String string = outerClassInternalName = containing instanceof ClassDescriptor ? this.typeMapper.mapClass((ClassDescriptor)containing).getInternalName() : null;
        String innerName = DescriptorUtils.isClassObject(innerClass) ? "object" : (innerClass.getName().isSpecial() ? null : innerClass.getName().asString());
        String innerClassInternalName = this.typeMapper.mapClass(innerClass).getInternalName();
        this.v.visitInnerClass(innerClassInternalName, outerClassInternalName, innerName, AsmUtil.calculateInnerClassAccessFlags(innerClass));
    }

    @NotNull
    private JvmClassSignature signature() {
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.CLASS);
        this.typeMapper.writeFormalTypeParameters(this.descriptor.getTypeConstructor().getParameters(), sw);
        sw.writeSuperclass();
        if (this.superClassType == null) {
            sw.writeClassBegin(this.superClassAsmType);
            sw.writeClassEnd();
        } else {
            this.typeMapper.mapSupertype(this.superClassType, sw);
        }
        sw.writeSuperclassEnd();
        ArrayList<JetType> interfaceSupertypes = Lists.newArrayList();
        boolean explicitKObject = false;
        for (JetDelegationSpecifier specifier : this.myClass.getDelegationSpecifiers()) {
            ClassDescriptor superClassDescriptor;
            JetType superType = this.bindingContext.get(BindingContext.TYPE, specifier.getTypeReference());
            assert (superType != null) : "No supertype for class: " + this.myClass.getText();
            ClassifierDescriptor classifierDescriptor = superType.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor) || !JvmCodegenUtil.isInterface(superClassDescriptor = (ClassDescriptor)classifierDescriptor)) continue;
            interfaceSupertypes.add(superType);
            if (!JvmAbi.K_OBJECT.equalsTo(DescriptorUtils.getFqName(superClassDescriptor))) continue;
            explicitKObject = true;
        }
        LinkedHashSet<String> superInterfaces = new LinkedHashSet<String>();
        if (!explicitKObject && !JvmCodegenUtil.isInterface(this.descriptor)) {
            Type kObject = AsmUtil.asmTypeByFqNameWithoutInnerClasses(JvmAbi.K_OBJECT);
            sw.writeInterface();
            sw.writeClassBegin(kObject);
            sw.writeClassEnd();
            sw.writeInterfaceEnd();
            superInterfaces.add(kObject.getInternalName());
        }
        for (JetType supertype : interfaceSupertypes) {
            sw.writeInterface();
            Type jvmName = this.typeMapper.mapSupertype(supertype, sw);
            sw.writeInterfaceEnd();
            superInterfaces.add(jvmName.getInternalName());
        }
        JvmClassSignature jvmClassSignature = new JvmClassSignature(this.classAsmType.getInternalName(), this.superClassAsmType.getInternalName(), new ArrayList<String>(superInterfaces), sw.makeJavaGenericSignature());
        if (jvmClassSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "signature"));
        }
        return jvmClassSignature;
    }

    protected void getSuperClass() {
        this.superClassAsmType = AsmTypeConstants.OBJECT_TYPE;
        this.superClassType = null;
        List<JetDelegationSpecifier> delegationSpecifiers = this.myClass.getDelegationSpecifiers();
        if (this.myClass instanceof JetClass && ((JetClass)this.myClass).isTrait()) {
            return;
        }
        for (JetDelegationSpecifier specifier : delegationSpecifiers) {
            ClassDescriptor superClassDescriptor;
            if (!(specifier instanceof JetDelegatorToSuperCall)) continue;
            JetType superType = this.bindingContext.get(BindingContext.TYPE, specifier.getTypeReference());
            assert (superType != null) : String.format("No type recorded for \n---\n%s\n---\n", JetPsiUtil.getElementTextWithContext(specifier));
            ClassifierDescriptor classifierDescriptor = superType.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor) || JvmCodegenUtil.isInterface(superClassDescriptor = (ClassDescriptor)classifierDescriptor)) continue;
            this.superClassType = superType;
            this.superClassAsmType = this.typeMapper.mapClass(superClassDescriptor);
            this.superCall = (JetDelegatorToSuperCall)specifier;
        }
        if (this.superClassType == null) {
            if (this.descriptor.getKind() == ClassKind.ENUM_CLASS) {
                this.superClassType = KotlinBuiltIns.getInstance().getEnumType(this.descriptor.getDefaultType());
                this.superClassAsmType = this.typeMapper.mapType(this.superClassType);
            }
            if (this.descriptor.getKind() == ClassKind.ENUM_ENTRY) {
                this.superClassType = this.descriptor.getTypeConstructor().getSupertypes().iterator().next();
                this.superClassAsmType = this.typeMapper.mapType(this.superClassType);
            }
        }
    }

    @Override
    protected void generateSyntheticParts() {
        this.generatePropertyMetadataArrayFieldIfNeeded(this.classAsmType);
        this.generateFieldForSingleton();
        this.generateClassObjectBackingFieldCopies();
        DelegationFieldsInfo delegationFieldsInfo = this.getDelegationFieldsInfo(this.myClass.getDelegationSpecifiers());
        try {
            this.generatePrimaryConstructor(delegationFieldsInfo);
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error generating primary constructor of class " + this.myClass.getName() + " with kind " + (Object)((Object)this.kind), e);
        }
        this.generateTraitMethods();
        this.generateDelegates(delegationFieldsInfo);
        this.generateSyntheticAccessors();
        this.generateEnumMethodsAndConstInitializers();
        this.generateFunctionsForDataClasses();
        this.generateBuiltinMethodStubs();
        this.generateToArray();
        AsmUtil.genClosureFields(this.context.closure, this.v, this.typeMapper);
    }

    private void generateReflectionObjectFieldIfNeeded() {
        if (DescriptorUtils.isAnnotationClass(this.descriptor)) {
            return;
        }
        ImplementationBodyCodegen.generateReflectionObjectField(this.state, this.classAsmType, this.v, AsmUtil.method("kClassFromKotlin", AsmTypeConstants.K_CLASS_IMPL_TYPE, AsmTypeConstants.getType(Class.class)), "$kotlinClass", this.createOrGetClInitCodegen().v);
    }

    private boolean isGenericToArrayPresent() {
        Collection<FunctionDescriptor> functions2 = this.descriptor.getDefaultType().getMemberScope().getFunctions(Name.identifier("toArray"));
        for (FunctionDescriptor function : functions2) {
            if (CallResolverUtil.isOrOverridesSynthesized(function) || function.getValueParameters().size() != 1 || function.getTypeParameters().size() != 1) continue;
            JetType arrayType = KotlinBuiltIns.getInstance().getArrayType(function.getTypeParameters().get(0).getDefaultType());
            JetType returnType = function.getReturnType();
            assert (returnType != null) : function.toString();
            JetType paramType = function.getValueParameters().get(0).getType();
            if (!JetTypeChecker.DEFAULT.equalTypes(arrayType, returnType) || !JetTypeChecker.DEFAULT.equalTypes(arrayType, paramType)) continue;
            return true;
        }
        return false;
    }

    private void generateToArray() {
        InstructionAdapter iv;
        MethodVisitor mv;
        int access;
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        if (!DescriptorUtils.isSubclass(this.descriptor, builtIns.getCollection())) {
            return;
        }
        int n = access = this.descriptor.getKind() == ClassKind.TRAIT ? 1025 : 1;
        if (CodegenUtil.getDeclaredFunctionByRawSignature(this.descriptor, Name.identifier("toArray"), builtIns.getArray(), new ClassifierDescriptor[0]) == null) {
            mv = this.v.newMethod(JvmDeclarationOrigin.NO_ORIGIN, access, "toArray", "()[Ljava/lang/Object;", null, null);
            if (this.descriptor.getKind() != ClassKind.TRAIT) {
                iv = new InstructionAdapter(mv);
                mv.visitCode();
                iv.load(0, this.classAsmType);
                iv.invokestatic("kotlin/jvm/internal/CollectionToArray", "toArray", "(Ljava/util/Collection;)[Ljava/lang/Object;", false);
                iv.areturn(Type.getObjectType("[Ljava/lang/Object;"));
                FunctionCodegen.endVisit(mv, "toArray", this.myClass);
            }
        }
        if (!this.isGenericToArrayPresent()) {
            mv = this.v.newMethod(JvmDeclarationOrigin.NO_ORIGIN, access, "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;", null, null);
            if (this.descriptor.getKind() != ClassKind.TRAIT) {
                iv = new InstructionAdapter(mv);
                mv.visitCode();
                iv.load(0, this.classAsmType);
                iv.load(1, Type.getObjectType("[Ljava/lang/Object;"));
                iv.invokestatic("kotlin/jvm/internal/CollectionToArray", "toArray", "(Ljava/util/Collection;[Ljava/lang/Object;)[Ljava/lang/Object;", false);
                iv.areturn(Type.getObjectType("[Ljava/lang/Object;"));
                FunctionCodegen.endVisit(mv, "toArray", this.myClass);
            }
        }
    }

    private void generateBuiltinMethodStubs() {
        ClassifierDescriptor classifier2;
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        MethodStubGenerator methodStubs = new MethodStubGenerator();
        if (DescriptorUtils.isSubclass(this.descriptor, builtIns.getCollection())) {
            classifier2 = this.getSubstituteForTypeParameterOf(builtIns.getCollection(), 0);
            methodStubs.generate("add", "(Ljava/lang/Object;)Z", builtIns.getBoolean(), classifier2);
            methodStubs.generate("remove", "(Ljava/lang/Object;)Z", builtIns.getBoolean(), builtIns.getAny());
            methodStubs.generate("addAll", "(Ljava/util/Collection;)Z", builtIns.getBoolean(), builtIns.getCollection());
            methodStubs.generate("removeAll", "(Ljava/util/Collection;)Z", builtIns.getBoolean(), builtIns.getCollection());
            methodStubs.generate("retainAll", "(Ljava/util/Collection;)Z", builtIns.getBoolean(), builtIns.getCollection());
            methodStubs.generate("clear", "()V", builtIns.getUnit(), new ClassifierDescriptor[0]);
        }
        if (DescriptorUtils.isSubclass(this.descriptor, builtIns.getList())) {
            classifier2 = this.getSubstituteForTypeParameterOf(builtIns.getList(), 0);
            methodStubs.generate("set", "(ILjava/lang/Object;)Ljava/lang/Object;", classifier2, builtIns.getInt(), classifier2);
            methodStubs.generate("add", "(ILjava/lang/Object;)V", builtIns.getUnit(), builtIns.getInt(), classifier2);
            methodStubs.generate("remove", "(I)Ljava/lang/Object;", classifier2, builtIns.getInt());
        }
        if (DescriptorUtils.isSubclass(this.descriptor, builtIns.getMap())) {
            ClassifierDescriptor keyClassifier = this.getSubstituteForTypeParameterOf(builtIns.getMap(), 0);
            ClassifierDescriptor valueClassifier = this.getSubstituteForTypeParameterOf(builtIns.getMap(), 1);
            methodStubs.generate("put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", valueClassifier, keyClassifier, valueClassifier);
            methodStubs.generate("remove", "(Ljava/lang/Object;)Ljava/lang/Object;", valueClassifier, builtIns.getAny());
            methodStubs.generate("putAll", "(Ljava/util/Map;)V", builtIns.getUnit(), builtIns.getMap());
            methodStubs.generate("clear", "()V", builtIns.getUnit(), new ClassifierDescriptor[0]);
        }
        if (DescriptorUtils.isSubclass(this.descriptor, builtIns.getMapEntry())) {
            ClassifierDescriptor valueClassifier = this.getSubstituteForTypeParameterOf(builtIns.getMapEntry(), 1);
            methodStubs.generate("setValue", "(Ljava/lang/Object;)Ljava/lang/Object;", valueClassifier, valueClassifier);
        }
        if (DescriptorUtils.isSubclass(this.descriptor, builtIns.getIterator())) {
            methodStubs.generate("remove", "()V", builtIns.getUnit(), new ClassifierDescriptor[0]);
        }
    }

    @NotNull
    private ClassifierDescriptor getSubstituteForTypeParameterOf(@NotNull ClassDescriptor trait, int index) {
        if (trait == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trait", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "getSubstituteForTypeParameterOf"));
        }
        TypeParameterDescriptor listTypeParameter = trait.getTypeConstructor().getParameters().get(index);
        TypeSubstitutor deepSubstitutor = SubstitutionUtils.buildDeepSubstitutor(this.descriptor.getDefaultType());
        TypeProjection substitute = deepSubstitutor.substitute(new TypeProjectionImpl(listTypeParameter.getDefaultType()));
        assert (substitute != null) : "Couldn't substitute: " + this.descriptor;
        ClassifierDescriptor classifier2 = substitute.getType().getConstructor().getDeclarationDescriptor();
        assert (classifier2 != null) : "No classifier: " + substitute.getType();
        ClassifierDescriptor classifierDescriptor = classifier2;
        if (classifierDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "getSubstituteForTypeParameterOf"));
        }
        return classifierDescriptor;
    }

    private void generateFunctionsForDataClasses() {
        if (!KotlinBuiltIns.getInstance().isData(this.descriptor)) {
            return;
        }
        new DataClassMethodGeneratorImpl(this.myClass, this.bindingContext).generate();
    }

    private void generateEnumMethodsAndConstInitializers() {
        if (DescriptorUtils.isEnumClass(this.descriptor)) {
            this.generateEnumValuesMethod();
            this.generateEnumValueOfMethod();
            this.initializeEnumConstants();
        }
    }

    private void generateEnumValuesMethod() {
        Type type = this.typeMapper.mapType(KotlinBuiltIns.getInstance().getArrayType(this.descriptor.getDefaultType()));
        FunctionDescriptor valuesFunction = KotlinPackage.single(this.descriptor.getStaticScope().getFunctions(DescriptorUtils.ENUM_VALUES), new Function1<FunctionDescriptor, Boolean>(){

            @Override
            public Boolean invoke(FunctionDescriptor descriptor) {
                return CodegenUtil.isEnumValuesMethod(descriptor);
            }
        });
        MethodVisitor mv = this.v.newMethod(DiagnosticsPackage.OtherOrigin(this.myClass, valuesFunction), 9, DescriptorUtils.ENUM_VALUES.asString(), "()" + type.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        mv.visitCode();
        mv.visitFieldInsn(178, this.classAsmType.getInternalName(), "$VALUES", type.getDescriptor());
        mv.visitMethodInsn(182, type.getInternalName(), "clone", "()Ljava/lang/Object;", false);
        mv.visitTypeInsn(192, type.getInternalName());
        mv.visitInsn(176);
        FunctionCodegen.endVisit(mv, "values()", this.myClass);
    }

    private void generateEnumValueOfMethod() {
        FunctionDescriptor valueOfFunction = KotlinPackage.single(this.descriptor.getStaticScope().getFunctions(DescriptorUtils.ENUM_VALUE_OF), new Function1<FunctionDescriptor, Boolean>(){

            @Override
            public Boolean invoke(FunctionDescriptor descriptor) {
                return CodegenUtil.isEnumValueOfMethod(descriptor);
            }
        });
        MethodVisitor mv = this.v.newMethod(DiagnosticsPackage.OtherOrigin(this.myClass, valueOfFunction), 9, DescriptorUtils.ENUM_VALUE_OF.asString(), "(Ljava/lang/String;)" + this.classAsmType.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        mv.visitCode();
        mv.visitLdcInsn(this.classAsmType);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "java/lang/Enum", "valueOf", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;", false);
        mv.visitTypeInsn(192, this.classAsmType.getInternalName());
        mv.visitInsn(176);
        FunctionCodegen.endVisit(mv, "valueOf()", this.myClass);
    }

    protected void generateSyntheticAccessors() {
        Map<DeclarationDescriptor, DeclarationDescriptor> accessors = this.context.getAccessors();
        for (Map.Entry<DeclarationDescriptor, DeclarationDescriptor> entry : accessors.entrySet()) {
            this.generateSyntheticAccessor(entry);
        }
    }

    private void generateSyntheticAccessor(Map.Entry<DeclarationDescriptor, DeclarationDescriptor> entry) {
        if (entry.getValue() instanceof FunctionDescriptor) {
            FunctionDescriptor bridge = (FunctionDescriptor)entry.getValue();
            final FunctionDescriptor original = (FunctionDescriptor)entry.getKey();
            this.functionCodegen.generateMethod(DiagnosticsPackage.Synthetic(null, original), this.typeMapper.mapSignature(bridge), bridge, new FunctionGenerationStrategy.CodegenBased<FunctionDescriptor>(this.state, bridge){

                @Override
                public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                    if (codegen == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$3", "doGenerateBody"));
                    }
                    if (signature == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$3", "doGenerateBody"));
                    }
                    ImplementationBodyCodegen.this.generateMethodCallTo(original, codegen.v);
                    codegen.v.areturn(signature.getReturnType());
                }
            });
        } else if (entry.getValue() instanceof PropertyDescriptor) {
            final PropertyDescriptor bridge = (PropertyDescriptor)entry.getValue();
            final PropertyDescriptor original = (PropertyDescriptor)entry.getKey();
            PropertyGetterDescriptor getter = bridge.getGetter();
            assert (getter != null);
            class PropertyAccessorStrategy
            extends FunctionGenerationStrategy.CodegenBased<PropertyAccessorDescriptor> {
                public PropertyAccessorStrategy(PropertyAccessorDescriptor callableDescriptor) {
                    if (propertyDescriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$1PropertyAccessorStrategy", "<init>"));
                    }
                    super(ImplementationBodyCodegen.this.state, callableDescriptor);
                }

                @Override
                public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                    if (codegen == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$1PropertyAccessorStrategy", "doGenerateBody"));
                    }
                    if (signature == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$1PropertyAccessorStrategy", "doGenerateBody"));
                    }
                    boolean forceField = AsmUtil.isPropertyWithBackingFieldInOuterClass(original) && !DescriptorUtils.isClassObject(bridge.getContainingDeclaration());
                    StackValue.Property property2 = codegen.intermediateValueForProperty(original, forceField, null, MethodKind.SYNTHETIC_ACCESSOR);
                    InstructionAdapter iv = codegen.v;
                    Type[] argTypes = signature.getAsmMethod().getArgumentTypes();
                    int reg = 0;
                    for (int i = 0; i < argTypes.length; ++i) {
                        Type argType = argTypes[i];
                        iv.load(reg, argType);
                        reg += argType.getSize();
                    }
                    if (this.callableDescriptor instanceof PropertyGetterDescriptor) {
                        ((StackValue)property2).put(property2.type, iv);
                    } else {
                        ((StackValue)property2).store(property2.type, iv);
                    }
                    iv.areturn(signature.getReturnType());
                }
            }
            this.functionCodegen.generateMethod(DiagnosticsPackage.Synthetic(null, original.getGetter() != null ? original.getGetter() : original), this.typeMapper.mapSignature(getter), getter, new PropertyAccessorStrategy(getter));
            if (bridge.isVar()) {
                PropertySetterDescriptor setter = bridge.getSetter();
                assert (setter != null);
                this.functionCodegen.generateMethod(DiagnosticsPackage.Synthetic(null, original.getSetter() != null ? original.getSetter() : original), this.typeMapper.mapSignature(setter), setter, new PropertyAccessorStrategy(setter));
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void generateMethodCallTo(FunctionDescriptor functionDescriptor, InstructionAdapter iv) {
        boolean isConstructor = functionDescriptor instanceof ConstructorDescriptor;
        boolean callFromAccessor = !JetTypeMapper.isAccessor(functionDescriptor);
        CallableMethod callableMethod = isConstructor ? this.typeMapper.mapToCallableMethod((ConstructorDescriptor)functionDescriptor) : this.typeMapper.mapToCallableMethod(functionDescriptor, callFromAccessor, this.context);
        int reg = 1;
        if (isConstructor) {
            iv.anew(callableMethod.getOwner());
            iv.dup();
            reg = 0;
        } else if (callFromAccessor) {
            iv.load(0, AsmTypeConstants.OBJECT_TYPE);
        }
        for (Type argType : callableMethod.getAsmMethod().getArgumentTypes()) {
            iv.load(reg, argType);
            reg += argType.getSize();
        }
        callableMethod.invokeWithoutAssertions(iv);
    }

    private void generateFieldForSingleton() {
        ClassDescriptor fieldTypeDescriptor;
        JetClassOrObject original;
        if (DescriptorUtils.isEnumEntry(this.descriptor)) {
            return;
        }
        ClassDescriptor classObjectDescriptor = this.descriptor.getClassObjectDescriptor();
        if (DescriptorUtils.isObject(this.descriptor)) {
            original = this.myClass;
            fieldTypeDescriptor = this.descriptor;
        } else if (classObjectDescriptor != null) {
            JetClassObject classObject = ((JetClass)this.myClass).getClassObject();
            assert (classObject != null) : "Class object not found: " + this.myClass.getText();
            original = classObject.getObjectDeclaration();
            fieldTypeDescriptor = classObjectDescriptor;
        } else {
            return;
        }
        StackValue.Field field = StackValue.singleton(fieldTypeDescriptor, this.typeMapper);
        this.v.newField(DiagnosticsPackage.OtherOrigin(original), 25, field.name, field.type.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        if (DescriptorUtils.isObject(this.descriptor)) {
            InstructionAdapter v = this.createOrGetClInitCodegen().v;
            v.anew(this.classAsmType);
            v.invokespecial(this.classAsmType.getInternalName(), "<init>", "()V", false);
        } else if (!AsmUtil.isClassObjectWithBackingFieldsInOuter(fieldTypeDescriptor)) {
            this.generateClassObjectInitializer(fieldTypeDescriptor);
        }
    }

    private void generateClassObjectBackingFieldCopies() {
        if (this.classObjectPropertiesToCopy == null) {
            return;
        }
        for (PropertyAndDefaultValue info : this.classObjectPropertiesToCopy) {
            PropertyDescriptor property2 = info.descriptor;
            Type type = this.typeMapper.mapType(property2);
            FieldVisitor fv = this.v.newField(DiagnosticsPackage.OtherOrigin(property2), 25, this.context.getFieldName(property2, false), type.getDescriptor(), this.typeMapper.mapFieldSignature(property2.getType()), info.defaultValue);
            AnnotationCodegen.forField(fv, this.typeMapper).genAnnotations(property2, type);
            if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL || info.defaultValue != null) continue;
            ExpressionCodegen codegen = this.createOrGetClInitCodegen();
            int classObjectIndex = this.putClassObjectInLocalVar(codegen);
            StackValue.local(classObjectIndex, AsmTypeConstants.OBJECT_TYPE).put(AsmTypeConstants.OBJECT_TYPE, codegen.v);
            this.copyFieldFromClassObject(property2);
        }
    }

    private int putClassObjectInLocalVar(ExpressionCodegen codegen) {
        FrameMap frameMap = codegen.myFrameMap;
        ClassDescriptor classObjectDescriptor = this.descriptor.getClassObjectDescriptor();
        int classObjectIndex = frameMap.getIndex(classObjectDescriptor);
        if (classObjectIndex == -1) {
            classObjectIndex = frameMap.enter(classObjectDescriptor, AsmTypeConstants.OBJECT_TYPE);
            StackValue.Field classObject = StackValue.singleton(classObjectDescriptor, this.typeMapper);
            ((StackValue)classObject).put(classObject.type, codegen.v);
            StackValue.local(classObjectIndex, classObject.type).store(classObject.type, codegen.v);
        }
        return classObjectIndex;
    }

    private void copyFieldFromClassObject(PropertyDescriptor propertyDescriptor) {
        ExpressionCodegen codegen = this.createOrGetClInitCodegen();
        StackValue.Property property2 = codegen.intermediateValueForProperty(propertyDescriptor, false, null);
        ((StackValue)property2).put(property2.type, codegen.v);
        StackValue.Field field = StackValue.field(property2.type, this.classAsmType, propertyDescriptor.getName().asString(), true);
        field.store(field.type, codegen.v);
    }

    private void generateClassObjectInitializer(@NotNull ClassDescriptor classObject) {
        if (classObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObject", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateClassObjectInitializer"));
        }
        ExpressionCodegen codegen = this.createOrGetClInitCodegen();
        FunctionDescriptor constructor = codegen.accessibleFunctionDescriptor(KotlinPackage.single(classObject.getConstructors()));
        this.generateMethodCallTo(constructor, codegen.v);
        StackValue.singleton(classObject, this.typeMapper).store(this.typeMapper.mapClass(classObject), codegen.v);
    }

    private void generatePrimaryConstructor(final DelegationFieldsInfo delegationFieldsInfo) {
        if (this.ignoreIfTraitOrAnnotation()) {
            return;
        }
        ConstructorDescriptor constructorDescriptor = this.bindingContext.get(BindingContext.CONSTRUCTOR, this.myClass);
        assert (constructorDescriptor != null) : "Constructor not found for class: " + this.descriptor;
        ConstructorContext constructorContext = this.context.intoConstructor(constructorDescriptor);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            this.lookupConstructorExpressionsInClosureIfPresent(constructorContext);
        }
        JvmMethodSignature signature = this.typeMapper.mapSignature(constructorDescriptor);
        this.functionCodegen.generateMethod(DiagnosticsPackage.OtherOrigin(this.myClass, constructorDescriptor), signature, constructorDescriptor, constructorContext, new FunctionGenerationStrategy.CodegenBased<ConstructorDescriptor>(this.state, constructorDescriptor){

            @Override
            public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                if (codegen == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$4", "doGenerateBody"));
                }
                if (signature == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$4", "doGenerateBody"));
                }
                ImplementationBodyCodegen.this.generatePrimaryConstructorImpl((ConstructorDescriptor)this.callableDescriptor, codegen, delegationFieldsInfo);
            }
        });
        this.functionCodegen.generateDefaultIfNeeded(constructorContext, signature, constructorDescriptor, OwnerKind.IMPLEMENTATION, DefaultParameterValueLoader.DEFAULT, null);
        CallableMethod callableMethod = this.typeMapper.mapToCallableMethod(constructorDescriptor);
        FunctionCodegen.generateConstructorWithoutParametersIfNeeded(this.state, callableMethod, constructorDescriptor, this.v);
        if (DescriptorUtils.isClassObject(this.descriptor)) {
            this.context.recordSyntheticAccessorIfNeeded(constructorDescriptor, this.bindingContext);
        }
    }

    private void generatePrimaryConstructorImpl(@NotNull ConstructorDescriptor constructorDescriptor, final @NotNull ExpressionCodegen codegen, @NotNull DelegationFieldsInfo fieldsInfo) {
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generatePrimaryConstructorImpl"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generatePrimaryConstructorImpl"));
        }
        if (fieldsInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldsInfo", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generatePrimaryConstructorImpl"));
        }
        InstructionAdapter iv = codegen.v;
        MutableClosure closure = this.context.closure;
        if (closure != null) {
            List<FieldInfo> argsFromClosure = ClosureCodegen.calculateConstructorParameters(this.typeMapper, closure, this.classAsmType);
            int k = 1;
            for (FieldInfo info : argsFromClosure) {
                k = AsmUtil.genAssignInstanceFieldFromParam(info, k, iv);
            }
        }
        if (this.superCall == null) {
            this.genSimpleSuperCall(iv);
        } else {
            this.generateDelegatorToConstructorCall(iv, codegen, constructorDescriptor);
        }
        if (DescriptorUtils.isObject(this.descriptor)) {
            iv.load(0, this.classAsmType);
            StackValue.singleton(this.descriptor, this.typeMapper).store(this.classAsmType, iv);
        }
        for (JetDelegationSpecifier specifier : this.myClass.getDelegationSpecifiers()) {
            if (!(specifier instanceof JetDelegatorByExpressionSpecifier)) continue;
            this.genCallToDelegatorByExpressionSpecifier(iv, codegen, (JetDelegatorByExpressionSpecifier)specifier, fieldsInfo);
        }
        int curParam = 0;
        List<ValueParameterDescriptor> parameters = constructorDescriptor.getValueParameters();
        for (JetParameter parameter : this.getPrimaryConstructorParameters()) {
            if (parameter.hasValOrVarNode()) {
                VariableDescriptor descriptor = parameters.get(curParam);
                Type type = this.typeMapper.mapType(descriptor);
                iv.load(0, this.classAsmType);
                iv.load(codegen.myFrameMap.getIndex(descriptor), type);
                PropertyDescriptor propertyDescriptor = this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
                assert (propertyDescriptor != null) : "Property descriptor is not found for primary constructor parameter: " + parameter;
                iv.putfield(this.classAsmType.getInternalName(), this.context.getFieldName(propertyDescriptor, false), type.getDescriptor());
            }
            ++curParam;
        }
        if (AsmUtil.isClassObjectWithBackingFieldsInOuter(this.descriptor)) {
            final ImplementationBodyCodegen parentCodegen = JvmCodegenUtil.getParentBodyCodegen(this);
            parentCodegen.generateClassObjectInitializer(this.descriptor);
            this.generateInitializers(new Function0<ExpressionCodegen>(){

                @Override
                public ExpressionCodegen invoke() {
                    return parentCodegen.createOrGetClInitCodegen();
                }
            });
        } else {
            this.generateInitializers(new Function0<ExpressionCodegen>(){

                @Override
                public ExpressionCodegen invoke() {
                    return codegen;
                }
            });
        }
        iv.visitInsn(177);
    }

    private void genSimpleSuperCall(InstructionAdapter iv) {
        iv.load(0, this.superClassAsmType);
        if (this.descriptor.getKind() == ClassKind.ENUM_CLASS || this.descriptor.getKind() == ClassKind.ENUM_ENTRY) {
            iv.load(1, AsmTypeConstants.JAVA_STRING_TYPE);
            iv.load(2, Type.INT_TYPE);
            iv.invokespecial(this.superClassAsmType.getInternalName(), "<init>", "(Ljava/lang/String;I)V", false);
        } else {
            iv.invokespecial(this.superClassAsmType.getInternalName(), "<init>", "()V", false);
        }
    }

    @NotNull
    private DelegationFieldsInfo getDelegationFieldsInfo(@NotNull List<JetDelegationSpecifier> delegationSpecifiers) {
        if (delegationSpecifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegationSpecifiers", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "getDelegationFieldsInfo"));
        }
        DelegationFieldsInfo result2 = new DelegationFieldsInfo();
        int n = 0;
        for (JetDelegationSpecifier specifier : delegationSpecifiers) {
            if (!(specifier instanceof JetDelegatorByExpressionSpecifier)) continue;
            JetExpression expression = ((JetDelegatorByExpressionSpecifier)specifier).getDelegateExpression();
            PropertyDescriptor propertyDescriptor = CodegenUtil.getDelegatePropertyIfAny(expression, this.descriptor, this.bindingContext);
            ClassDescriptor superClassDescriptor = this.getSuperClass(specifier);
            if (CodegenUtil.isFinalPropertyWithBackingField(propertyDescriptor, this.bindingContext)) {
                result2.addField((JetDelegatorByExpressionSpecifier)specifier, propertyDescriptor);
            } else {
                result2.addField((JetDelegatorByExpressionSpecifier)specifier, this.typeMapper.mapType(superClassDescriptor), "$delegate_" + n);
            }
            ++n;
        }
        DelegationFieldsInfo delegationFieldsInfo = result2;
        if (delegationFieldsInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "getDelegationFieldsInfo"));
        }
        return delegationFieldsInfo;
    }

    @NotNull
    private ClassDescriptor getSuperClass(@NotNull JetDelegationSpecifier specifier) {
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "getSuperClass"));
        }
        ClassDescriptor classDescriptor = CodegenUtil.getSuperClassByDelegationSpecifier(specifier, this.bindingContext);
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "getSuperClass"));
        }
        return classDescriptor;
    }

    private void genCallToDelegatorByExpressionSpecifier(InstructionAdapter iv, ExpressionCodegen codegen, JetDelegatorByExpressionSpecifier specifier, DelegationFieldsInfo fieldsInfo) {
        JetExpression expression = specifier.getDelegateExpression();
        DelegationFieldsInfo.Field fieldInfo = fieldsInfo.getInfo(specifier);
        if (fieldInfo.generateField) {
            iv.load(0, this.classAsmType);
            codegen.genToJVMStack(expression);
            fieldInfo.getStackValue().store(fieldInfo.type, iv);
        }
    }

    private void lookupConstructorExpressionsInClosureIfPresent(final ConstructorContext constructorContext) {
        JetValueArgumentList argumentList;
        JetVisitorVoid visitor = new JetVisitorVoid(){

            @Override
            public void visitJetElement(@NotNull JetElement e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$7", "visitJetElement"));
                }
                e.acceptChildren(this);
            }

            @Override
            public void visitSimpleNameExpression(@NotNull JetSimpleNameExpression expr) {
                DeclarationDescriptor toLookup;
                if (expr == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$7", "visitSimpleNameExpression"));
                }
                DeclarationDescriptor descriptor = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.REFERENCE_TARGET, expr);
                if (CodegenBinding.isLocalNamedFun(descriptor)) {
                    toLookup = descriptor;
                } else if (descriptor instanceof CallableMemberDescriptor) {
                    toLookup = descriptor.getContainingDeclaration();
                } else if (descriptor instanceof VariableDescriptor) {
                    ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)constructorContext.getContextDescriptor();
                    for (ValueParameterDescriptor parameterDescriptor : constructorDescriptor.getValueParameters()) {
                        if (!descriptor.equals(parameterDescriptor)) continue;
                        return;
                    }
                    toLookup = descriptor;
                } else {
                    return;
                }
                constructorContext.lookupInContext(toLookup, null, ImplementationBodyCodegen.this.state, true);
            }

            @Override
            public void visitThisExpression(@NotNull JetThisExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$7", "visitThisExpression"));
                }
                DeclarationDescriptor descriptor = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getInstanceReference());
                assert (descriptor instanceof CallableDescriptor || descriptor instanceof ClassDescriptor) : "'This' reference target should be class or callable descriptor but was " + descriptor;
                if (ImplementationBodyCodegen.this.context.getCallableDescriptorWithReceiver() != descriptor) {
                    ImplementationBodyCodegen.this.context.lookupInContext(descriptor, null, ImplementationBodyCodegen.this.state, true);
                }
            }
        };
        for (JetDeclaration declaration : this.myClass.getDeclarations()) {
            if (declaration instanceof JetProperty) {
                JetProperty property2 = (JetProperty)declaration;
                JetExpression initializer = property2.getInitializer();
                if (initializer == null) continue;
                initializer.accept(visitor);
                continue;
            }
            if (!(declaration instanceof JetClassInitializer)) continue;
            JetClassInitializer initializer = (JetClassInitializer)declaration;
            initializer.accept(visitor);
        }
        for (JetDelegationSpecifier specifier : this.myClass.getDelegationSpecifiers()) {
            if (!(specifier instanceof JetDelegatorByExpressionSpecifier)) continue;
            JetExpression delegateExpression = ((JetDelegatorByExpressionSpecifier)specifier).getDelegateExpression();
            assert (delegateExpression != null);
            delegateExpression.accept(visitor);
        }
        if (this.superCall != null && !DescriptorUtils.isAnonymousObject(this.descriptor) && (argumentList = this.superCall.getValueArgumentList()) != null) {
            argumentList.accept(visitor);
        }
    }

    private boolean ignoreIfTraitOrAnnotation() {
        if (this.myClass instanceof JetClass) {
            JetClass aClass = (JetClass)this.myClass;
            if (aClass.isTrait()) {
                return true;
            }
            if (aClass.isAnnotation()) {
                return true;
            }
        }
        return false;
    }

    private void generateTraitMethods() {
        if (JetPsiUtil.isTrait(this.myClass)) {
            return;
        }
        for (DeclarationDescriptor declaration : this.descriptor.getDefaultType().getMemberScope().getAllDescriptors()) {
            CallableMemberDescriptor inheritedMember;
            CallableMemberDescriptor traitMember;
            if (!(declaration instanceof CallableMemberDescriptor) || (traitMember = BridgesPackage.findTraitImplementation(inheritedMember = (CallableMemberDescriptor)declaration)) == null) continue;
            assert (traitMember.getModality() != Modality.ABSTRACT) : "Cannot delegate to abstract trait method: " + inheritedMember;
            CallableMemberDescriptor copy = inheritedMember.copy(inheritedMember.getContainingDeclaration(), traitMember.getModality(), Visibilities.PUBLIC, CallableMemberDescriptor.Kind.DECLARATION, true);
            if (traitMember instanceof SimpleFunctionDescriptor) {
                this.generateDelegationToTraitImpl((FunctionDescriptor)traitMember, (FunctionDescriptor)copy);
                continue;
            }
            if (!(traitMember instanceof PropertyDescriptor)) continue;
            for (PropertyAccessorDescriptor traitAccessor : ((PropertyDescriptor)traitMember).getAccessors()) {
                for (PropertyAccessorDescriptor inheritedAccessor : ((PropertyDescriptor)copy).getAccessors()) {
                    if (inheritedAccessor.getClass() != traitAccessor.getClass()) continue;
                    this.generateDelegationToTraitImpl(traitAccessor, inheritedAccessor);
                }
            }
        }
    }

    private void generateDelegationToTraitImpl(final @NotNull FunctionDescriptor traitFun, @NotNull FunctionDescriptor inheritedFun) {
        if (traitFun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traitFun", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateDelegationToTraitImpl"));
        }
        if (inheritedFun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inheritedFun", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateDelegationToTraitImpl"));
        }
        this.functionCodegen.generateMethod(DiagnosticsPackage.DelegationToTraitImpl(DescriptorToSourceUtils.descriptorToDeclaration(traitFun), traitFun), this.typeMapper.mapSignature(inheritedFun), inheritedFun, new FunctionGenerationStrategy.CodegenBased<FunctionDescriptor>(this.state, inheritedFun){

            @Override
            public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                if (codegen == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$8", "doGenerateBody"));
                }
                if (signature == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$8", "doGenerateBody"));
                }
                DeclarationDescriptor containingDeclaration = traitFun.getContainingDeclaration();
                if (!DescriptorUtils.isTrait(containingDeclaration)) {
                    return;
                }
                ClassDescriptor containingTrait = (ClassDescriptor)containingDeclaration;
                Type traitImplType = ImplementationBodyCodegen.this.typeMapper.mapTraitImpl(containingTrait);
                Method traitMethod = ImplementationBodyCodegen.this.typeMapper.mapSignature(traitFun.getOriginal(), OwnerKind.TRAIT_IMPL).getAsmMethod();
                Type[] argTypes = signature.getAsmMethod().getArgumentTypes();
                Type[] originalArgTypes = traitMethod.getArgumentTypes();
                assert (originalArgTypes.length == argTypes.length + 1) : "Invalid trait implementation signature: " + signature + " vs " + traitMethod + " for " + traitFun;
                InstructionAdapter iv = codegen.v;
                iv.load(0, AsmTypeConstants.OBJECT_TYPE);
                int reg = 1;
                for (int i = 0; i < argTypes.length; ++i) {
                    StackValue.local(reg, argTypes[i]).put(originalArgTypes[i + 1], iv);
                    reg += argTypes[i].getSize();
                }
                if (KotlinBuiltIns.getInstance().isCloneable(containingTrait) && traitMethod.getName().equals("clone")) {
                    iv.invokespecial("java/lang/Object", "clone", "()Ljava/lang/Object;", false);
                } else {
                    iv.invokestatic(traitImplType.getInternalName(), traitMethod.getName(), traitMethod.getDescriptor(), false);
                }
                Type returnType = signature.getReturnType();
                StackValue.onStack(traitMethod.getReturnType()).put(returnType, iv);
                iv.areturn(returnType);
            }
        });
    }

    private void generateDelegatorToConstructorCall(@NotNull InstructionAdapter iv, @NotNull ExpressionCodegen codegen, @NotNull ConstructorDescriptor constructorDescriptor) {
        ArgumentGenerator argumentGenerator;
        if (iv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iv", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateDelegatorToConstructorCall"));
        }
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateDelegatorToConstructorCall"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "generateDelegatorToConstructorCall"));
        }
        iv.load(0, AsmTypeConstants.OBJECT_TYPE);
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCallWithAssert(this.superCall, this.bindingContext);
        ConstructorDescriptor superConstructor = (ConstructorDescriptor)resolvedCall.getResultingDescriptor();
        CallableMethod superCallable = this.typeMapper.mapToCallableMethod(superConstructor);
        CallableMethod callable2 = this.typeMapper.mapToCallableMethod(constructorDescriptor);
        List<JvmMethodParameterSignature> superParameters = superCallable.getValueParameters();
        List<JvmMethodParameterSignature> parameters = callable2.getValueParameters();
        int offset = 1;
        int superIndex = 0;
        for (JvmMethodParameterSignature parameter : parameters) {
            if (superIndex >= superParameters.size()) break;
            JvmMethodParameterKind kind = parameter.getKind();
            Type type = parameter.getAsmType();
            if (superParameters.get(superIndex).getKind() == JvmMethodParameterKind.VALUE && kind == JvmMethodParameterKind.SUPER_CALL_PARAM) break;
            if (kind == JvmMethodParameterKind.SUPER_CALL_PARAM || kind == JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL || kind == JvmMethodParameterKind.OUTER && superConstructor.getContainingDeclaration().isInner()) {
                iv.load(offset, type);
                ++superIndex;
            }
            offset += type.getSize();
        }
        if (DescriptorUtils.isAnonymousObject(this.descriptor)) {
            List<JvmMethodParameterSignature> superValues = superParameters.subList(superIndex, superParameters.size());
            argumentGenerator = new ObjectSuperCallArgumentGenerator(superValues, iv, offset);
        } else {
            argumentGenerator = new CallBasedArgumentGenerator(codegen, codegen.defaultCallGenerator, superConstructor.getValueParameters(), superCallable.getValueParameterTypes());
        }
        codegen.invokeMethodWithArguments(superCallable, resolvedCall, StackValue.none(), codegen.defaultCallGenerator, argumentGenerator);
    }

    @Override
    protected void generateDeclaration(PropertyCodegen propertyCodegen, JetDeclaration declaration) {
        if (declaration instanceof JetEnumEntry) {
            String name = declaration.getName();
            assert (name != null) : "Enum entry has no name: " + declaration.getText();
            ClassDescriptor entryDescriptor = this.bindingContext.get(BindingContext.CLASS, declaration);
            FieldVisitor fv = this.v.newField(DiagnosticsPackage.OtherOrigin(declaration, entryDescriptor), 16409, name, this.classAsmType.getDescriptor(), null, null);
            AnnotationCodegen.forField(fv, this.typeMapper).genAnnotations(entryDescriptor, null);
            this.myEnumConstants.add((JetEnumEntry)declaration);
        }
        super.generateDeclaration(propertyCodegen, declaration);
    }

    private void initializeEnumConstants() {
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        ExpressionCodegen codegen = this.createOrGetClInitCodegen();
        InstructionAdapter iv = codegen.v;
        Type arrayAsmType = this.typeMapper.mapType(KotlinBuiltIns.getInstance().getArrayType(this.descriptor.getDefaultType()));
        this.v.newField(DiagnosticsPackage.OtherOrigin(this.myClass), 4122, "$VALUES", arrayAsmType.getDescriptor(), null, null);
        iv.iconst(this.myEnumConstants.size());
        iv.newarray(this.classAsmType);
        if (!this.myEnumConstants.isEmpty()) {
            iv.dup();
            int size = this.myEnumConstants.size();
            for (int ordinal = 0; ordinal < size; ++ordinal) {
                this.initializeEnumConstant(codegen, ordinal);
            }
        }
        iv.putstatic(this.classAsmType.getInternalName(), "$VALUES", arrayAsmType.getDescriptor());
    }

    private void initializeEnumConstant(@NotNull ExpressionCodegen codegen, int ordinal) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/ImplementationBodyCodegen", "initializeEnumConstant"));
        }
        InstructionAdapter iv = codegen.v;
        JetEnumEntry enumConstant = this.myEnumConstants.get(ordinal);
        iv.dup();
        iv.iconst(ordinal);
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, enumConstant);
        assert (classDescriptor != null);
        Type implClass = this.typeMapper.mapClass(classDescriptor);
        List<JetDelegationSpecifier> delegationSpecifiers = enumConstant.getDelegationSpecifiers();
        if (delegationSpecifiers.size() > 1) {
            throw new UnsupportedOperationException("multiple delegation specifiers for enum constant not supported");
        }
        iv.anew(implClass);
        iv.dup();
        iv.aconst(enumConstant.getName());
        iv.iconst(ordinal);
        if (delegationSpecifiers.size() == 1 && !CodegenBinding.enumEntryNeedSubclass(this.state.getBindingContext(), enumConstant)) {
            JetDelegationSpecifier specifier = delegationSpecifiers.get(0);
            if (!(specifier instanceof JetDelegatorToSuperCall)) {
                throw new UnsupportedOperationException("unsupported type of enum constant initializer: " + specifier);
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCallWithAssert(specifier, this.bindingContext);
            CallableMethod method = this.typeMapper.mapToCallableMethod((ConstructorDescriptor)resolvedCall.getResultingDescriptor());
            codegen.invokeMethodWithArguments(method, resolvedCall, StackValue.none());
        } else {
            iv.invokespecial(implClass.getInternalName(), "<init>", "(Ljava/lang/String;I)V", false);
        }
        iv.dup();
        iv.putstatic(this.classAsmType.getInternalName(), enumConstant.getName(), this.classAsmType.getDescriptor());
        iv.astore(AsmTypeConstants.OBJECT_TYPE);
    }

    private void generateDelegates(DelegationFieldsInfo delegationFieldsInfo) {
        for (JetDelegationSpecifier specifier : this.myClass.getDelegationSpecifiers()) {
            if (!(specifier instanceof JetDelegatorByExpressionSpecifier)) continue;
            DelegationFieldsInfo.Field field = delegationFieldsInfo.getInfo((JetDelegatorByExpressionSpecifier)specifier);
            this.generateDelegateField(field);
            this.generateDelegates(this.getSuperClass(specifier), field);
        }
    }

    private void generateDelegateField(DelegationFieldsInfo.Field fieldInfo) {
        if (!fieldInfo.generateField) {
            return;
        }
        this.v.newField(JvmDeclarationOrigin.NO_ORIGIN, 4114, fieldInfo.name, fieldInfo.type.getDescriptor(), null, null);
    }

    protected void generateDelegates(ClassDescriptor toClass, DelegationFieldsInfo.Field field) {
        for (Map.Entry<CallableMemberDescriptor, CallableMemberDescriptor> entry : CodegenUtil.getDelegates(this.descriptor, toClass).entrySet()) {
            CallableMemberDescriptor callableMemberDescriptor = entry.getKey();
            CallableMemberDescriptor overriddenDescriptor = entry.getValue();
            if (callableMemberDescriptor instanceof PropertyDescriptor) {
                this.propertyCodegen.genDelegate((PropertyDescriptor)callableMemberDescriptor, (PropertyDescriptor)overriddenDescriptor, field.getStackValue());
                continue;
            }
            if (!(callableMemberDescriptor instanceof FunctionDescriptor)) continue;
            this.functionCodegen.genDelegate((FunctionDescriptor)callableMemberDescriptor, (FunctionDescriptor)overriddenDescriptor, field.getStackValue());
        }
    }

    public void addClassObjectPropertyToCopy(PropertyDescriptor descriptor, Object defaultValue) {
        if (this.classObjectPropertiesToCopy == null) {
            this.classObjectPropertiesToCopy = new ArrayList<PropertyAndDefaultValue>();
        }
        this.classObjectPropertiesToCopy.add(new PropertyAndDefaultValue(descriptor, defaultValue));
    }

    @Override
    protected void done() {
        for (Function2<ImplementationBodyCodegen, ClassBuilder, Unit> task : this.additionalTasks) {
            task.invoke(this, this.v);
        }
        super.done();
    }

    public void addAdditionalTask(Function2<ImplementationBodyCodegen, ClassBuilder, Unit> additionalTask) {
        this.additionalTasks.add(additionalTask);
    }

    private static class PropertyAndDefaultValue {
        public final PropertyDescriptor descriptor;
        public final Object defaultValue;

        public PropertyAndDefaultValue(PropertyDescriptor descriptor, Object defaultValue) {
            this.descriptor = descriptor;
            this.defaultValue = defaultValue;
        }
    }

    private static class ObjectSuperCallArgumentGenerator
    extends ArgumentGenerator {
        private final List<JvmMethodParameterSignature> parameters;
        private final InstructionAdapter iv;
        private int offset;

        public ObjectSuperCallArgumentGenerator(@NotNull List<JvmMethodParameterSignature> superParameters, @NotNull InstructionAdapter iv, int firstValueParamOffset) {
            if (superParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superParameters", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$ObjectSuperCallArgumentGenerator", "<init>"));
            }
            if (iv == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iv", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$ObjectSuperCallArgumentGenerator", "<init>"));
            }
            this.parameters = superParameters;
            this.iv = iv;
            this.offset = firstValueParamOffset;
        }

        @Override
        public void generateExpression(int i, @NotNull ExpressionValueArgument argument) {
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$ObjectSuperCallArgumentGenerator", "generateExpression"));
            }
            this.generateSuperCallArgument(i);
        }

        @Override
        public void generateDefault(int i, @NotNull DefaultValueArgument argument) {
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$ObjectSuperCallArgumentGenerator", "generateDefault"));
            }
            AsmUtil.pushDefaultValueOnStack(this.parameters.get(i).getAsmType(), this.iv);
        }

        @Override
        public void generateVararg(int i, @NotNull VarargValueArgument argument) {
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$ObjectSuperCallArgumentGenerator", "generateVararg"));
            }
            this.generateSuperCallArgument(i);
        }

        private void generateSuperCallArgument(int i) {
            Type type = this.parameters.get(i).getAsmType();
            this.iv.load(this.offset, type);
            this.offset += type.getSize();
        }
    }

    private class DelegationFieldsInfo {
        private final Map<JetDelegatorByExpressionSpecifier, Field> fields = new HashMap<JetDelegatorByExpressionSpecifier, Field>();

        private DelegationFieldsInfo() {
        }

        @NotNull
        public Field getInfo(JetDelegatorByExpressionSpecifier specifier) {
            Field field = this.fields.get(specifier);
            if (field == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$DelegationFieldsInfo", "getInfo"));
            }
            return field;
        }

        private void addField(JetDelegatorByExpressionSpecifier specifier, PropertyDescriptor propertyDescriptor) {
            this.fields.put(specifier, new Field(ImplementationBodyCodegen.this.typeMapper.mapType(propertyDescriptor), propertyDescriptor.getName().asString(), false));
        }

        private void addField(JetDelegatorByExpressionSpecifier specifier, Type type, String name) {
            this.fields.put(specifier, new Field(type, name, true));
        }

        private class Field {
            public final Type type;
            public final String name;
            public final boolean generateField;

            private Field(Type type, String name, boolean generateField) {
                this.type = type;
                this.name = name;
                this.generateField = generateField;
            }

            @NotNull
            public StackValue getStackValue() {
                StackValue.Field field = StackValue.field(this.type, ImplementationBodyCodegen.this.classAsmType, this.name, false);
                if (field == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$DelegationFieldsInfo$Field", "getStackValue"));
                }
                return field;
            }
        }
    }

    private class DataClassMethodGeneratorImpl
    extends DataClassMethodGenerator {
        DataClassMethodGeneratorImpl(JetClassOrObject klass, BindingContext bindingContext) {
            super(klass, bindingContext);
        }

        @Override
        public void generateEqualsMethod(@NotNull List<PropertyDescriptor> properties2) {
            if (properties2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateEqualsMethod"));
            }
            FunctionDescriptor equalsFunction = CodegenUtil.getDeclaredFunctionByRawSignature(ImplementationBodyCodegen.this.descriptor, Name.identifier("equals"), KotlinBuiltIns.getInstance().getBoolean(), KotlinBuiltIns.getInstance().getAny());
            MethodContext context2 = ImplementationBodyCodegen.this.context.intoFunction(equalsFunction);
            MethodVisitor mv = ImplementationBodyCodegen.this.v.newMethod(DiagnosticsPackage.OtherOrigin(equalsFunction), 1, "equals", "(Ljava/lang/Object;)Z", null, null);
            InstructionAdapter iv = new InstructionAdapter(mv);
            mv.visitCode();
            Label eq = new Label();
            Label ne = new Label();
            iv.load(0, AsmTypeConstants.OBJECT_TYPE);
            iv.load(1, AsmTypeConstants.OBJECT_TYPE);
            iv.ifacmpeq(eq);
            iv.load(1, AsmTypeConstants.OBJECT_TYPE);
            iv.instanceOf(ImplementationBodyCodegen.this.classAsmType);
            iv.ifeq(ne);
            iv.load(1, AsmTypeConstants.OBJECT_TYPE);
            iv.checkcast(ImplementationBodyCodegen.this.classAsmType);
            iv.store(2, AsmTypeConstants.OBJECT_TYPE);
            for (PropertyDescriptor propertyDescriptor : properties2) {
                Type asmType = ImplementationBodyCodegen.this.typeMapper.mapType(propertyDescriptor);
                this.genPropertyOnStack(iv, context2, propertyDescriptor, 0);
                this.genPropertyOnStack(iv, context2, propertyDescriptor, 2);
                if (asmType.getSort() == 9) {
                    Type elementType = AsmUtil.correctElementType(asmType);
                    if (elementType.getSort() == 10 || elementType.getSort() == 9) {
                        iv.invokestatic("java/util/Arrays", "equals", "([Ljava/lang/Object;[Ljava/lang/Object;)Z", false);
                    } else {
                        iv.invokestatic("java/util/Arrays", "equals", "([" + elementType.getDescriptor() + "[" + elementType.getDescriptor() + ")Z", false);
                    }
                } else {
                    StackValue value = AsmUtil.genEqualsForExpressionsOnStack(iv, JetTokens.EQEQ, asmType, asmType);
                    value.put(Type.BOOLEAN_TYPE, iv);
                }
                iv.ifeq(ne);
            }
            iv.mark(eq);
            iv.iconst(1);
            iv.areturn(Type.INT_TYPE);
            iv.mark(ne);
            iv.iconst(0);
            iv.areturn(Type.INT_TYPE);
            FunctionCodegen.endVisit(mv, "equals", ImplementationBodyCodegen.this.myClass);
        }

        @Override
        public void generateHashCodeMethod(@NotNull List<PropertyDescriptor> properties2) {
            if (properties2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateHashCodeMethod"));
            }
            FunctionDescriptor hashCodeFunction = CodegenUtil.getDeclaredFunctionByRawSignature(ImplementationBodyCodegen.this.descriptor, Name.identifier("hashCode"), KotlinBuiltIns.getInstance().getInt(), new ClassifierDescriptor[0]);
            MethodContext context2 = ImplementationBodyCodegen.this.context.intoFunction(hashCodeFunction);
            MethodVisitor mv = ImplementationBodyCodegen.this.v.newMethod(DiagnosticsPackage.OtherOrigin(hashCodeFunction), 1, "hashCode", "()I", null, null);
            InstructionAdapter iv = new InstructionAdapter(mv);
            mv.visitCode();
            boolean first = true;
            for (PropertyDescriptor propertyDescriptor : properties2) {
                if (!first) {
                    iv.iconst(31);
                    iv.mul(Type.INT_TYPE);
                }
                this.genPropertyOnStack(iv, context2, propertyDescriptor, 0);
                Label ifNull = null;
                Type asmType = ImplementationBodyCodegen.this.typeMapper.mapType(propertyDescriptor);
                if (!AsmUtil.isPrimitive(asmType)) {
                    ifNull = new Label();
                    iv.dup();
                    iv.ifnull(ifNull);
                }
                AsmUtil.genHashCode(mv, iv, asmType);
                if (ifNull != null) {
                    Label end = new Label();
                    iv.goTo(end);
                    iv.mark(ifNull);
                    iv.pop();
                    iv.iconst(0);
                    iv.mark(end);
                }
                if (first) {
                    first = false;
                    continue;
                }
                iv.add(Type.INT_TYPE);
            }
            mv.visitInsn(172);
            FunctionCodegen.endVisit(mv, "hashCode", ImplementationBodyCodegen.this.myClass);
        }

        @Override
        public void generateToStringMethod(@NotNull List<PropertyDescriptor> properties2) {
            if (properties2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateToStringMethod"));
            }
            FunctionDescriptor toString2 = CodegenUtil.getDeclaredFunctionByRawSignature(ImplementationBodyCodegen.this.descriptor, Name.identifier("toString"), KotlinBuiltIns.getInstance().getString(), new ClassifierDescriptor[0]);
            MethodContext context2 = ImplementationBodyCodegen.this.context.intoFunction(toString2);
            MethodVisitor mv = ImplementationBodyCodegen.this.v.newMethod(DiagnosticsPackage.OtherOrigin(toString2), 1, "toString", "()Ljava/lang/String;", null, null);
            InstructionAdapter iv = new InstructionAdapter(mv);
            mv.visitCode();
            AsmUtil.genStringBuilderConstructor(iv);
            boolean first = true;
            for (PropertyDescriptor propertyDescriptor : properties2) {
                if (first) {
                    iv.aconst(ImplementationBodyCodegen.this.descriptor.getName() + "(" + propertyDescriptor.getName().asString() + "=");
                    first = false;
                } else {
                    iv.aconst(", " + propertyDescriptor.getName().asString() + "=");
                }
                AsmUtil.genInvokeAppendMethod(iv, AsmTypeConstants.JAVA_STRING_TYPE);
                Type type = this.genPropertyOnStack(iv, context2, propertyDescriptor, 0);
                if (type.getSort() == 9) {
                    Type elementType = AsmUtil.correctElementType(type);
                    if (elementType.getSort() == 10 || elementType.getSort() == 9) {
                        iv.invokestatic("java/util/Arrays", "toString", "([Ljava/lang/Object;)Ljava/lang/String;", false);
                        type = AsmTypeConstants.JAVA_STRING_TYPE;
                    } else if (elementType.getSort() != 2) {
                        iv.invokestatic("java/util/Arrays", "toString", "(" + type.getDescriptor() + ")Ljava/lang/String;", false);
                        type = AsmTypeConstants.JAVA_STRING_TYPE;
                    }
                }
                AsmUtil.genInvokeAppendMethod(iv, type);
            }
            iv.aconst(")");
            AsmUtil.genInvokeAppendMethod(iv, AsmTypeConstants.JAVA_STRING_TYPE);
            iv.invokevirtual("java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
            iv.areturn(AsmTypeConstants.JAVA_STRING_TYPE);
            FunctionCodegen.endVisit(mv, "toString", ImplementationBodyCodegen.this.myClass);
        }

        private Type genPropertyOnStack(InstructionAdapter iv, MethodContext context2, @NotNull PropertyDescriptor propertyDescriptor, int index) {
            if (propertyDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "genPropertyOnStack"));
            }
            iv.load(index, ImplementationBodyCodegen.this.classAsmType);
            if (JvmCodegenUtil.couldUseDirectAccessToProperty(propertyDescriptor, true, false, context2)) {
                Type type = ImplementationBodyCodegen.this.typeMapper.mapType(propertyDescriptor.getType());
                String fieldName = ((FieldOwnerContext)context2.getParentContext()).getFieldName(propertyDescriptor, false);
                iv.getfield(ImplementationBodyCodegen.this.classAsmType.getInternalName(), fieldName, type.getDescriptor());
                return type.getReturnType();
            }
            Method method = ImplementationBodyCodegen.this.typeMapper.mapSignature(propertyDescriptor.getGetter()).getAsmMethod();
            iv.invokevirtual(ImplementationBodyCodegen.this.classAsmType.getInternalName(), method.getName(), method.getDescriptor(), false);
            return method.getReturnType();
        }

        @Override
        public void generateComponentFunction(@NotNull FunctionDescriptor function, final @NotNull ValueParameterDescriptor parameter) {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateComponentFunction"));
            }
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateComponentFunction"));
            }
            PsiElement originalElement = DescriptorToSourceUtils.descriptorToDeclaration(parameter);
            ImplementationBodyCodegen.this.functionCodegen.generateMethod(DiagnosticsPackage.OtherOrigin(originalElement, function), ImplementationBodyCodegen.this.typeMapper.mapSignature(function), function, new FunctionGenerationStrategy(){

                @Override
                public void generateBody(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull JvmMethodSignature signature, @NotNull MethodContext context2, @NotNull MemberCodegen<?> parentCodegen) {
                    if (mv == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$1", "generateBody"));
                    }
                    if (frameMap == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameMap", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$1", "generateBody"));
                    }
                    if (signature == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$1", "generateBody"));
                    }
                    if (context2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$1", "generateBody"));
                    }
                    if (parentCodegen == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$1", "generateBody"));
                    }
                    Type componentType = signature.getReturnType();
                    InstructionAdapter iv = new InstructionAdapter(mv);
                    if (!componentType.equals(Type.VOID_TYPE)) {
                        PropertyDescriptor property2 = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, DescriptorToSourceUtils.descriptorToDeclaration(parameter));
                        assert (property2 != null) : "Property descriptor is not found for primary constructor parameter: " + parameter;
                        DataClassMethodGeneratorImpl.this.genPropertyOnStack(iv, context2, property2, 0);
                    }
                    iv.areturn(componentType);
                }
            });
        }

        @Override
        public void generateCopyFunction(final @NotNull FunctionDescriptor function, @NotNull List<JetParameter> constructorParameters) {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateCopyFunction"));
            }
            if (constructorParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorParameters", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl", "generateCopyFunction"));
            }
            JvmMethodSignature methodSignature = ImplementationBodyCodegen.this.typeMapper.mapSignature(function);
            final Type thisDescriptorType = ImplementationBodyCodegen.this.typeMapper.mapType(ImplementationBodyCodegen.this.descriptor);
            ImplementationBodyCodegen.this.functionCodegen.generateMethod(DiagnosticsPackage.OtherOrigin(ImplementationBodyCodegen.this.myClass, function), methodSignature, function, new FunctionGenerationStrategy(){

                @Override
                public void generateBody(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull JvmMethodSignature signature, @NotNull MethodContext context2, @NotNull MemberCodegen<?> parentCodegen) {
                    ClassDescriptor captureThis;
                    if (mv == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$2", "generateBody"));
                    }
                    if (frameMap == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameMap", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$2", "generateBody"));
                    }
                    if (signature == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$2", "generateBody"));
                    }
                    if (context2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$2", "generateBody"));
                    }
                    if (parentCodegen == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$DataClassMethodGeneratorImpl$2", "generateBody"));
                    }
                    InstructionAdapter iv = new InstructionAdapter(mv);
                    iv.anew(thisDescriptorType);
                    iv.dup();
                    ConstructorDescriptor constructor = DeclarationResolver.getConstructorOfDataClass(ImplementationBodyCodegen.this.descriptor);
                    assert (function.getValueParameters().size() == constructor.getValueParameters().size()) : "Number of parameters of copy function and constructor are different. Copy: " + function.getValueParameters().size() + ", " + "constructor: " + constructor.getValueParameters().size();
                    MutableClosure closure = ImplementationBodyCodegen.this.context.closure;
                    if (closure != null && (captureThis = closure.getCaptureThis()) != null) {
                        iv.load(0, ImplementationBodyCodegen.this.classAsmType);
                        Type type = ImplementationBodyCodegen.this.typeMapper.mapType(captureThis);
                        iv.getfield(ImplementationBodyCodegen.this.classAsmType.getInternalName(), "this$0", type.getDescriptor());
                    }
                    int parameterIndex = 1;
                    for (ValueParameterDescriptor parameterDescriptor : function.getValueParameters()) {
                        Type type = ImplementationBodyCodegen.this.typeMapper.mapType(parameterDescriptor.getType());
                        iv.load(parameterIndex, type);
                        parameterIndex += type.getSize();
                    }
                    Method constructorAsmMethod = ImplementationBodyCodegen.this.typeMapper.mapSignature(constructor).getAsmMethod();
                    iv.invokespecial(thisDescriptorType.getInternalName(), "<init>", constructorAsmMethod.getDescriptor(), false);
                    iv.areturn(thisDescriptorType);
                }
            });
            ImplementationBodyCodegen.this.functionCodegen.generateDefaultIfNeeded(ImplementationBodyCodegen.this.context.intoFunction(function), methodSignature, function, OwnerKind.IMPLEMENTATION, new DefaultParameterValueLoader(){

                @Override
                public void putValueOnStack(ValueParameterDescriptor valueParameter, ExpressionCodegen codegen) {
                    assert (KotlinBuiltIns.getInstance().isData((ClassDescriptor)function.getContainingDeclaration())) : "Function container should be annotated with [data]: " + function;
                    PropertyDescriptor property2 = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, valueParameter);
                    assert (property2 != null) : "Copy function doesn't correspond to any property: " + function;
                    codegen.v.load(0, thisDescriptorType);
                    Type propertyType = ImplementationBodyCodegen.this.typeMapper.mapType(property2);
                    codegen.intermediateValueForProperty(property2, false, null).put(propertyType, codegen.v);
                }
            }, null);
        }
    }

    private class MethodStubGenerator {
        private final Set<String> generatedSignatures = new HashSet<String>();

        private MethodStubGenerator() {
        }

        public void generate(@NotNull String name, @NotNull String desc, @NotNull ClassifierDescriptor returnedClassifier, ClassifierDescriptor ... valueParameterClassifiers) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$MethodStubGenerator", "generate"));
            }
            if (desc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$MethodStubGenerator", "generate"));
            }
            if (returnedClassifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnedClassifier", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$MethodStubGenerator", "generate"));
            }
            if (valueParameterClassifiers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterClassifiers", "org/jetbrains/jet/codegen/ImplementationBodyCodegen$MethodStubGenerator", "generate"));
            }
            if (!this.generatedSignatures.add(name + desc)) {
                return;
            }
            if (CodegenUtil.getDeclaredFunctionByRawSignature(ImplementationBodyCodegen.this.descriptor, Name.identifier(name), returnedClassifier, valueParameterClassifiers) == null) {
                int access = ImplementationBodyCodegen.this.descriptor.getKind() == ClassKind.TRAIT ? 1025 : 1;
                MethodVisitor mv = ImplementationBodyCodegen.this.v.newMethod(JvmDeclarationOrigin.NO_ORIGIN, access, name, desc, null, null);
                if (ImplementationBodyCodegen.this.descriptor.getKind() != ClassKind.TRAIT) {
                    mv.visitCode();
                    AsmUtil.genThrow(new InstructionAdapter(mv), "java/lang/UnsupportedOperationException", "Mutating immutable collection");
                    FunctionCodegen.endVisit(mv, "built-in stub for " + name + desc, null);
                }
            }
        }
    }
}

