/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.AnnotationCodegen;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.FieldInfo;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.JvmCodegenUtil;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.binding.CalculatedClosure;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.MemberDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.DescriptorToSourceUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.annotations.AnnotationsPackage;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.java.JavaVisibilities;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.JvmPrimitiveType;
import org.jetbrains.jet.lang.resolve.java.descriptor.JavaCallableMemberDescriptor;
import org.jetbrains.jet.lang.resolve.java.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.jet.lang.resolve.java.mapping.PrimitiveTypesUtil;
import org.jetbrains.jet.lang.resolve.kotlin.PackagePartClassUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class AsmUtil {
    private static final Set<ClassDescriptor> PRIMITIVE_NUMBER_CLASSES = Sets.newHashSet(KotlinBuiltIns.getInstance().getByte(), KotlinBuiltIns.getInstance().getShort(), KotlinBuiltIns.getInstance().getInt(), KotlinBuiltIns.getInstance().getLong(), KotlinBuiltIns.getInstance().getFloat(), KotlinBuiltIns.getInstance().getDouble(), KotlinBuiltIns.getInstance().getChar());
    private static final Set<Type> STRING_BUILDER_OBJECT_APPEND_ARG_TYPES = Sets.newHashSet(AsmTypeConstants.getType(String.class), AsmTypeConstants.getType(StringBuffer.class), AsmTypeConstants.getType(CharSequence.class));
    public static final int NO_FLAG_PACKAGE_PRIVATE = 0;
    @NotNull
    private static final Map<Visibility, Integer> visibilityToAccessFlag = ImmutableMap.builder().put(Visibilities.PRIVATE, 2).put(Visibilities.PROTECTED, 4).put(JavaVisibilities.PROTECTED_STATIC_VISIBILITY, 4).put(JavaVisibilities.PROTECTED_AND_PACKAGE, 4).put(Visibilities.PUBLIC, 1).put(Visibilities.INTERNAL, 1).put(Visibilities.LOCAL, 0).put(JavaVisibilities.PACKAGE_VISIBILITY, 0).build();
    public static final String CAPTURED_RECEIVER_FIELD = "receiver$0";
    public static final String CAPTURED_THIS_FIELD = "this$0";
    private static final ImmutableMap<Integer, JvmPrimitiveType> primitiveTypeByAsmSort;
    private static final ImmutableMap<Type, Type> primitiveTypeByBoxedType;

    private AsmUtil() {
    }

    @NotNull
    public static Type boxType(@NotNull Type type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/AsmUtil", "boxType"));
        }
        JvmPrimitiveType jvmPrimitiveType = primitiveTypeByAsmSort.get(type.getSort());
        Type type2 = jvmPrimitiveType != null ? AsmUtil.asmTypeByFqNameWithoutInnerClasses(jvmPrimitiveType.getWrapperFqName()) : type;
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/AsmUtil", "boxType"));
        }
        return type2;
    }

    @NotNull
    public static Type unboxType(@NotNull Type boxedType) {
        if (boxedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boxedType", "org/jetbrains/jet/codegen/AsmUtil", "unboxType"));
        }
        Type primitiveType = primitiveTypeByBoxedType.get(boxedType);
        if (primitiveType == null) {
            throw new UnsupportedOperationException("Unboxing: " + boxedType);
        }
        Type type = primitiveType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/AsmUtil", "unboxType"));
        }
        return type;
    }

    public static boolean isIntPrimitive(Type type) {
        return type == Type.INT_TYPE || type == Type.SHORT_TYPE || type == Type.BYTE_TYPE || type == Type.CHAR_TYPE;
    }

    public static boolean isNumberPrimitive(Type type) {
        return AsmUtil.isIntPrimitive(type) || type == Type.FLOAT_TYPE || type == Type.DOUBLE_TYPE || type == Type.LONG_TYPE;
    }

    public static boolean isPrimitive(Type type) {
        return type.getSort() != 10 && type.getSort() != 9;
    }

    public static boolean isPrimitiveNumberClassDescriptor(DeclarationDescriptor descriptor) {
        if (!(descriptor instanceof ClassDescriptor)) {
            return false;
        }
        return PRIMITIVE_NUMBER_CLASSES.contains(descriptor);
    }

    public static Type correctElementType(Type type) {
        String internalName = type.getInternalName();
        assert (internalName.charAt(0) == '[');
        return Type.getType(internalName.substring(1));
    }

    @NotNull
    public static Method method(@NotNull String name, @NotNull Type returnType, Type ... parameterTypes) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/AsmUtil", "method"));
        }
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/jet/codegen/AsmUtil", "method"));
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterTypes", "org/jetbrains/jet/codegen/AsmUtil", "method"));
        }
        Method method = new Method(name, Type.getMethodDescriptor(returnType, parameterTypes));
        if (method == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/AsmUtil", "method"));
        }
        return method;
    }

    public static boolean isAbstractMethod(FunctionDescriptor functionDescriptor, OwnerKind kind) {
        return (functionDescriptor.getModality() == Modality.ABSTRACT || JvmCodegenUtil.isInterface(functionDescriptor.getContainingDeclaration())) && !AsmUtil.isStaticMethod(kind, functionDescriptor);
    }

    public static boolean isStaticMethod(OwnerKind kind, CallableMemberDescriptor functionDescriptor) {
        return AsmUtil.isStaticKind(kind) || JetTypeMapper.isAccessor(functionDescriptor) || AnnotationsPackage.isPlatformStaticInObject(functionDescriptor);
    }

    public static boolean isStaticKind(OwnerKind kind) {
        return kind == OwnerKind.PACKAGE || kind == OwnerKind.TRAIT_IMPL;
    }

    public static int getMethodAsmFlags(FunctionDescriptor functionDescriptor, OwnerKind kind) {
        DeclarationDescriptor containingDeclaration;
        int flags = AsmUtil.getCommonCallableFlags(functionDescriptor);
        for (AnnotationCodegen.JvmFlagAnnotation flagAnnotation : AnnotationCodegen.METHOD_FLAGS) {
            if (!flagAnnotation.hasAnnotation(functionDescriptor.getOriginal())) continue;
            flags |= flagAnnotation.getJvmFlag();
        }
        if (!(functionDescriptor.getModality() != Modality.FINAL || functionDescriptor instanceof ConstructorDescriptor || (containingDeclaration = functionDescriptor.getContainingDeclaration()) instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() == ClassKind.TRAIT)) {
            flags |= 0x10;
        }
        if (AsmUtil.isStaticMethod(kind, functionDescriptor)) {
            flags |= 8;
        }
        if (AsmUtil.isAbstractMethod(functionDescriptor, kind)) {
            flags |= 0x400;
        }
        if (JetTypeMapper.isAccessor(functionDescriptor)) {
            flags |= 0x1000;
        }
        return flags;
    }

    private static int getCommonCallableFlags(FunctionDescriptor functionDescriptor) {
        int flags = AsmUtil.getVisibilityAccessFlag(functionDescriptor);
        flags |= AsmUtil.getVarargsFlag(functionDescriptor);
        return flags |= AsmUtil.getDeprecatedAccessFlag(functionDescriptor);
    }

    public static int getVisibilityAccessFlag(@NotNull MemberDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/AsmUtil", "getVisibilityAccessFlag"));
        }
        Integer specialCase = AsmUtil.specialCaseVisibility(descriptor);
        if (specialCase != null) {
            return specialCase;
        }
        Integer defaultMapping = visibilityToAccessFlag.get(descriptor.getVisibility());
        if (defaultMapping == null) {
            throw new IllegalStateException(descriptor.getVisibility() + " is not a valid visibility in backend: " + descriptor);
        }
        return defaultMapping;
    }

    public static int getVisibilityAccessFlagForClass(ClassDescriptor descriptor) {
        if (DescriptorUtils.isTopLevelDeclaration(descriptor) || descriptor.getVisibility() == Visibilities.PUBLIC || descriptor.getVisibility() == Visibilities.INTERNAL) {
            return 1;
        }
        return 0;
    }

    public static int getVisibilityAccessFlagForAnonymous(@NotNull ClassDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/AsmUtil", "getVisibilityAccessFlagForAnonymous"));
        }
        if (AsmUtil.isDeclarationInsideInlineFunction(descriptor)) {
            return 1;
        }
        return 0;
    }

    private static boolean isDeclarationInsideInlineFunction(@NotNull ClassDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/AsmUtil", "isDeclarationInsideInlineFunction"));
        }
        DeclarationDescriptor parentDeclaration = descriptor.getContainingDeclaration();
        return parentDeclaration instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)parentDeclaration).getInlineStrategy().isInline();
    }

    public static int calculateInnerClassAccessFlags(@NotNull ClassDescriptor innerClass) {
        if (innerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClass", "org/jetbrains/jet/codegen/AsmUtil", "calculateInnerClassAccessFlags"));
        }
        return AsmUtil.getVisibilityAccessFlag(innerClass) | AsmUtil.innerAccessFlagsForModalityAndKind(innerClass) | (innerClass.isInner() ? 0 : 8);
    }

    private static int innerAccessFlagsForModalityAndKind(@NotNull ClassDescriptor innerClass) {
        if (innerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClass", "org/jetbrains/jet/codegen/AsmUtil", "innerAccessFlagsForModalityAndKind"));
        }
        switch (innerClass.getKind()) {
            case TRAIT: {
                return 1536;
            }
            case ENUM_CLASS: {
                return 16400;
            }
            case ANNOTATION_CLASS: {
                return 9728;
            }
        }
        if (innerClass.getModality() == Modality.FINAL) {
            return 16;
        }
        if (innerClass.getModality() == Modality.ABSTRACT) {
            return 1024;
        }
        return 0;
    }

    public static int getDeprecatedAccessFlag(@NotNull MemberDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/AsmUtil", "getDeprecatedAccessFlag"));
        }
        if (descriptor instanceof PropertyAccessorDescriptor) {
            return KotlinBuiltIns.getInstance().isDeprecated(descriptor) ? 131072 : AsmUtil.getDeprecatedAccessFlag(((PropertyAccessorDescriptor)descriptor).getCorrespondingProperty());
        }
        if (KotlinBuiltIns.getInstance().isDeprecated(descriptor)) {
            return 131072;
        }
        return 0;
    }

    private static int getVarargsFlag(FunctionDescriptor functionDescriptor) {
        if (!functionDescriptor.getValueParameters().isEmpty() && functionDescriptor.getValueParameters().get(functionDescriptor.getValueParameters().size() - 1).getVarargElementType() != null) {
            return 128;
        }
        return 0;
    }

    @Nullable
    private static Integer specialCaseVisibility(@NotNull MemberDescriptor memberDescriptor) {
        if (memberDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberDescriptor", "org/jetbrains/jet/codegen/AsmUtil", "specialCaseVisibility"));
        }
        DeclarationDescriptor containingDeclaration = memberDescriptor.getContainingDeclaration();
        if (JvmCodegenUtil.isInterface(containingDeclaration)) {
            return 1;
        }
        Visibility memberVisibility = memberDescriptor.getVisibility();
        if (memberVisibility == Visibilities.LOCAL && memberDescriptor instanceof CallableMemberDescriptor) {
            return 1;
        }
        if (DescriptorUtils.isEnumEntry(memberDescriptor)) {
            return 0;
        }
        if (memberDescriptor instanceof ConstructorDescriptor && DescriptorUtils.isAnonymousObject(memberDescriptor.getContainingDeclaration())) {
            return 0;
        }
        if (memberVisibility != Visibilities.PRIVATE) {
            return null;
        }
        if (memberDescriptor instanceof ConstructorDescriptor) {
            ClassKind kind = ((ClassDescriptor)containingDeclaration).getKind();
            if (kind == ClassKind.OBJECT || kind == ClassKind.ENUM_ENTRY) {
                return 0;
            }
            if (kind == ClassKind.ENUM_CLASS) {
                return 4;
            }
        }
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            return 1;
        }
        return null;
    }

    private static Type stringValueOfType(Type type) {
        int sort = type.getSort();
        return sort == 10 || sort == 9 ? AsmTypeConstants.OBJECT_TYPE : (sort == 3 || sort == 4 ? Type.INT_TYPE : type);
    }

    private static Type stringBuilderAppendType(Type type) {
        switch (type.getSort()) {
            case 10: {
                return STRING_BUILDER_OBJECT_APPEND_ARG_TYPES.contains(type) ? type : AsmTypeConstants.OBJECT_TYPE;
            }
            case 9: {
                return AsmTypeConstants.OBJECT_TYPE;
            }
            case 3: 
            case 4: {
                return Type.INT_TYPE;
            }
        }
        return type;
    }

    public static void genThrow(@NotNull InstructionAdapter v, @NotNull String exception, @Nullable String message) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/AsmUtil", "genThrow"));
        }
        if (exception == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exception", "org/jetbrains/jet/codegen/AsmUtil", "genThrow"));
        }
        v.anew(Type.getObjectType(exception));
        v.dup();
        if (message != null) {
            v.aconst(message);
            v.invokespecial(exception, "<init>", "(Ljava/lang/String;)V", false);
        } else {
            v.invokespecial(exception, "<init>", "()V", false);
        }
        v.athrow();
    }

    public static void genClosureFields(CalculatedClosure closure, ClassBuilder v, JetTypeMapper typeMapper) {
        JetType captureReceiverType;
        ArrayList<Pair<String, Type>> allFields = new ArrayList<Pair<String, Type>>();
        ClassDescriptor captureThis = closure.getCaptureThis();
        if (captureThis != null) {
            allFields.add(Pair.create(CAPTURED_THIS_FIELD, typeMapper.mapType(captureThis)));
        }
        if ((captureReceiverType = closure.getCaptureReceiverType()) != null) {
            allFields.add(Pair.create(CAPTURED_RECEIVER_FIELD, typeMapper.mapType(captureReceiverType)));
        }
        allFields.addAll(closure.getRecordedFields());
        AsmUtil.genClosureFields(allFields, v);
    }

    public static void genClosureFields(List<Pair<String, Type>> allFields, ClassBuilder builder) {
        int access = 4112;
        for (Pair<String, Type> field : allFields) {
            builder.newField(JvmDeclarationOrigin.NO_ORIGIN, access, (String)field.first, ((Type)field.second).getDescriptor(), null, null);
        }
    }

    public static List<FieldInfo> transformCapturedParams(List<Pair<String, Type>> allFields, Type owner) {
        ArrayList<FieldInfo> result2 = new ArrayList<FieldInfo>();
        for (Pair<String, Type> field : allFields) {
            result2.add(FieldInfo.createForHiddenField(owner, (Type)field.second, (String)field.first));
        }
        return result2;
    }

    public static int genAssignInstanceFieldFromParam(FieldInfo info, int index, InstructionAdapter iv) {
        assert (!info.isStatic());
        Type fieldType = info.getFieldType();
        iv.load(0, info.getOwnerType());
        iv.load(index, fieldType);
        iv.visitFieldInsn(181, info.getOwnerInternalName(), info.getFieldName(), fieldType.getDescriptor());
        return index += fieldType.getSize();
    }

    public static void genStringBuilderConstructor(InstructionAdapter v) {
        v.visitTypeInsn(187, "java/lang/StringBuilder");
        v.dup();
        v.invokespecial("java/lang/StringBuilder", "<init>", "()V", false);
    }

    public static void genInvokeAppendMethod(InstructionAdapter v, Type type) {
        type = AsmUtil.stringBuilderAppendType(type);
        v.invokevirtual("java/lang/StringBuilder", "append", "(" + type.getDescriptor() + ")Ljava/lang/StringBuilder;", false);
    }

    public static StackValue genToString(InstructionAdapter v, StackValue receiver, Type receiverType) {
        Type type = AsmUtil.stringValueOfType(receiverType);
        receiver.put(type, v);
        v.invokestatic("java/lang/String", "valueOf", "(" + type.getDescriptor() + ")Ljava/lang/String;", false);
        return StackValue.onStack(AsmTypeConstants.JAVA_STRING_TYPE);
    }

    static void genHashCode(MethodVisitor mv, InstructionAdapter iv, Type type) {
        if (type.getSort() == 9) {
            Type elementType = AsmUtil.correctElementType(type);
            if (elementType.getSort() == 10 || elementType.getSort() == 9) {
                iv.invokestatic("java/util/Arrays", "hashCode", "([Ljava/lang/Object;)I", false);
            } else {
                iv.invokestatic("java/util/Arrays", "hashCode", "(" + type.getDescriptor() + ")I", false);
            }
        } else if (type.getSort() == 10) {
            iv.invokevirtual("java/lang/Object", "hashCode", "()I", false);
        } else if (type.getSort() == 7) {
            AsmUtil.genLongHashCode(mv, iv);
        } else if (type.getSort() == 8) {
            iv.invokestatic("java/lang/Double", "doubleToLongBits", "(D)J", false);
            AsmUtil.genLongHashCode(mv, iv);
        } else if (type.getSort() == 6) {
            iv.invokestatic("java/lang/Float", "floatToIntBits", "(F)I", false);
        } else if (type.getSort() == 1) {
            Label end = new Label();
            iv.dup();
            iv.ifeq(end);
            iv.pop();
            iv.iconst(1);
            iv.mark(end);
        }
    }

    private static void genLongHashCode(MethodVisitor mv, InstructionAdapter iv) {
        iv.dup2();
        iv.iconst(32);
        iv.ushr(Type.LONG_TYPE);
        iv.xor(Type.LONG_TYPE);
        mv.visitInsn(136);
    }

    static void genInvertBoolean(InstructionAdapter v) {
        v.iconst(1);
        v.xor(Type.INT_TYPE);
    }

    public static StackValue genEqualsForExpressionsOnStack(InstructionAdapter v, IElementType opToken, Type leftType, Type rightType) {
        if ((AsmUtil.isNumberPrimitive(leftType) || leftType.getSort() == 1) && leftType == rightType) {
            return StackValue.cmp(opToken, leftType);
        }
        if (opToken == JetTokens.EQEQEQ || opToken == JetTokens.EXCLEQEQEQ) {
            return StackValue.cmp(opToken, leftType);
        }
        v.invokestatic("kotlin/jvm/internal/Intrinsics", "areEqual", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
        if (opToken == JetTokens.EXCLEQ || opToken == JetTokens.EXCLEQEQEQ) {
            AsmUtil.genInvertBoolean(v);
        }
        return StackValue.onStack(Type.BOOLEAN_TYPE);
    }

    public static void genIncrement(Type expectedType, int myDelta, InstructionAdapter v) {
        if (expectedType == Type.LONG_TYPE) {
            v.lconst(myDelta);
        } else if (expectedType == Type.FLOAT_TYPE) {
            v.fconst(myDelta);
        } else if (expectedType == Type.DOUBLE_TYPE) {
            v.dconst(myDelta);
        } else {
            v.iconst(myDelta);
            v.add(Type.INT_TYPE);
            StackValue.coerce(Type.INT_TYPE, expectedType, v);
            return;
        }
        v.add(expectedType);
    }

    public static Type genNegate(Type expectedType, InstructionAdapter v) {
        if (expectedType == Type.BYTE_TYPE || expectedType == Type.SHORT_TYPE || expectedType == Type.CHAR_TYPE) {
            expectedType = Type.INT_TYPE;
        }
        v.neg(expectedType);
        return expectedType;
    }

    public static void swap(InstructionAdapter v, Type stackTop, Type afterTop) {
        if (stackTop.getSize() == 1) {
            if (afterTop.getSize() == 1) {
                v.swap();
            } else {
                v.dupX2();
                v.pop();
            }
        } else {
            if (afterTop.getSize() == 1) {
                v.dup2X1();
            } else {
                v.dup2X2();
            }
            v.pop2();
        }
    }

    public static void genNotNullAssertionsForParameters(@NotNull InstructionAdapter v, @NotNull GenerationState state, @NotNull FunctionDescriptor descriptor, @NotNull FrameMap frameMap) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/AsmUtil", "genNotNullAssertionsForParameters"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/AsmUtil", "genNotNullAssertionsForParameters"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/AsmUtil", "genNotNullAssertionsForParameters"));
        }
        if (frameMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameMap", "org/jetbrains/jet/codegen/AsmUtil", "genNotNullAssertionsForParameters"));
        }
        if (!state.isParamAssertionsEnabled()) {
            return;
        }
        if (AsmUtil.getVisibilityAccessFlag(descriptor) == 2) {
            return;
        }
        for (ValueParameterDescriptor parameter : descriptor.getValueParameters()) {
            JetType type = parameter.getReturnType();
            if (type == null || TypeUtils.isNullableType(type)) continue;
            int index = frameMap.getIndex(parameter);
            Type asmType = state.getTypeMapper().mapType(type);
            if (asmType.getSort() != 10 && asmType.getSort() != 9) continue;
            v.load(index, asmType);
            v.visitLdcInsn(parameter.getName().asString());
            v.invokestatic("kotlin/jvm/internal/Intrinsics", "checkParameterIsNotNull", "(Ljava/lang/Object;Ljava/lang/String;)V", false);
        }
    }

    public static void genNotNullAssertionForField(@NotNull InstructionAdapter v, @NotNull GenerationState state, @NotNull PropertyDescriptor descriptor) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/AsmUtil", "genNotNullAssertionForField"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/AsmUtil", "genNotNullAssertionForField"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/AsmUtil", "genNotNullAssertionForField"));
        }
        AsmUtil.genNotNullAssertion(v, state, descriptor, "checkFieldIsNotNull");
    }

    public static void genNotNullAssertionForMethod(@NotNull InstructionAdapter v, @NotNull GenerationState state, @NotNull ResolvedCall resolvedCall) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/AsmUtil", "genNotNullAssertionForMethod"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/AsmUtil", "genNotNullAssertionForMethod"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/codegen/AsmUtil", "genNotNullAssertionForMethod"));
        }
        Object descriptor = resolvedCall.getResultingDescriptor();
        if (descriptor instanceof ConstructorDescriptor) {
            return;
        }
        AsmUtil.genNotNullAssertion(v, state, descriptor, "checkReturnedValueIsNotNull");
    }

    private static void genNotNullAssertion(@NotNull InstructionAdapter v, @NotNull GenerationState state, @NotNull CallableDescriptor descriptor, @NotNull String assertMethodToCall) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/AsmUtil", "genNotNullAssertion"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/AsmUtil", "genNotNullAssertion"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/AsmUtil", "genNotNullAssertion"));
        }
        if (assertMethodToCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assertMethodToCall", "org/jetbrains/jet/codegen/AsmUtil", "genNotNullAssertion"));
        }
        if (!state.isCallAssertionsEnabled()) {
            return;
        }
        if (!AsmUtil.isDeclaredInJava(descriptor)) {
            return;
        }
        JetType type = descriptor.getReturnType();
        if (type == null || TypeUtils.isNullableType(type)) {
            return;
        }
        Type asmType = state.getTypeMapper().mapReturnType(descriptor);
        if (asmType.getSort() == 10 || asmType.getSort() == 9) {
            v.dup();
            v.visitLdcInsn(descriptor.getContainingDeclaration().getName().asString());
            v.visitLdcInsn(descriptor.getName().asString());
            v.invokestatic("kotlin/jvm/internal/Intrinsics", assertMethodToCall, "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;)V", false);
        }
    }

    private static boolean isDeclaredInJava(@NotNull CallableDescriptor callableDescriptor) {
        if (callableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableDescriptor", "org/jetbrains/jet/codegen/AsmUtil", "isDeclaredInJava"));
        }
        CallableDescriptor descriptor = callableDescriptor;
        while (true) {
            if (descriptor instanceof JavaCallableMemberDescriptor) {
                return true;
            }
            CallableDescriptor original = descriptor.getOriginal();
            if (descriptor == original) break;
            descriptor = original;
        }
        return false;
    }

    public static void pushDefaultValueOnStack(@NotNull Type type, @NotNull InstructionAdapter v) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/AsmUtil", "pushDefaultValueOnStack"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/AsmUtil", "pushDefaultValueOnStack"));
        }
        if (type.getSort() == 10 || type.getSort() == 9) {
            v.aconst(null);
        } else {
            AsmUtil.pushDefaultPrimitiveValueOnStack(type, v);
        }
    }

    public static void pushDefaultPrimitiveValueOnStack(@NotNull Type type, @NotNull InstructionAdapter v) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/AsmUtil", "pushDefaultPrimitiveValueOnStack"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/AsmUtil", "pushDefaultPrimitiveValueOnStack"));
        }
        if (type.getSort() == 6) {
            v.fconst(0.0f);
        } else if (type.getSort() == 8) {
            v.dconst(0.0);
        } else if (type.getSort() == 7) {
            v.lconst(0L);
        } else {
            v.iconst(0);
        }
    }

    public static boolean isPropertyWithBackingFieldInOuterClass(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/codegen/AsmUtil", "isPropertyWithBackingFieldInOuterClass"));
        }
        return AsmUtil.isClassObjectWithBackingFieldsInOuter(propertyDescriptor.getContainingDeclaration());
    }

    public static int getVisibilityForSpecialPropertyBackingField(@NotNull PropertyDescriptor propertyDescriptor, boolean isDelegate) {
        boolean isExtensionProperty;
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/codegen/AsmUtil", "getVisibilityForSpecialPropertyBackingField"));
        }
        boolean bl = isExtensionProperty = propertyDescriptor.getReceiverParameter() != null;
        if (isDelegate || isExtensionProperty) {
            return 2;
        }
        return AsmUtil.areBothAccessorDefault(propertyDescriptor) ? AsmUtil.getVisibilityAccessFlag(AsmUtil.descriptorForVisibility(propertyDescriptor)) : 2;
    }

    private static MemberDescriptor descriptorForVisibility(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/codegen/AsmUtil", "descriptorForVisibility"));
        }
        if (!propertyDescriptor.isVar()) {
            return propertyDescriptor;
        }
        return propertyDescriptor.getSetter() != null ? propertyDescriptor.getSetter() : propertyDescriptor;
    }

    public static boolean isPropertyWithBackingFieldCopyInOuterClass(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/codegen/AsmUtil", "isPropertyWithBackingFieldCopyInOuterClass"));
        }
        boolean isExtensionProperty = propertyDescriptor.getReceiverParameter() != null;
        DeclarationDescriptor propertyContainer = propertyDescriptor.getContainingDeclaration();
        return !propertyDescriptor.isVar() && !isExtensionProperty && DescriptorUtils.isClassObject(propertyContainer) && DescriptorUtils.isTrait(propertyContainer.getContainingDeclaration()) && AsmUtil.areBothAccessorDefault(propertyDescriptor) && AsmUtil.getVisibilityForSpecialPropertyBackingField(propertyDescriptor, false) == 1;
    }

    public static boolean isClassObjectWithBackingFieldsInOuter(@NotNull DeclarationDescriptor classObject) {
        if (classObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObject", "org/jetbrains/jet/codegen/AsmUtil", "isClassObjectWithBackingFieldsInOuter"));
        }
        DeclarationDescriptor containingClass = classObject.getContainingDeclaration();
        return DescriptorUtils.isClassObject(classObject) && (DescriptorUtils.isClass(containingClass) || DescriptorUtils.isEnumClass(containingClass));
    }

    private static boolean areBothAccessorDefault(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/codegen/AsmUtil", "areBothAccessorDefault"));
        }
        return AsmUtil.isAccessorWithEmptyBody(propertyDescriptor.getGetter()) && (!propertyDescriptor.isVar() || AsmUtil.isAccessorWithEmptyBody(propertyDescriptor.getSetter()));
    }

    private static boolean isAccessorWithEmptyBody(@Nullable PropertyAccessorDescriptor accessorDescriptor) {
        return accessorDescriptor == null || !accessorDescriptor.hasBody();
    }

    public static Type comparisonOperandType(Type left, Type right) {
        if (left == Type.DOUBLE_TYPE || right == Type.DOUBLE_TYPE) {
            return Type.DOUBLE_TYPE;
        }
        if (left == Type.FLOAT_TYPE || right == Type.FLOAT_TYPE) {
            return Type.FLOAT_TYPE;
        }
        if (left == Type.LONG_TYPE || right == Type.LONG_TYPE) {
            return Type.LONG_TYPE;
        }
        return Type.INT_TYPE;
    }

    @NotNull
    public static Type numberFunctionOperandType(@NotNull Type expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/codegen/AsmUtil", "numberFunctionOperandType"));
        }
        if (expectedType == Type.SHORT_TYPE || expectedType == Type.BYTE_TYPE) {
            Type type = Type.INT_TYPE;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/AsmUtil", "numberFunctionOperandType"));
            }
            return type;
        }
        Type type = expectedType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/AsmUtil", "numberFunctionOperandType"));
        }
        return type;
    }

    public static void pop(@NotNull MethodVisitor v, @NotNull Type type) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/AsmUtil", "pop"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/AsmUtil", "pop"));
        }
        if (type.getSize() == 2) {
            v.visitInsn(88);
        } else {
            v.visitInsn(87);
        }
    }

    public static void dup(@NotNull InstructionAdapter v, @NotNull Type type) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/AsmUtil", "dup"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/AsmUtil", "dup"));
        }
        if (type.getSize() == 2) {
            v.dup2();
        } else {
            v.dup();
        }
    }

    public static void writeKotlinSyntheticClassAnnotation(@NotNull ClassBuilder v, @NotNull JvmAnnotationNames.KotlinSyntheticClass.Kind kind) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/AsmUtil", "writeKotlinSyntheticClassAnnotation"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/codegen/AsmUtil", "writeKotlinSyntheticClassAnnotation"));
        }
        AnnotationVisitor av = v.newAnnotation(Type.getObjectType(JvmAnnotationNames.KotlinSyntheticClass.CLASS_NAME.getInternalName()).getDescriptor(), true);
        av.visit("abiVersion", 18);
        av.visitEnum(JvmAnnotationNames.KotlinSyntheticClass.KIND_FIELD_NAME.asString(), Type.getObjectType(JvmAnnotationNames.KotlinSyntheticClass.KIND_INTERNAL_NAME).getDescriptor(), kind.toString());
        av.visitEnd();
    }

    @NotNull
    public static String asmDescByFqNameWithoutInnerClasses(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/codegen/AsmUtil", "asmDescByFqNameWithoutInnerClasses"));
        }
        String string = AsmUtil.asmTypeByFqNameWithoutInnerClasses(fqName2).getDescriptor();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/AsmUtil", "asmDescByFqNameWithoutInnerClasses"));
        }
        return string;
    }

    @NotNull
    public static String shortNameByAsmType(@NotNull Type type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/AsmUtil", "shortNameByAsmType"));
        }
        String internalName = type.getInternalName();
        int lastSlash = internalName.lastIndexOf(47);
        String string = lastSlash < 0 ? internalName : internalName.substring(lastSlash + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/AsmUtil", "shortNameByAsmType"));
        }
        return string;
    }

    @NotNull
    public static Type asmTypeByFqNameWithoutInnerClasses(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/codegen/AsmUtil", "asmTypeByFqNameWithoutInnerClasses"));
        }
        Type type = Type.getObjectType(AsmUtil.internalNameByFqNameWithoutInnerClasses(fqName2));
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/AsmUtil", "asmTypeByFqNameWithoutInnerClasses"));
        }
        return type;
    }

    @NotNull
    public static String internalNameByFqNameWithoutInnerClasses(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/codegen/AsmUtil", "internalNameByFqNameWithoutInnerClasses"));
        }
        String string = JvmClassName.byFqNameWithoutInnerClasses(fqName2).getInternalName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/AsmUtil", "internalNameByFqNameWithoutInnerClasses"));
        }
        return string;
    }

    public static void writeOuterClassAndEnclosingMethod(@NotNull ClassDescriptor descriptor, @NotNull DeclarationDescriptor originalDescriptor, @NotNull JetTypeMapper typeMapper, @NotNull ClassBuilder v) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/AsmUtil", "writeOuterClassAndEnclosingMethod"));
        }
        if (originalDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalDescriptor", "org/jetbrains/jet/codegen/AsmUtil", "writeOuterClassAndEnclosingMethod"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/jet/codegen/AsmUtil", "writeOuterClassAndEnclosingMethod"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/AsmUtil", "writeOuterClassAndEnclosingMethod"));
        }
        String outerClassName = AsmUtil.getOuterClassName(descriptor, originalDescriptor, typeMapper);
        FunctionDescriptor function = DescriptorUtils.getParentOfType(descriptor, FunctionDescriptor.class);
        if (function != null) {
            Method method = typeMapper.mapSignature(function).getAsmMethod();
            v.visitOuterClass(outerClassName, method.getName(), method.getDescriptor());
        } else {
            v.visitOuterClass(outerClassName, null, null);
        }
    }

    @NotNull
    private static String getOuterClassName(@NotNull ClassDescriptor classDescriptor, @NotNull DeclarationDescriptor originalDescriptor, @NotNull JetTypeMapper typeMapper) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/codegen/AsmUtil", "getOuterClassName"));
        }
        if (originalDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalDescriptor", "org/jetbrains/jet/codegen/AsmUtil", "getOuterClassName"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/jet/codegen/AsmUtil", "getOuterClassName"));
        }
        for (DeclarationDescriptor container = classDescriptor.getContainingDeclaration(); container != null; container = container.getContainingDeclaration()) {
            if (container instanceof ClassDescriptor) {
                String string = typeMapper.mapClass((ClassDescriptor)container).getInternalName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/AsmUtil", "getOuterClassName"));
                }
                return string;
            }
            if (!CodegenBinding.isLocalFunOrLambda(container)) continue;
            ClassDescriptor descriptor = CodegenBinding.anonymousClassForFunction(typeMapper.getBindingContext(), (FunctionDescriptor)container);
            String string = typeMapper.mapClass(descriptor).getInternalName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/AsmUtil", "getOuterClassName"));
            }
            return string;
        }
        JetFile containingFile = DescriptorToSourceUtils.getContainingFile(originalDescriptor);
        assert (containingFile != null) : "Containing file should be present for " + classDescriptor;
        String string = PackagePartClassUtils.getPackagePartInternalName(containingFile);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/AsmUtil", "getOuterClassName"));
        }
        return string;
    }

    public static void putJavaLangClassInstance(@NotNull InstructionAdapter v, @NotNull Type type) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/AsmUtil", "putJavaLangClassInstance"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/AsmUtil", "putJavaLangClassInstance"));
        }
        if (AsmUtil.isPrimitive(type)) {
            v.getstatic(AsmUtil.boxType(type).getInternalName(), "TYPE", "Ljava/lang/Class;");
        } else {
            v.aconst(type);
        }
    }

    public static int getReceiverIndex(@NotNull CodegenContext context2, @NotNull CallableMemberDescriptor descriptor) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/AsmUtil", "getReceiverIndex"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/AsmUtil", "getReceiverIndex"));
        }
        OwnerKind kind = context2.getContextKind();
        return kind != OwnerKind.TRAIT_IMPL && AsmUtil.isStaticMethod(kind, descriptor) ? 0 : 1;
    }

    static {
        ImmutableMap.Builder<Integer, JvmPrimitiveType> typeBySortBuilder = ImmutableMap.builder();
        ImmutableMap.Builder<Type, Type> typeByWrapperBuilder = ImmutableMap.builder();
        for (JvmPrimitiveType primitiveType : JvmPrimitiveType.values()) {
            Type asmType = PrimitiveTypesUtil.asmTypeForPrimitive(primitiveType);
            typeBySortBuilder.put(asmType.getSort(), primitiveType);
            typeByWrapperBuilder.put(AsmUtil.asmTypeByFqNameWithoutInnerClasses(primitiveType.getWrapperFqName()), asmType);
        }
        primitiveTypeByAsmSort = typeBySortBuilder.build();
        primitiveTypeByBoxedType = typeByWrapperBuilder.build();
    }
}

