/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm;

import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.cli.common.CLICompiler;
import org.jetbrains.jet.cli.common.CLIConfigurationKeys;
import org.jetbrains.jet.cli.common.ExitCode;
import org.jetbrains.jet.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.FilteringMessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.jet.cli.common.messages.MessageUtil;
import org.jetbrains.jet.cli.common.messages.OutputMessageUtil;
import org.jetbrains.jet.cli.common.modules.ModuleScriptData;
import org.jetbrains.jet.cli.jvm.JVMConfigurationKeys;
import org.jetbrains.jet.cli.jvm.compiler.CommandLineScriptUtils;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.jet.cli.jvm.compiler.JetCoreEnvironment;
import org.jetbrains.jet.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.jet.cli.jvm.repl.ReplFromTerminal;
import org.jetbrains.jet.codegen.CompilationException;
import org.jetbrains.jet.config.CommonConfigurationKeys;
import org.jetbrains.jet.config.CompilerConfiguration;
import org.jetbrains.jet.config.Services;
import org.jetbrains.jet.lang.resolve.kotlin.incremental.cache.IncrementalCacheProvider;
import org.jetbrains.jet.utils.KotlinPaths;
import org.jetbrains.jet.utils.KotlinPathsFromHomeDir;
import org.jetbrains.jet.utils.PathUtil;

public class K2JVMCompiler
extends CLICompiler<K2JVMCompilerArguments> {
    public static void main(String ... args) {
        K2JVMCompiler.doMain(new K2JVMCompiler(), args);
    }

    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JVMCompilerArguments arguments, @NotNull Services services, @NotNull MessageCollector messageCollector, @NotNull Disposable rootDisposable) {
        ExitCode exitCode;
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "doExecute"));
        }
        if (services == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "services", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "doExecute"));
        }
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "doExecute"));
        }
        if (rootDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDisposable", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "doExecute"));
        }
        KotlinPaths paths = arguments.kotlinHome != null ? new KotlinPathsFromHomeDir(new File(arguments.kotlinHome)) : PathUtil.getKotlinPathsForCompiler();
        messageCollector.report(CompilerMessageSeverity.LOGGING, "Using Kotlin home directory " + paths.getHomePath(), CompilerMessageLocation.NO_LOCATION);
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, messageCollector);
        IncrementalCacheProvider incrementalCacheProvider = services.get(IncrementalCacheProvider.class);
        if (incrementalCacheProvider != null) {
            configuration.put(JVMConfigurationKeys.INCREMENTAL_CACHE_PROVIDER, incrementalCacheProvider);
        }
        try {
            configuration.addAll(JVMConfigurationKeys.CLASSPATH_KEY, K2JVMCompiler.getClasspath(paths, arguments));
            configuration.addAll(JVMConfigurationKeys.ANNOTATIONS_PATH_KEY, K2JVMCompiler.getAnnotationsPath(paths, arguments));
        }
        catch (Throwable t) {
            MessageCollectorUtil.reportException(messageCollector, t);
            ExitCode exitCode2 = ExitCode.INTERNAL_ERROR;
            if (exitCode2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "doExecute"));
            }
            return exitCode2;
        }
        if (!arguments.script && arguments.module == null && arguments.freeArgs.isEmpty() && !arguments.version) {
            ReplFromTerminal.run(rootDisposable, configuration);
            ExitCode exitCode3 = ExitCode.OK;
            if (exitCode3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "doExecute"));
            }
            return exitCode3;
        }
        if (arguments.module == null) {
            if (arguments.script) {
                if (arguments.freeArgs.isEmpty()) {
                    messageCollector.report(CompilerMessageSeverity.ERROR, "Specify script source path to evaluate", CompilerMessageLocation.NO_LOCATION);
                    ExitCode exitCode4 = ExitCode.COMPILATION_ERROR;
                    if (exitCode4 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "doExecute"));
                    }
                    return exitCode4;
                }
                configuration.add(CommonConfigurationKeys.SOURCE_ROOTS_KEY, arguments.freeArgs.get(0));
            } else {
                CompileEnvironmentUtil.addSourceFilesCheckingForDuplicates(configuration, arguments.freeArgs);
            }
        }
        configuration.put(JVMConfigurationKeys.SCRIPT_PARAMETERS, arguments.script ? CommandLineScriptUtils.scriptParameters() : Collections.emptyList());
        K2JVMCompiler.putAdvancedOptions(configuration, arguments);
        messageCollector.report(CompilerMessageSeverity.LOGGING, "Configuring the compilation environment", CompilerMessageLocation.NO_LOCATION);
        try {
            File outputDir;
            File jar;
            this.configureEnvironment(configuration, arguments);
            String destination = arguments.destination;
            if (destination != null) {
                boolean isJar = destination.endsWith(".jar");
                jar = isJar ? new File(destination) : null;
                outputDir = isJar ? null : new File(destination);
            } else {
                jar = null;
                outputDir = null;
            }
            if (arguments.module != null) {
                FilteringMessageCollector sanitizedCollector = new FilteringMessageCollector(messageCollector, Predicates.in(CompilerMessageSeverity.VERBOSE));
                ModuleScriptData moduleScript = CompileEnvironmentUtil.loadModuleDescriptions(paths, arguments.module, sanitizedCollector);
                if (outputDir != null) {
                    messageCollector.report(CompilerMessageSeverity.WARNING, "The '-d' option with a directory destination is ignored because '-module' is specified", CompilerMessageLocation.NO_LOCATION);
                }
                File directory = new File(arguments.module).getAbsoluteFile().getParentFile();
                KotlinToJVMBytecodeCompiler.compileModules(configuration, moduleScript.getModules(), directory, jar, arguments.includeRuntime);
            } else if (arguments.script) {
                List<String> scriptArgs = arguments.freeArgs.subList(1, arguments.freeArgs.size());
                JetCoreEnvironment environment = JetCoreEnvironment.createForProduction(rootDisposable, configuration);
                KotlinToJVMBytecodeCompiler.compileAndExecuteScript(paths, environment, scriptArgs);
            } else {
                JetCoreEnvironment environment = JetCoreEnvironment.createForProduction(rootDisposable, configuration);
                KotlinToJVMBytecodeCompiler.compileBunchOfSources(environment, jar, outputDir, arguments.includeRuntime);
            }
            exitCode = ExitCode.OK;
        }
        catch (CompilationException e) {
            messageCollector.report(CompilerMessageSeverity.EXCEPTION, OutputMessageUtil.renderException(e), MessageUtil.psiElementToMessageLocation(e.getElement()));
            ExitCode exitCode5 = ExitCode.INTERNAL_ERROR;
            if (exitCode5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "doExecute"));
            }
            return exitCode5;
        }
        if (exitCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "doExecute"));
        }
        return exitCode;
    }

    public static void putAdvancedOptions(@NotNull CompilerConfiguration configuration, @NotNull K2JVMCompilerArguments arguments) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "putAdvancedOptions"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "putAdvancedOptions"));
        }
        configuration.put(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, arguments.noCallAssertions);
        configuration.put(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, arguments.noParamAssertions);
        configuration.put(JVMConfigurationKeys.DISABLE_INLINE, arguments.noInline);
        configuration.put(JVMConfigurationKeys.DISABLE_OPTIMIZATION, arguments.noOptimize);
    }

    @Override
    @NotNull
    protected K2JVMCompilerArguments createArguments() {
        K2JVMCompilerArguments k2JVMCompilerArguments = new K2JVMCompilerArguments();
        if (k2JVMCompilerArguments == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "createArguments"));
        }
        return k2JVMCompilerArguments;
    }

    @NotNull
    private static List<File> getClasspath(@NotNull KotlinPaths paths, @NotNull K2JVMCompilerArguments arguments) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "getClasspath"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "getClasspath"));
        }
        ArrayList<File> classpath = Lists.newArrayList();
        if (!arguments.noJdk) {
            classpath.addAll(PathUtil.getJdkClassesRoots());
        }
        if (!arguments.noStdlib) {
            classpath.add(paths.getRuntimePath());
        }
        if (arguments.classpath != null) {
            for (String element : Splitter.on(File.pathSeparatorChar).split(arguments.classpath)) {
                classpath.add(new File(element));
            }
        }
        ArrayList<File> arrayList = classpath;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "getClasspath"));
        }
        return arrayList;
    }

    @NotNull
    private static List<File> getAnnotationsPath(@NotNull KotlinPaths paths, @NotNull K2JVMCompilerArguments arguments) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "getAnnotationsPath"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "getAnnotationsPath"));
        }
        ArrayList<File> annotationsPath = Lists.newArrayList();
        if (!arguments.noJdkAnnotations) {
            annotationsPath.add(paths.getJdkAnnotationsPath());
        }
        if (arguments.annotations != null) {
            for (String element : Splitter.on(File.pathSeparatorChar).split(arguments.annotations)) {
                annotationsPath.add(new File(element));
            }
        }
        ArrayList<File> arrayList = annotationsPath;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/K2JVMCompiler", "getAnnotationsPath"));
        }
        return arrayList;
    }
}

