/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.backend.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.backend.common.CodegenUtil;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.OverrideResolver;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public abstract class DataClassMethodGenerator {
    private final JetClassOrObject declaration;
    private final BindingContext bindingContext;
    private final ClassDescriptor classDescriptor;

    public DataClassMethodGenerator(JetClassOrObject declaration, BindingContext bindingContext) {
        this.declaration = declaration;
        this.bindingContext = bindingContext;
        this.classDescriptor = BindingContextUtils.getNotNull(bindingContext, BindingContext.CLASS, declaration);
    }

    public void generate() {
        this.generateComponentFunctionsForDataClasses();
        this.generateCopyFunctionForDataClasses(this.getPrimaryConstructorParameters());
        List<PropertyDescriptor> properties2 = this.getDataProperties();
        if (!properties2.isEmpty()) {
            this.generateDataClassToStringIfNeeded(properties2);
            this.generateDataClassHashCodeIfNeeded(properties2);
            this.generateDataClassEqualsIfNeeded(properties2);
        }
    }

    protected abstract void generateComponentFunction(@NotNull FunctionDescriptor var1, @NotNull ValueParameterDescriptor var2);

    protected abstract void generateCopyFunction(@NotNull FunctionDescriptor var1, @NotNull List<JetParameter> var2);

    protected abstract void generateToStringMethod(@NotNull List<PropertyDescriptor> var1);

    protected abstract void generateHashCodeMethod(@NotNull List<PropertyDescriptor> var1);

    protected abstract void generateEqualsMethod(@NotNull List<PropertyDescriptor> var1);

    protected ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    private void generateComponentFunctionsForDataClasses() {
        if (!this.declaration.hasPrimaryConstructor()) {
            return;
        }
        ConstructorDescriptor constructor = this.classDescriptor.getConstructors().iterator().next();
        for (ValueParameterDescriptor parameter : constructor.getValueParameters()) {
            FunctionDescriptor function = this.bindingContext.get(BindingContext.DATA_CLASS_COMPONENT_FUNCTION, parameter);
            if (function == null) continue;
            this.generateComponentFunction(function, parameter);
        }
    }

    private void generateCopyFunctionForDataClasses(List<JetParameter> constructorParameters) {
        FunctionDescriptor copyFunction = this.bindingContext.get(BindingContext.DATA_CLASS_COPY_FUNCTION, this.classDescriptor);
        if (copyFunction != null) {
            this.generateCopyFunction(copyFunction, constructorParameters);
        }
    }

    private void generateDataClassToStringIfNeeded(@NotNull List<PropertyDescriptor> properties2) {
        if (properties2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jet/backend/common/DataClassMethodGenerator", "generateDataClassToStringIfNeeded"));
        }
        ClassDescriptor stringClass = KotlinBuiltIns.getInstance().getString();
        if (!this.hasDeclaredNonTrivialMember("toString", stringClass, new ClassDescriptor[0])) {
            this.generateToStringMethod(properties2);
        }
    }

    private void generateDataClassHashCodeIfNeeded(@NotNull List<PropertyDescriptor> properties2) {
        if (properties2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jet/backend/common/DataClassMethodGenerator", "generateDataClassHashCodeIfNeeded"));
        }
        ClassDescriptor intClass = KotlinBuiltIns.getInstance().getInt();
        if (!this.hasDeclaredNonTrivialMember("hashCode", intClass, new ClassDescriptor[0])) {
            this.generateHashCodeMethod(properties2);
        }
    }

    private void generateDataClassEqualsIfNeeded(@NotNull List<PropertyDescriptor> properties2) {
        if (properties2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jet/backend/common/DataClassMethodGenerator", "generateDataClassEqualsIfNeeded"));
        }
        ClassDescriptor booleanClass = KotlinBuiltIns.getInstance().getBoolean();
        ClassDescriptor anyClass = KotlinBuiltIns.getInstance().getAny();
        if (!this.hasDeclaredNonTrivialMember("equals", booleanClass, anyClass)) {
            this.generateEqualsMethod(properties2);
        }
    }

    private List<PropertyDescriptor> getDataProperties() {
        ArrayList<PropertyDescriptor> result2 = Lists.newArrayList();
        for (JetParameter parameter : this.getPrimaryConstructorParameters()) {
            if (!parameter.hasValOrVarNode()) continue;
            result2.add(this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter));
        }
        return result2;
    }

    @NotNull
    private List<JetParameter> getPrimaryConstructorParameters() {
        if (this.declaration instanceof JetClass) {
            List<JetParameter> list = ((JetClass)this.declaration).getPrimaryConstructorParameters();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/backend/common/DataClassMethodGenerator", "getPrimaryConstructorParameters"));
            }
            return list;
        }
        List<JetParameter> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/backend/common/DataClassMethodGenerator", "getPrimaryConstructorParameters"));
        }
        return list;
    }

    private boolean hasDeclaredNonTrivialMember(@NotNull String name, @NotNull ClassDescriptor returnedClassifier, ClassDescriptor ... valueParameterClassifiers) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/backend/common/DataClassMethodGenerator", "hasDeclaredNonTrivialMember"));
        }
        if (returnedClassifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnedClassifier", "org/jetbrains/jet/backend/common/DataClassMethodGenerator", "hasDeclaredNonTrivialMember"));
        }
        if (valueParameterClassifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterClassifiers", "org/jetbrains/jet/backend/common/DataClassMethodGenerator", "hasDeclaredNonTrivialMember"));
        }
        FunctionDescriptor function = CodegenUtil.getDeclaredFunctionByRawSignature(this.classDescriptor, Name.identifier(name), returnedClassifier, valueParameterClassifiers);
        if (function == null) {
            return false;
        }
        if (function.getKind() == CallableMemberDescriptor.Kind.DECLARATION) {
            return true;
        }
        for (CallableMemberDescriptor overridden : OverrideResolver.getOverriddenDeclarations(function)) {
            if (!(overridden instanceof CallableMemberDescriptor) || overridden.getKind() != CallableMemberDescriptor.Kind.DECLARATION || overridden.getContainingDeclaration().equals(KotlinBuiltIns.getInstance().getAny())) continue;
            return true;
        }
        return false;
    }
}

