/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportsUtil {
    private ImportsUtil() {
    }

    public static List<PsiJavaCodeReferenceElement> collectReferencesThrough(PsiFile file, final @Nullable PsiJavaCodeReferenceElement refExpr, final PsiImportStaticStatement staticImport) {
        final ArrayList<PsiJavaCodeReferenceElement> expressionToExpand = new ArrayList<PsiJavaCodeReferenceElement>();
        file.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitReferenceElement(PsiJavaCodeReferenceElement expression) {
                PsiElement resolveScope;
                if ((refExpr == null || refExpr != expression) && (resolveScope = expression.advancedResolve(true).getCurrentFileResolveScope()) == staticImport) {
                    expressionToExpand.add(expression);
                }
                super.visitElement(expression);
            }
        });
        return expressionToExpand;
    }

    public static void replaceAllAndDeleteImport(List<PsiJavaCodeReferenceElement> expressionToExpand, @Nullable PsiJavaCodeReferenceElement refExpr, PsiImportStaticStatement staticImport) {
        if (refExpr != null) {
            expressionToExpand.add(refExpr);
        }
        Collections.sort(expressionToExpand, new Comparator<PsiJavaCodeReferenceElement>(){

            @Override
            public int compare(PsiJavaCodeReferenceElement o1, PsiJavaCodeReferenceElement o2) {
                return o2.getTextOffset() - o1.getTextOffset();
            }
        });
        for (PsiJavaCodeReferenceElement expression : expressionToExpand) {
            ImportsUtil.expand(expression, staticImport);
        }
        staticImport.delete();
    }

    public static void expand(@NotNull PsiJavaCodeReferenceElement refExpr, PsiImportStaticStatement staticImport) {
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "com/intellij/psi/util/ImportsUtil", "expand"));
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(refExpr.getProject());
        PsiReferenceExpression referenceExpression = elementFactory.createReferenceExpression(staticImport.resolveTargetClass());
        if (refExpr instanceof PsiReferenceExpression) {
            ((PsiReferenceExpression)refExpr).setQualifierExpression(referenceExpression);
        } else {
            refExpr.replace(elementFactory.createReferenceFromText(referenceExpression.getText() + "." + refExpr.getText(), refExpr));
        }
    }
}

