/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LeafElement
extends TreeElement {
    private static final Logger LOG = Logger.getInstance("com.intellij.psi.impl.source.tree.LeafElement");
    private static final Key<SoftReference<String>> CACHED_TEXT = Key.create("CACHED_TEXT");
    private final CharSequence myText;

    protected LeafElement(@NotNull IElementType type, CharSequence text) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/LeafElement", "<init>"));
        }
        super(type);
        this.myText = text;
    }

    @Override
    public LeafElement clone() {
        LeafElement clone = (LeafElement)super.clone();
        clone.clearCaches();
        return clone;
    }

    @Override
    public int getTextLength() {
        return this.myText.length();
    }

    @Override
    public CharSequence getChars() {
        return this.myText;
    }

    @Override
    public String getText() {
        if (this.myText.length() > 1000 && !(this.myText instanceof String)) {
            String text = (String)SoftReference.dereference(this.getUserData(CACHED_TEXT));
            if (text == null) {
                text = ((Object)this.myText).toString();
                this.putUserData(CACHED_TEXT, new SoftReference<String>(text));
            }
            return text;
        }
        return ((Object)this.myText).toString();
    }

    public char charAt(int position) {
        return this.myText.charAt(position);
    }

    public int copyTo(@Nullable char[] buffer, int start) {
        int length = this.myText.length();
        if (buffer != null) {
            CharArrayUtil.getChars(this.myText, buffer, start, length);
        }
        return start + length;
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        char[] buffer = new char[this.myText.length()];
        CharArrayUtil.getChars(this.myText, buffer, 0);
        if (buffer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/LeafElement", "textToCharArray"));
        }
        return buffer;
    }

    @Override
    public boolean textContains(char c) {
        char[] chars;
        CharSequence text = this.myText;
        int len = this.myText.length();
        if (len > 5 && (chars = CharArrayUtil.fromSequenceWithoutCopying(this.myText)) != null) {
            for (char aChar : chars) {
                if (aChar != c) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (c != text.charAt(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int textMatches(@NotNull CharSequence buffer, int start) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/source/tree/LeafElement", "textMatches"));
        }
        assert (start >= 0) : start;
        CharSequence text = this.myText;
        return LeafElement.leafTextMatches(text, buffer, start);
    }

    public static int leafTextMatches(@NotNull CharSequence text, @NotNull CharSequence buffer, int start) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/tree/LeafElement", "leafTextMatches"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/source/tree/LeafElement", "leafTextMatches"));
        }
        assert (start >= 0) : start;
        int length = text.length();
        if (buffer.length() - start < length) {
            return start == 0 ? Integer.MIN_VALUE : -start;
        }
        for (int i = 0; i < length; ++i) {
            int k = i + start;
            if (text.charAt(i) == buffer.charAt(k)) continue;
            return k == 0 ? Integer.MIN_VALUE : -k;
        }
        return start + length;
    }

    public LeafElement rawReplaceWithText(String newText) {
        LeafElement newLeaf = ASTFactory.leaf(this.getElementType(), newText);
        this.copyUserDataTo(newLeaf);
        this.rawReplaceWithList(newLeaf);
        newLeaf.clearCaches();
        return newLeaf;
    }

    public LeafElement replaceWithText(String newText) {
        LeafElement newLeaf = ChangeUtil.copyLeafWithText(this, newText);
        this.getTreeParent().replaceChild(this, newLeaf);
        return newLeaf;
    }

    @Override
    public LeafElement findLeafElementAt(int offset) {
        return this;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence buf, int start, int end) {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/intellij/psi/impl/source/tree/LeafElement", "textMatches"));
        }
        CharSequence text = this.getChars();
        int len = text.length();
        if (end - start != len) {
            return false;
        }
        if (buf == text) {
            return true;
        }
        if (len > 5 && text instanceof String && buf instanceof String) {
            return ((String)text).regionMatches(0, (String)buf, start, len);
        }
        for (int i = 0; i < len; ++i) {
            if (text.charAt(i) == buf.charAt(start + i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void acceptTree(TreeElementVisitor visitor) {
        visitor.visitLeaf(this);
    }

    @Override
    public ASTNode findChildByType(IElementType type) {
        return null;
    }

    public ASTNode findChildByType(IElementType type, @Nullable ASTNode anchor) {
        return null;
    }

    @Override
    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet) {
        if (typesSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesSet", "com/intellij/psi/impl/source/tree/LeafElement", "findChildByType"));
        }
        return null;
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet, @Nullable ASTNode anchor) {
        if (typesSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesSet", "com/intellij/psi/impl/source/tree/LeafElement", "findChildByType"));
        }
        return null;
    }

    @Override
    public int hc() {
        return LeafElement.leafHC(this.getChars());
    }

    public static int leafHC(CharSequence text) {
        int len = text.length();
        int hc = 0;
        for (int i = 0; i < len; ++i) {
            hc += text.charAt(i);
        }
        return hc;
    }

    @Override
    public TreeElement getFirstChildNode() {
        return null;
    }

    @Override
    public TreeElement getLastChildNode() {
        return null;
    }

    @Override
    public int getNotCachedLength() {
        return this.myText.length();
    }

    @Override
    public int getCachedLength() {
        return this.getNotCachedLength();
    }

    @Override
    public ASTNode[] getChildren(TokenSet filter) {
        return EMPTY_ARRAY;
    }

    @Override
    public void addChild(@NotNull ASTNode child, ASTNode anchorBefore) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/LeafElement", "addChild"));
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void addLeaf(@NotNull IElementType leafType, CharSequence leafText, ASTNode anchorBefore) {
        if (leafType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leafType", "com/intellij/psi/impl/source/tree/LeafElement", "addLeaf"));
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void addChild(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/LeafElement", "addChild"));
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    @Override
    public void removeChild(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/LeafElement", "removeChild"));
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    @Override
    public void replaceChild(@NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        if (oldChild == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldChild", "com/intellij/psi/impl/source/tree/LeafElement", "replaceChild"));
        }
        if (newChild == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newChild", "com/intellij/psi/impl/source/tree/LeafElement", "replaceChild"));
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    public void replaceAllChildrenToChildrenOf(ASTNode anotherParent) {
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    @Override
    public void removeRange(@NotNull ASTNode first, ASTNode firstWhichStayInTree) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/psi/impl/source/tree/LeafElement", "removeRange"));
        }
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    @Override
    public void addChildren(ASTNode firstChild, ASTNode lastChild, ASTNode anchorBefore) {
        throw new IncorrectOperationException("Leaf elements cannot have children.");
    }

    @Override
    public PsiElement getPsi() {
        return null;
    }

    public <T extends PsiElement> T getPsi(@NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/psi/impl/source/tree/LeafElement", "getPsi"));
        }
        return LeafElement.getPsi(clazz, this.getPsi(), LOG);
    }

    static <T extends PsiElement> T getPsi(@NotNull Class<T> clazz, PsiElement element, Logger log) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/psi/impl/source/tree/LeafElement", "getPsi"));
        }
        log.assertTrue(clazz.isInstance(element), "unexpected psi class. expected: " + clazz + " got: " + (element == null ? null : element.getClass()));
        return (T)element;
    }
}

