/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.SubtypingConstraint;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.List;

public class StrictSubtypingConstraint
implements ConstraintFormula {
    private PsiType myS;
    private PsiType myT;

    public StrictSubtypingConstraint(PsiType t, PsiType s) {
        this.myT = t;
        this.myS = s;
    }

    @Override
    public void apply(PsiSubstitutor substitutor, boolean cache) {
        this.myT = substitutor.substitute(this.myT);
        this.myS = substitutor.substitute(this.myS);
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        if (session.isProperType(this.myS) && session.isProperType(this.myT)) {
            if (this.myT == null) {
                return this.myS == null || this.myS.equalsToText("java.lang.Object");
            }
            if (this.myS == null) {
                return true;
            }
            return TypeConversionUtil.isAssignable(this.myT, this.myS);
        }
        if (PsiType.NULL.equals(this.myT) || this.myT == null) {
            return false;
        }
        if (PsiType.NULL.equals(this.myS) || this.myS == null || this.myT.equalsToText("java.lang.Object")) {
            return true;
        }
        InferenceVariable inferenceVariable = session.getInferenceVariable(this.myS);
        if (inferenceVariable != null) {
            inferenceVariable.addBound(this.myT, InferenceBound.UPPER);
            return true;
        }
        inferenceVariable = session.getInferenceVariable(this.myT);
        if (inferenceVariable != null) {
            inferenceVariable.addBound(this.myS, InferenceBound.LOWER);
            return true;
        }
        if (this.myT instanceof PsiArrayType) {
            if (!(this.myS instanceof PsiArrayType)) {
                return false;
            }
            PsiType tComponentType = ((PsiArrayType)this.myT).getComponentType();
            PsiType sComponentType = ((PsiArrayType)this.myS).getComponentType();
            if (!(tComponentType instanceof PsiPrimitiveType) && !(sComponentType instanceof PsiPrimitiveType)) {
                constraints.add(new StrictSubtypingConstraint(tComponentType, sComponentType));
                return true;
            }
            return sComponentType instanceof PsiPrimitiveType && sComponentType.equals(tComponentType);
        }
        if (this.myT instanceof PsiClassType) {
            PsiClassType.ClassResolveResult TResult = ((PsiClassType)this.myT).resolveGenerics();
            PsiClass CClass = TResult.getElement();
            if (CClass != null) {
                PsiSubstitutor sSubstitutor;
                if (CClass instanceof PsiTypeParameter) {
                    PsiType lowerBound;
                    if (this.myS instanceof PsiIntersectionType) {
                        for (PsiType conjunct : ((PsiIntersectionType)this.myS).getConjuncts()) {
                            if (!this.myT.equals(conjunct)) continue;
                            return true;
                        }
                    }
                    if ((lowerBound = CClass.getUserData(InferenceSession.LOWER_BOUND)) != null) {
                        constraints.add(new StrictSubtypingConstraint(lowerBound, this.myS));
                        return true;
                    }
                    return false;
                }
                PsiClassType.ClassResolveResult SResult = null;
                if (this.myS instanceof PsiIntersectionType) {
                    for (PsiType conjunct : ((PsiIntersectionType)this.myS).getConjuncts()) {
                        PsiClassType.ClassResolveResult conjunctResult;
                        if (!(conjunct instanceof PsiClassType) || !InheritanceUtil.isInheritorOrSelf((conjunctResult = ((PsiClassType)conjunct).resolveGenerics()).getElement(), CClass, true)) continue;
                        SResult = conjunctResult;
                        break;
                    }
                } else if (this.myS instanceof PsiClassType) {
                    SResult = ((PsiClassType)this.myS).resolveGenerics();
                }
                if (SResult == null) {
                    return false;
                }
                PsiClass SClass = SResult.getElement();
                if (((PsiClassType)this.myT).isRaw()) {
                    return SClass != null && InheritanceUtil.isInheritorOrSelf(SClass, CClass, true);
                }
                PsiSubstitutor tSubstitutor = TResult.getSubstitutor();
                PsiSubstitutor psiSubstitutor = sSubstitutor = SClass != null ? TypeConversionUtil.getClassSubstitutor(CClass, SClass, SResult.getSubstitutor()) : null;
                if (sSubstitutor != null) {
                    for (PsiTypeParameter parameter : CClass.getTypeParameters()) {
                        PsiType tSubstituted = tSubstitutor.substitute(parameter);
                        PsiType sSubstituted = sSubstitutor.substituteWithBoundsPromotion(parameter);
                        constraints.add(new SubtypingConstraint(tSubstituted, sSubstituted));
                    }
                    return true;
                }
            }
            return false;
        }
        if (this.myT instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)this.myT).getConjuncts()) {
                constraints.add(new StrictSubtypingConstraint(conjunct, this.myS));
            }
            return true;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StrictSubtypingConstraint that = (StrictSubtypingConstraint)o;
        if (this.myS != null ? !this.myS.equals(that.myS) : that.myS != null) {
            return false;
        }
        return !(this.myT != null ? !this.myT.equals(that.myT) : that.myT != null);
    }

    public int hashCode() {
        int result2 = this.myS != null ? this.myS.hashCode() : 0;
        result2 = 31 * result2 + (this.myT != null ? this.myT.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return this.myS.getPresentableText() + " < " + this.myT.getPresentableText();
    }
}

