/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.javadoc;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NonNls;

class SimpleDocTagInfo
implements JavadocTagInfo {
    private final String myName;
    private final Class myContext;
    private final Class myAdditionalContext;
    private final boolean myInline;
    private final LanguageLevel myLanguageLevel;

    public SimpleDocTagInfo(@NonNls String name, Class context2, boolean isInline, LanguageLevel level) {
        this.myName = name;
        this.myContext = context2;
        this.myAdditionalContext = null;
        this.myInline = isInline;
        this.myLanguageLevel = level;
    }

    public SimpleDocTagInfo(@NonNls String name, Class context2, Class additionalContext, LanguageLevel level) {
        this.myName = name;
        this.myContext = context2;
        this.myAdditionalContext = additionalContext;
        this.myInline = false;
        this.myLanguageLevel = level;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public boolean isValidInContext(PsiElement element) {
        if (PsiUtil.getLanguageLevel(element).compareTo(this.myLanguageLevel) < 0) {
            return false;
        }
        return this.myContext.isInstance(element) || this.myAdditionalContext != null && this.myAdditionalContext.isInstance(element);
    }

    @Override
    public Object[] getPossibleValues(PsiElement context2, PsiElement place, String prefix) {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public String checkTagValue(PsiDocTagValue value) {
        return null;
    }

    @Override
    public PsiReference getReference(PsiDocTagValue value) {
        return null;
    }

    @Override
    public boolean isInline() {
        return this.myInline;
    }
}

